<?php
include('session.php');
include('../config.php');
include('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['strReport_Banner_Report_Head']; ?>
    </title>

    <meta name="description" content="" />
    <style>
        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 250%;
        }

        .tableName {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            /* word-break: break-all; */
        }

        /* Close Button */
        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }

        @media screen and (min-width:700px) {
            .daySelection {
                width: 30%;
                display: flex;
                justify-content: end;
            }
        }

        @media screen and (min-width:420px) and (max-width:699px) {
            .daySelection {
                width: 40%;
                display: flex;
                justify-content: center;
            }

            .main-chart {
                /* width: 200px;
                height: 400px; */
                width: auto;
                height: auto;
                margin: auto;
            }
        }

        @media screen and(min-width:220px) and (max-width:419px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

            .main-chart {
                /* width: 90%; */
                /* height: 2100px; */
                width: auto;
                height: auto;
                margin: auto;
            }

            /* #myChart4{
                width: 227px;
                height: 300px;
            } */

            /* .country-chart{
                width: 100%;
                height: 600px;
            } */
        }

        @media screen and (max-width: 219px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

        }

        .left-col {
            float: left;
            width: 45%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .center-col {
            float: left;
            width: 20%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .right-col {
            float: left;
            width: 35%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        @media only screen and (max-width: 767px) {
            .left-col {
                float: left;
                width: 45%;
                margin-top: 4rem;
                margin-bottom: 2rem;
            }

            .right-col {
                float: left;
                width: 35%;
                margin-top: 1rem;
                margin-bottom: 2rem;
                margin-right: 1px;
            }
        }

        #getBanner {
            width: 40% !important;
        }

        .table #alltotal tr th {
            padding-right: 20px;
        }

        .table tfoot #total,
        #totalall th {
            padding-right: 20px;
            text-align: center;
        }
    </style>
    <?php include('head.php'); ?>
</head>

<body onload="get_advertisers();">
    <div class="loader"></div>
    <input type="hidden" name="clientid" id="clientid" value="<?php echo $_GET['clientid']; ?>" />
    <input type="hidden" name="client_id" id="client_id" value="<?php echo $_GET['client_id']; ?>" />
    <input type="hidden" name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
    <input type="hidden" name="campaign_id" id="campaign_id" value="<?php echo $_GET['campaign_id']; ?>" />
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 ">
                            <div class="card-body">
                                <div class="row mb-2 mt-2">
                                    <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                        <p class="h4" id='reportTitle'>
                                            <?php echo $GLOBALS['strReport_Banner_Report_Head']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row mb-2 mt-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="advertiser_list" name="advertiser_list"
                                            class="form-select text-dark" onchange="get_campaigns('changed');">
                                        </select>
                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="campaign_list" name="campaign_list" class="form-select text-dark"
                                            onchange="onChangeDetails('changed');">
                                        </select>
                                    </div>
                                    <input type='hidden' name="campaignid" id="campaignid"
                                        value="<?php echo $_GET['campaignid']; ?>" />
                                    <input type='hidden' id="startDate" value="<?php echo $_GET['start_date']; ?>" />
                                    <input type='hidden' id="endDate" value="<?php echo $_GET['end_date']; ?>" />
                                    <input type='hidden' id="campaignName"
                                        value="<?php echo $_GET['campaignname']; ?>" />
                                    <input type='hidden' id="client_id" value="<?php echo $_GET['clientid']; ?>" />

                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-warning" id="campaignList_backButton"
                                            onclick="back_button()" style="">
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>&nbsp;&nbsp;
                                        <select id="getBanner" name="allfilter"
                                            class="form-select text-dark daySelection w-30"
                                            aria-label="Default select example" onchange="onChangeDetails(this.value)">
                                            <option value="Today" selected>
                                                <?php echo $GLOBALS['strToday']; ?>
                                            </option>
                                            <option value="Yesterday">
                                                <?php echo $GLOBALS['strYesterday']; ?>
                                            </option>
                                            <option value="Last 7 days">
                                                <?php echo $GLOBALS['strLast_7_days']; ?>
                                            </option>
                                            <option value="Last 30 days">
                                                <?php echo $GLOBALS['strLast 30 days']; ?>
                                            </option>
                                            <option value="Last Month">
                                                <?php echo $GLOBALS['strLast Month']; ?>
                                            </option>
                                            <option value="This Month">
                                                <?php echo $GLOBALS['strThis Month']; ?>
                                            </option>
                                            <option value='All Statistics'>
                                                <?php echo $GLOBALS['strAll Statistics']; ?>
                                            </option>
                                            <option value="Custom">
                                                <?php echo $GLOBALS['strCustom']; ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div
                                    class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <input style="display: none; margin-left:3%;width:20%" id="daterange"
                                        name="daterange" />
                                </div>

                                <hr>
                                <div class="table-responsive text-nowrap">
                                    <table id="bannerrep" class="table table-striped table-responsive">
                                        <thead>
                                            <tr class="text-dark">
                                                <th class="text-dark">
                                                    <?php echo $GLOBALS['strName']; ?>
                                                </th>
                                                <th class="text-dark">
                                                    <?php echo $GLOBALS['view_imp']; ?>
                                                </th>
                                                <th class="text-dark">
                                                    <?php echo $GLOBALS['strImpression']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strClicks']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strConversion']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['view_imp_rate']; ?> %
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strCTR']; ?> %
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strSpend']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strECPM']; ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <thead id="alltotal" style='display:none'>
                                            <tr>
                                                <th class="text-dark text-start">Overall Total:</th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="ban_table"></tbody>
                                        <tfoot id="foot" style="display:none">
                                            <tr id="totalall" style="display:none">
                                                <th class="text-dark text-start">Overall Total:</th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                            <tr id="total">
                                                <th class="text-dark text-start">Total:</th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <script>
                        const token = 'Bearer ' + document.getElementById('token').value;
                        const live_URL = '<?php echo $apistatpath; ?>';
                        var live_URL1 = '<?php echo $apiinvenpath; ?>';
                        let getClientId = document.getElementById('clientid').value;;
                        let getCampaign_Id = document.getElementById('campaign_id').value;
                        let agency_id = document.getElementById('agencyid').value;
                        var agencyid = document.getElementById('agencyid').value;
                        let campaign_id = document.getElementById('campaignid').value;
                        let startDate = document.getElementById('startDate').value;
                        let endDate = document.getElementById('endDate').value;
                        let campaignName = document.getElementById('campaignName').value;
                        let getparams = '<?php echo $_REQUEST['params']; ?>';
                        var cli_id = '<?php echo $_REQUEST['clientid']; ?>';
                        console.log("getClient_id", cli_id);
                        let getTodayDate;
                        let userid = '<?php echo $_SESSION['user_id']; ?>';
                        var permissions = [];

                        if (campaign_id) {
                            document.getElementById('campaignList_backButton').style.display = "block";
                        } else {
                            document.getElementById('campaignList_backButton').style.display = "none";
                        }

                        // API's
                        // let domain_url = live_URL + '/get_agency_banner_statistics/';
                        let campaignBanner_url = live_URL + '/get_agency_campaignwise_banner_statistics/';

                        var advValue = localStorage.getItem('advValue');
                        var camValue = localStorage.getItem("camValue");

                        function get_advertisers() {
                            $.ajax({
                                type: "GET",
                                url: live_URL + '/get_all_advertiser/' + agencyid,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                var client_name = [];
                                if (!data.data) {
                                    $('#advertiser_list').hide();
                                    $('#campaign_list').hide();
                                    $('#warning').show();
                                    $('#warning_msg').html("<?php echo $GLOBALS['orders_warning']; ?>");
                                    onChangeDetails();
                                } else {
                                    $('#advertiser_list').show();
                                    $('#warning').hide();
                                    data.data.map((data) => {
                                        getclientLength = (data.clientname.length > 30) ? (data.clientname.slice(0, 30) + '...') : data.clientname;
                                        client_name += `<option value=${data.clientid} title="${data.clientname}">${getclientLength}</option>`;
                                        document.getElementById('advertiser_list').innerHTML = client_name;
                                    });
                                    if (getClientId != '') {
                                        $('#advertiser_list').val(getClientId);
                                        $('#advertiser_list').attr("disabled", true);
                                    } else if (advValue != '' && advValue != null && advValue != 'undefined') {
                                        $('#advertiser_list option').each(function () {
                                            if (this.value == advValue) {
                                                $("#advertiser_list").val(advValue);
                                            }
                                        });
                                    }
                                    get_campaigns();
                                }
                            });
                        }

                        function get_campaigns(changed) {
                            var advertiser_id = $("#advertiser_list option:selected").val();
                            $.ajax({
                                type: "GET",
                                url: live_URL + '/get_all_campaigns/' + advertiser_id,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                var campaign_name = [];
                                if (!data.data) {
                                    $('#campaign_list').hide();
                                    $('#campaign_list').val('');
                                    $('#warning').show();
                                    $('#warning_msg').html("<?php echo $GLOBALS['campaigns_warning']; ?>");
                                    onChangeDetails();
                                } else {
                                    $('#campaign_list').show();
                                    $('#addBannerButton').attr("disabled", false);
                                    $('#warning').hide();
                                    data.data.map((data) => {
                                        getLength = (data.campaignname.length > 35) ? (data.campaignname.slice(0, 35) + '...') : data.campaignname;
                                        campaign_name += `<option value=${data.campaignid} title="${data.campaignname}" class='text-wrap text-break'>${getLength}</option>`;
                                        document.getElementById('campaign_list').innerHTML = campaign_name;
                                    });
                                    if (changed) {
                                        camValue = '';
                                        localStorage.removeItem('camValue');
                                        location.reload();
                                    }
                                    if (getCampaign_Id != '') {
                                        $('#campaign_list').val(getCampaign_Id);
                                    } else if (campaign_id != '') {
                                        $('#campaign_list').val(campaign_id);
                                        $('#campaign_list').attr("disabled", true);
                                    } else if (camValue != '' && camValue != null && camValue != 'undefined') {
                                        $('#campaign_list option').each(function () {
                                            if (this.value == camValue) {
                                                $("#campaign_list").val(camValue);
                                            }
                                        });
                                    }
                                    onChangeDetails();
                                    localStorage.setItem('advValue', $("#advertiser_list option:selected").val())
                                }

                            });
                        }



                        function onChangeDetails(changed) {
                            var advertiser_id = $("#advertiser_list option:selected").val();
                            //var campaign_id = $("#campaign_list option:selected").val();
                            $(".loader").show();
                            const date = new Date();
                            let getSelectedDay = document.getElementById('getBanner').value;

                            document.getElementById('daterange').style.display = getSelectedDay == 'Custom' ? "block" : "none";

                            if (getSelectedDay == 'Today') {
                                let v3 = JSON.stringify(date).slice(1, 11);
                                getTodayDate = v3;
                                getBannerDate(v3, v3);
                            } else if (getSelectedDay == 'Yesterday') {
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                                getBannerDate(yesterday_date, yesterday_date);
                            } else if (getSelectedDay == 'Last 7 days') {
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date).slice(1, 11);

                                let date1 = new Date();
                                let current_date = date1.setDate(date1.getDate() - 1);
                                const get_7Days = new Date(date1);
                                let date_end = JSON.stringify(get_7Days).slice(1, 11);
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last 30 days') {
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date).slice(1, 11);

                                let date1 = new Date();
                                let current_date = date1.setDate(date1.getDate() - 1);
                                const get_30Days = new Date(date1);
                                let date_end = JSON.stringify(get_30Days).slice(1, 11);
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'This Month') {
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cDate = firstDay.getDate(),
                                    cMonth = firstDay.getMonth() + 1,
                                    cYear = firstDay.getFullYear();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last Month') {
                                let prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                let prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                let formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                let formatDate = function (date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                getBannerDate(formatDate(prevMonthFirstDate), formatDate(prevMonthLastDate));
                            } else if (getSelectedDay == 'All Statistics') {
                                getBannerDate(start_date = 0, end_date = 0);
                            } else if (getSelectedDay == 'Custom') {
                                $(".loader").hide();
                                getBannerDate(getTodayDate, getTodayDate);
                                $(function () {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MM/YYYY'
                                        },
                                    }, function (start, end, label) {
                                        getBannerDate(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                    });
                                })
                            }
                            if (changed) {
                                localStorage.setItem('camValue', $("#campaign_list option:selected").val())
                            }
                        };

                        function getBannerDate(start_date, end_date) {
                            if (cli_id != "") {

                                var getClient_id = cli_id;
                            } else {
                                var getClient_id = $("#advertiser_list option:selected").val();
                            }

                            if (getCampaign_Id != "") {

                                var campaign_id = getCampaign_Id;
                            } else {
                                var campaign_id = $("#campaign_list option:selected").val();
                            }

                            let payload;

                            if (campaign_id == '') {
                                payload = (start_date == 0 && end_date == 0) ? {
                                    "action": 'all'
                                } : {
                                    "action": '',
                                    "start_date": start_date + ' 00:00:00,',
                                    "end_date": end_date + ' 23:59:59,'
                                }
                                console.log('start_date' + start_date);
                                $.ajax({
                                    url: campaignBanner_url + getClient_id + campaign_id,
                                    type: 'POST',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: payload,
                                    success: function (data) {
                                        //$('#hmm').html(data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available' || data.msg == 'Please enter valid Advertiser Id') {
                                            $("#foot").hide();
                                            $('#alltotal').hide();
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                                }
                                            });
                                        } else {
                                            $("#foot").show();
                                            $('#alltotal').show();
                                            $('#bannerrep').DataTable({
                                                ordering: true,
                                                destroy: true,
                                                "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                                                buttons: [{
                                                    extend: 'collection',
                                                    text: 'Export',
                                                    autoClose: true,
                                                    className: 'btn btn-warning btn-sm export',
                                                    buttons: [{
                                                        text: 'Excel',
                                                        extend: 'excel',
                                                        header: true,
                                                        footer: true,
                                                        visible: false,
                                                        "customize": function (xlsx) {
                                                            var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                                            $('row c', sheet).attr('s', '51'); //for all rows
                                                            //$('row:eq(0) c', sheet).attr('s','2');                                                                                                             
                                                            //$('row:eq(1) c', sheet).attr('s', '2');                                                              
                                                        }
                                                    },
                                                    {
                                                        text: 'PDF',
                                                        extend: 'pdf',
                                                        header: true,
                                                        footer: true,
                                                        visible: false,
                                                        // orientation: 'landscape',
                                                        // pageSize: 'LEGAL',
                                                        // customize: function(doc) {
                                                        //     doc.styles.tableBodyEven.alignment = 'center';
                                                        //     doc.styles.tableBodyOdd.alignment = 'center';
                                                        // },
                                                    }
                                                    ],
                                                    fade: true,
                                                }],
                                                data: data,
                                                columns: [{
                                                    data: 'bannername',
                                                    className: 'tableName'
                                                },
                                                {
                                                    data: 'views',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'impressions',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'clicks',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'conversions',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'viewableimpressionrate',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'ctr',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'revenue',
                                                    className: "text-center",
                                                    render: function (data, type, row, meta) {
                                                        return row.revenue == null ? "0.0000" : row.revenue;
                                                    }
                                                },
                                                {
                                                    data: 'ecpm',
                                                    className: "text-center",
                                                    render: function (data, type, row, meta) {
                                                        return row.ecpm == null ? "0.0000" : row.ecpm;
                                                    }
                                                },
                                                ],
                                                "footerCallback": function (row, data, start, end, display) {
                                                    let api = this.api();

                                                    // converting to interger to find total
                                                    let intVal = function (i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ? i : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var view_imp = api
                                                        .column(1, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var impressions = api
                                                        .column(2, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var clicks = api
                                                        .column(3, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var conversions = api
                                                        .column(4, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var revenue = api
                                                        .column(7, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_view_imp = api
                                                        .column(1, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_impressions = api
                                                        .column(2, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_clicks = api
                                                        .column(3, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_conversions = api
                                                        .column(4, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_revenue = api
                                                        .column(7, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    // Update footer by showing the total with the reference of the column index 
                                                    //$(api.column(0).footer()).html('Total');
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(2)').html(view_imp);
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(3)').html(impressions);
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(4)').html(clicks);
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(5)').html(conversions);
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(6)').html((view_imp / impressions * 100).toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(7)').html((clicks / impressions * 100).toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(8)').html(revenue.toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(9)').html((revenue / impressions * 1000).toFixed(2));

                                                    $('#bannerrep #alltotal th:nth-child(2)').html(foot_view_imp);
                                                    $('#bannerrep #alltotal th:nth-child(3)').html(foot_impressions);
                                                    $('#bannerrep #alltotal th:nth-child(4)').html(foot_clicks);
                                                    $('#bannerrep #alltotal th:nth-child(5)').html(foot_conversions);
                                                    $('#bannerrep #alltotal th:nth-child(6)').html((foot_view_imp / foot_impressions * 100).toFixed(2));
                                                    $('#bannerrep #alltotal th:nth-child(7)').html((foot_clicks / foot_impressions * 100).toFixed(2));
                                                    $('#bannerrep #alltotal th:nth-child(8)').html(foot_revenue.toFixed(2));
                                                    $('#bannerrep #alltotal th:nth-child(9)').html((foot_revenue / foot_impressions * 1000).toFixed(2));

                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(2)').html(foot_view_imp);
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(3)').html(foot_impressions);
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(4)').html(foot_clicks);
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(5)').html(foot_conversions);
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(6)').html((foot_view_imp / foot_impressions * 100).toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(7)').html((foot_clicks / foot_impressions * 100).toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(8)').html(foot_revenue.toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(9)').html((foot_revenue / foot_impressions * 1000).toFixed(2));
                                                },
                                                initComplete: function (settings) {
                                                    //settings.nTable.id --> Get table ID
                                                    $('#' + settings.nTable.id + '_filter input').wrap(`
                                                    <div class="d-inline-flex position-relative"></div>
                                              `).after(`
                                                    <button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                      <span aria-hidden="true">&times;</span>
                                                    </button>
                                               `).attr('required', 'required').attr('title', 'Search');

                                                    // Click Event on Clear button
                                                    $(document).on('click', '#' + settings.nTable.id + '_filter button', function () {
                                                        $('#' + settings.nTable.id).DataTable({
                                                            "retrieve": true,
                                                        }).search('').draw(); // reDraw table
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    error: function () { },
                                });
                            } else {
                                <?php if ($_GET['campaignid']) { ?>
                                    document.getElementById('campaignList_backButton').style.display = "block";
                                    //document.getElementById('getBanner').style.display = "none";
                                <?php } else { ?>
                                    document.getElementById('campaignList_backButton').style.display = "none";
                                    //document.getElementById('getBanner').style.display = "block";
                                <?php } ?>
                                //document.getElementById('campaignList_backButton').style.display="none";
                                // let campaignWisher_banner = campaignBanner_url + start_date + ' 00:00:00,' + end_date + ' 23:59:59,' + agency_id + ',' + campaign_id
                                payload = (start_date == 0 && end_date == 0) ? {
                                    "action": 'all'
                                } : {
                                    "action": '',
                                    "start_date": start_date + ' 00:00:00,',
                                    "end_date": end_date + ' 23:59:59,'
                                }
                                $.ajax({
                                    url: campaignBanner_url + getClient_id + ',' + campaign_id,
                                    type: 'POST',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: payload,
                                    success: function (data) {
                                        //$('#hmm').html(data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available' || data.msg == 'Please enter valid Advertiser Id') {
                                            $("#foot").hide();
                                            $('#alltotal').hide();
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                                }
                                            });
                                        } else {
                                            $("#foot").show();
                                            $('#alltotal').show();
                                            //document.getElementById('getBanner').style.display = "none";
                                            <?php if ($_GET['campaignid']) { ?>
                                                document.title = campaignName;
                                                //document.getElementById('reportTitle').innerHTML = document.title;
                                            <?php } ?>
                                            $('#bannerrep').DataTable({
                                                ordering: true,
                                                destroy: true,
                                                "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                                                buttons: [{
                                                    extend: 'collection',
                                                    text: 'Export',
                                                    autoClose: true,
                                                    className: 'btn btn-warning btn-sm export',
                                                    buttons: [{
                                                        text: 'Excel',
                                                        extend: 'excel',
                                                        header: true,
                                                        footer: true,
                                                        visible: false,
                                                        "customize": function (xlsx) {
                                                            var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                                            $('row c', sheet).attr('s', '51'); //for all rows
                                                            //$('row:eq(0) c', sheet).attr('s','2');                                                                                                             
                                                            //$('row:eq(1) c', sheet).attr('s', '2');                                                              
                                                        }
                                                    },
                                                    {
                                                        text: 'PDF',
                                                        extend: 'pdf',
                                                        header: true,
                                                        footer: true,
                                                        visible: false,
                                                        orientation: 'landscape',
                                                        pageSize: 'LEGAL',
                                                        customize: function (doc) {
                                                            doc.styles.tableBodyEven.alignment = 'center';
                                                            doc.styles.tableBodyOdd.alignment = 'center';
                                                            doc.styles.tableFooter.alignment = 'center';
                                                        },
                                                    }
                                                    ],
                                                    fade: true,
                                                }],
                                                data: data,
                                                columns: [{
                                                    data: 'bannername',
                                                    className: 'text-start tableName'
                                                },
                                                {
                                                    data: 'views',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'impressions',
                                                    className: 'text-center'
                                                },
                                                {
                                                    data: 'clicks',
                                                    className: 'text-center'
                                                },
                                                {
                                                    data: 'conversions',
                                                    className: 'text-center'
                                                },
                                                {
                                                    data: 'viewableimpressionrate',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'ctr',
                                                    className: 'text-center'
                                                },
                                                {
                                                    data: 'revenue',
                                                    className: "text-center",
                                                    render: function (data, type, row, meta) {
                                                        return row.revenue == null ? "0.0000" : row.revenue;
                                                    }
                                                },
                                                {
                                                    data: 'ecpm',
                                                    className: "text-center",
                                                    render: function (data, type, row, meta) {
                                                        return row.ecpm == null ? "0.0000" : row.ecpm;
                                                    }
                                                },
                                                ],
                                                "footerCallback": function (row, data, start, end, display) {
                                                    var api = this.api(),
                                                        data;

                                                    // converting to interger to find total
                                                    var intVal = function (i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ?
                                                                i : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var view_imp = api
                                                        .column(1)
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var impressions = api
                                                        .column(2)
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var clicks = api
                                                        .column(3)
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var conversions = api
                                                        .column(4)
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var revenue = api
                                                        .column(7)
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_view_imp = api
                                                        .column(1, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);


                                                    var foot_impressions = api
                                                        .column(2, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_clicks = api
                                                        .column(3, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_conversions = api
                                                        .column(4, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var foot_revenue = api
                                                        .column(7, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    // Update footer by showing the total with the reference of the column index 
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(2)').html(view_imp);
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(3)').html(impressions);
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(4)').html(clicks);
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(5)').html(conversions);
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(6)').html((view_imp / impressions * 100).toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(7)').html((clicks / impressions * 100).toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(8)').html(revenue.toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(2) th:nth-child(9)').html((revenue / impressions * 1000).toFixed(2));

                                                    $('#bannerrep #alltotal th:nth-child(2)').html(foot_view_imp);
                                                    $('#bannerrep #alltotal th:nth-child(3)').html(foot_impressions);
                                                    $('#bannerrep #alltotal th:nth-child(4)').html(foot_clicks);
                                                    $('#bannerrep #alltotal th:nth-child(5)').html(foot_conversions);
                                                    $('#bannerrep #alltotal th:nth-child(6)').html((foot_view_imp / foot_impressions * 100).toFixed(2));
                                                    $('#bannerrep #alltotal th:nth-child(7)').html((foot_clicks / foot_impressions * 100).toFixed(2));
                                                    $('#bannerrep #alltotal th:nth-child(8)').html(foot_revenue.toFixed(2));
                                                    $('#bannerrep #alltotal th:nth-child(9)').html((foot_revenue / foot_impressions * 1000).toFixed(2));

                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(2)').html(foot_view_imp);
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(3)').html(foot_impressions);
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(4)').html(foot_clicks);
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(5)').html(foot_conversions);
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(6)').html((foot_view_imp / foot_impressions * 100).toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(7)').html((foot_clicks / foot_impressions * 100).toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(8)').html(foot_revenue.toFixed(2));
                                                    $('#bannerrep tfoot tr:nth-child(1) th:nth-child(9)').html((foot_revenue / foot_impressions * 1000).toFixed(2));

                                                },
                                            });
                                        }
                                    },
                                    error: function () { },
                                });
                            }
                            $.ajax({
                                type: "GET",
                                url: live_URL1 + '/get_permissions/' + userid,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                console.log(data);
                                let get_data = data.data;
                                if (get_data) {
                                    for (var i = 0; i < get_data.length; i++) {
                                        permissions[i] = get_data[i];
                                    }
                                } else {
                                    permissions = '';
                                }
                                if (!permissions.includes('44')) {
                                    $('.export').hide();
                                } else {
                                    $('.export').show();
                                }
                            });
                        };

                        function back_button() {
                            window.location.href = (getparams != '') ? 'campaignreport.php' :
                                'campaignreport.php?clientid=' + cli_id;
                        }
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>