<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> - Banner
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<style>
    body {
        font-family: "Open Sans", "-apple-system, BlinkMacSystemFont", "Segoe UI", "Roboto", "Oxygen-Sans", "Ubuntu", "Cantarell", "Helvetica Neue", Helvetica, Arial, sans-serif;
    }

    .tableName {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    .tableName:hover {
        text-overflow: clip;
        white-space: normal;
        /* word-break: break-all; */
    }

    .swal-button--danger {
        background-color: #2523b3;
        width: 100px;
    }

    .swal-button--cancel {
        color: white;
        width: 100px;
        background-color: #ff3e1d;
    }

    .swal-button--cancel:not([disabled]):hover {
        background-color: red;
    }

    .swal-button--danger:not([disabled]):hover {
        background-color: #2523b3;
    }

    .swal-footer {
        text-align: center;
    }

    /* .text-hide {
        display: flex;
        width: 130px !important;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
    }

    .text-hide:hover {
        overflow: hidden;
    } */

    .card-body {
        padding: 0 !important;
    }

    .dataTables_scrollBody {
        height: auto !important;
    }

    .table-striped {
        width: 1200px !important;
    }

    .text_convert {
        text-transform: capitalize;
    }

    .loader {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    .align_size {
        width: 800px;
    }

    #image_preview,
    #html5_preview:hover {
        cursor: pointer;
        text-align: center;
    }

    #htmlTag_preview:hover {
        width: 100%;
    }

    #htmlTag_preview:hover {
        color: blue;
        text-decoration: underline;
    }

    .alert {
        display: none;
    }

    img {
        max-width: 100%;
        height: auto;
    }

    #bannerlist {
        width: 30%;
        border-color: #696cff;
        display: inline;
    }
</style>

<body onload="bannerList();">
    <div class="loader"></div>
    <input type="hidden" name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
    <input type="hidden" name="campaign_name" id="campaign_name" value="<?php echo $_GET['campaignName']; ?>" />

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-5">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-3 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3 text-center text-sm-center text-md-start text-lg-start text-xl-start text-xxl-start">
                                            <?php echo $GLOBALS['str_Banner_List_Head']; ?>
                                        </p>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 h-75 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="bannerlist" name="camplist" class="form-select text-dark w-75" onchange=bannerList();>
                                            <option selected value="1"><?php echo $GLOBALS['all_banners']; ?></option>
                                            <option value="0"><?php echo $GLOBALS['active_banners']; ?></option>
                                        </select>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-5 col-xxl-4 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-primary" id="backTo_campaignList" style="margin-right: 2%;" onclick="window.location.href='campaignlist.php'">
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>
                                        <button type="button" class="btn btn-primary" id="deleteBannerButton" style="margin-right: 2%;">
                                            <i class="bx bx-trash bg-label-white" aria-hidden="true" title="Delete"></i>
                                            <?php echo $GLOBALS['strInventory_DeleteCampaign']; ?>
                                        </button>
                                        <button id="addBannerButton" class="btn btn-primary" onclick="bannerAdd()">
                                            <i class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['strInventory_AddBanner']; ?>
                                        </button>
                                    </div>
                                </div>
                                <hr class="solid">
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <p class="alert bg-success alert-dismissible fade show text-white" id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['banner_deleted_successfully']; ?>
                                    </p>
                                </div>
                                <div class="row">
                                    <div class="container mb-2">
                                        <!-- <div class="row">
                                            <div class="col col-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                            <label class="form-label" for="status">Status</label>
                                            <select id="bannerlist" name="camplist" class="form-select text-dark" style="margin-left: 3%;" onchange=bannerList();>
                                                <option selected value="1"><?php echo $GLOBALS['all_banners']; ?></option>
                                                <option value="0"><?php echo $GLOBALS['active_banners']; ?></option>
                                            </select>
                                            </div>
                                        </div> -->
                                        <!-- <form>
                                            <div>
                                                <label class="form-label" for="status">Status</label>
                                                <select id="bannerlist" name="camplist" class="form-select text-dark w-75" onchange=bannerList();>
                                                    <option selected value="1"><?php echo $GLOBALS['all_banners']; ?></option>
                                                    <option value="0"><?php echo $GLOBALS['active_banners']; ?></option>
                                                </select>
                                            </div>
                                        </form> -->

                                        <div class="table-responsive text-nowrap">
                                            <table id="Bannerlist" class="table table-striped table-hover">
                                                <thead>
                                                    <tr class="text-nowrap">
                                                        <th class="th-color text-center">
                                                            <input class="form-check-input" type="checkbox" name="select_all">
                                                        </th>
                                                        <th class="thauth-login-basic.html-color text-start text-center">
                                                            <?php echo $GLOBALS['strName']; ?>
                                                        </th>
                                                        <th class="thauth-login-basic.html-color th-color text-center">
                                                            <?php echo $GLOBALS['strInventory_Campaign_List_Type']; ?>
                                                        </th>
                                                        <th class="thauth-login-basic.html-color th-color text-center">
                                                            <?php echo $GLOBALS['strSize']; ?>
                                                        </th>
                                                        <th class="th-color text-center">
                                                            <?php echo $GLOBALS['strURL']; ?>
                                                        </th>
                                                        <th class="th-color text-center">
                                                            <?php echo $GLOBALS['strUpdate']; ?>
                                                        </th>
                                                        <th class="thauth-login-basic.html-color th-color text-center" style="width:100px">
                                                            <?php echo $GLOBALS['strInventory_Campaign_List_Status']; ?>
                                                        </th>
                                                        <th class="thauth-login-basic.html-color th-color text-center">
                                                            <?php echo $GLOBALS['strInventory_Campaign_List_Action']; ?>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Modal -->
                    <div class="modal fade " id="modalpreview" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-scrollable" role="document">
                            <div class="modal-content" id="modal_preview">
                                <div class="modal-header">
                                    <h5 class="modal-title text-primary" id="exampleModalLabel1">
                                        <?php echo $GLOBALS['bannerpreview']; ?>
                                    </h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body image text-center mb-5">
                                    <div class="row">
                                        <div class="col col-1 col-sm-1 col-md-2 col-lg-2 col-xl-2 col-xxl-2">
                                            <p id="prepend_data" class="text-end">
                                            </p>
                                        </div>
                                        <div class="col col-10 col-sm-10 col-md-8 col-lg-8 col-xl-8 col-xxl-8">
                                            <a href="" id="banner_preview">
                                                <img src="" alt="No image so preview not show" class="center" id="image_preview" />
                                                <div id="html5_id">
                                                    <iframe src="" class="w-100 h-100 border border-secondary" id="html5_preview"></iframe>
                                                    <p id="htmlText_preview"></p>
                                                </div>
                                                <div id="htmlTag_preview"></div>
                                            </a>
                                        </div>
                                        <div class="col col-1 col-sm-1 col-md-2 col-lg-2 col-xl-2 col-xxl-2">
                                            <p id="append_data" class="text-start"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <!-- <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                        Close
                                    </button> -->
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <?php include('footer.php'); ?>

                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper ,className: " text-hide"-->
    <script>
        const live_URL = '<?php echo $apiinvenpath; ?>';
        const token = 'Bearer ' + document.getElementById('token').value;

        let clientid = document.getElementById('clientid').value;
        let getCampaignId = document.getElementById('campaignid').value;
        let getCampaignName = document.getElementById('campaign_name').value;
        let userid = '<?php echo $_SESSION['user_id']; ?>';
        let activeDeactive = live_URL + '/banner_status_update/';
        let domain_url = live_URL + '/get_all_banner/' + clientid;
        let delete_url = live_URL + '/delete_banner/';
        let campaignWishBanner_URL = live_URL + '/get_campaignwise_banner/' + getCampaignId;
        var perm_1 = true;
        var perm_2 = true;
        var perm_4 = true;
        var perm_10 = true;
        var perm_11 = true;

        document.getElementById("deleteBannerButton").disabled = true;
        document.getElementById('append_data').style.display = "none";
        document.getElementById('prepend_data').style.display = "none";
        document.getElementById('backTo_campaignList').style.display = (getCampaignId == "" && getCampaignName == "") ? "none" : "block";

        function bannerList() {
            $(".loader").show();
            var bannerlist_option = $('#bannerlist option:selected').val();

            $.ajax({
                url: getCampaignId ? campaignWishBanner_URL + ',' + bannerlist_option : domain_url + ',' + bannerlist_option,
                type: 'GET',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                success: function(data) {
                    console.log("success data", data);
                    $(".loader").hide();
                    if (data.msg == 'No Data' && data.statuscode == 200) {
                        $('#Bannerlist').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bAutoWidth: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } 
                    else if (data.msg == 'Requested banner not available' && data.statuscode == 200) {
                        $('#Bannerlist').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bAutoWidth: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } 
                    else {
                        let rows_selected = [],
                            getValue, getValue2;
                        let table = $('#Bannerlist').DataTable({
                            destroy: true,
                            targets: 0,
                            searchable: false,
                            fixedColumns: true,
                            orderable: false,
                            // ordering: false,
                            stateSave: true,
                            data: data.data,
                            // sort: true,
                            // order: [
                            //     [5, 'asc']
                            // ],
                            columns: [{
                                    data: 'bannerid',
                                    className: " text-center",
                                    render: function(data, type, row, meta) {
                                        return '<input class="data-checked form-check-input" type="checkbox" name="checkrow" id="checkrow" value="' + row.bannerid + '" data-banner-id="' + row.bannerid + '">';
                                    }
                                },
                                {
                                    data: 'description',
                                    className: "text-start tableName",
                                    render: function(data, type, row, meta) {
                                        if (getCampaignId != "" && getCampaignName != "") {
                                            getValue = '<a class="test " style="width: 14rem;" href="banner_edit.php?bannerid=' + row.bannerid + '&campaignid=' + getCampaignId + '">' + row.description + '</a>';
                                        } else {
                                            getValue = '<a class="test " style="width: 14rem;" href="banner_edit.php?bannerid=' + row.bannerid + '">' + row.description + '</a>';
                                        }
                                        return getValue;
                                    }
                                },
                                {
                                    data: 'storagetype',
                                    className: "text-start",
                                    render: function(data, type, row, meta) {
                                        // return '<div style="width:5rem"><p>'+row.storagetype+'</p></div>';
                                        var storagetype;
                                        if (row.ext_bannertype == "web") {
                                            storagetype = `<?php echo $GLOBALS['strWeb']; ?>`;
                                        } else if (row.ext_bannertype == "sql") {
                                            storagetype = `<?php echo $GLOBALS['strSQL']; ?>`;
                                        } else if (row.ext_bannertype == "url") {
                                            storagetype = `<?php echo $GLOBALS['strURL']; ?>`;
                                        } else if (row.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml") {
                                            storagetype = `<?php echo $GLOBALS['strHTML']; ?>`;
                                        } else if (row.ext_bannertype == "bannerTypeHtml:oxHtml:html5") {
                                            storagetype = `<?php echo $GLOBALS['strHTML_5']; ?>`;
                                        } else if (row.ext_bannertype == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml") {
                                            storagetype = `<?php echo $GLOBALS['inline']; ?>`;
                                        } else if (row.ext_bannertype == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml") {
                                            storagetype = `<?php echo $GLOBALS['overlay']; ?>`;
                                        } else if (row.ext_bannertype == "bannerTypeText:oxText:genericText") {
                                            storagetype = `<?php echo $GLOBALS['strText']; ?>`;
                                        } else {
                                            storagetype = "";
                                        }
                                        return storagetype;
                                    }
                                },
                                {
                                    data: 'width',
                                    className: "text-center",
                                    render: function(data, type, row, meta) {
                                        if (row.width > 0 || row.height > 0) {
                                            // return '<div style="width:7rem"><p>'+row.width + ' * ' + row.height+'</p></div>';
                                            return row.width + ' * ' + row.height;
                                        } else {
                                            // return '<div style="width:5rem"><p> - </p></div>';
                                            return "-"
                                        }
                                    }
                                },
                                {
                                    data: 'url',
                                    className: 'text-start text-wrap text-break'
                                },
                                {
                                    data: 'updated',
                                    className: 'text-center'
                                },
                                {
                                    data: 'status',
                                    // width: '68%',
                                    render: function(data, type, row, meta) {
                                        if (row.status == 0) {
                                            var status = '<div><span class="badge bg-success fw-bold p-2 text_convert text-center" style="width:80px">&nbsp;  <?php echo $GLOBALS['strInventory_Campaign_List_Active']; ?> &nbsp;</span>&nbsp;<a href="#"> <i class="fa fa-toggle-on text-danger" id="Deactivate" aria-hidden="true" title=<?php echo $GLOBALS['deactivate']; ?> style="font-size:20px"  onclick="activeDeactivate(' + row.bannerid + ');"></i></a></div>';
                                        } else {
                                            var status = '<div><span class="badge bg-danger fw-bold p-2 text_convert" style="width:80px">&nbsp;<?php echo $GLOBALS['strInventory_Campaign_List_Inactive']; ?>&nbsp;</span>&nbsp; <a href="#"> <i class="fa fa-toggle-on text-success" id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['activate']; ?> style="font-size:20px;"  onclick="activeDeactivate(' + row.bannerid + ');"></i></a></div>';
                                        }
                                        return status;
                                    },
                                    className: 'urltext text-center',
                                },
                                {
                                    data: 'bannerid',
                                    render: function(data, type, row, meta) {
                                        let actionButtons;
                                        if (row.ext_bannertype == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml") {
                                            actionButtons = '<div class="row"><div class="col-1"><a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-primary atag" id="atag" href="banner_edit.php?bannerid=' + row.bannerid + '"><i class="bx bx-edit mt-0 label-primary " " style="font-size:14px"></i></a>&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-primary" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a>&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash label-Primary" style="font-size:15px;color:white;" title=<?php echo $GLOBALS['delete']; ?> onclick="deleteBanner(' + row.bannerid + ')"></i></a></div></div>';
                                        } else if (row.ext_bannertype == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml") {
                                            actionButtons = '<div class="row"><div class="col-1"><a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-primary atag" id="atag" href="banner_edit.php?bannerid=' + row.bannerid + '"><i class="bx bx-edit mt-0 label-primary" " style="font-size:14px"></i></a>&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-primary" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a>&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash label-Primary" style="font-size:15px;color:white;" title=<?php echo $GLOBALS['delete']; ?> onclick="deleteBanner(' + row.bannerid + ')"></i></a></div></div>';
                                        }
                                        // else if (row.ext_bannertype == "bannerTypeText:oxText:genericText") {
                                        //     actionButtons = '<div class="row"><div class="col-1"><a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?> class="btn btn-icon btn-xs btn-primary" href="banner_edit.php?bannerid=' + row.bannerid + '"><i class="bx bx-edit mt-0 label-primary" " style="font-size:14px"></i></a>&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-primary" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a>&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash label-Primary" style="font-size:15px;color:white;" title=<?php echo $GLOBALS['delete']; ?> onclick="deleteBanner(' + row.bannerid + ')"></i></a></div></div>';
                                        // } 
                                        // else if (row.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml") {
                                        //     actionButtons = '< class="row">< class="col-1"><a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?> class="btn btn-icon btn-xs btn-primary" href="banner_edit.php?bannerid=' + row.bannerid + '"><i class="bx bx-edit mt-0 label-primary" " style="font-size:14px"></i></a>&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-primary" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a>&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash label-Primary" style="font-size:15px;color:white;" title=<?php echo $GLOBALS['delete']; ?> onclick="deleteBanner(' + row.bannerid + ')"></i></a></div></div>';
                                        // } 
                                        else {
                                            if (getCampaignId != "" && getCampaignName != "") {
                                                actionButtons = '<a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-primary atag" id="atag" href="banner_edit.php?bannerid=' + row.bannerid + '&campaignid=' + getCampaignId + '"><i class="bx bx-edit mt-0 label-primary" " style="font-size:14px"></i></a>&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-primary" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a>&nbsp;<button type="button" title=<?php echo $GLOBALS['bannerpreview_list']; ?> id="preview_button" onclick="previewBanner(' + row.bannerid + ')" class="btn btn-icon btn-xs btn-primary" data-bs-toggle="modal" data-bs-target="#modalpreview"><i class="bx bx-show"></i></button>&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash label-Primary" style="font-size:15px;color:white;" title=<?php echo $GLOBALS['delete']; ?> onclick="deleteBanner(' + row.bannerid + ')"></i></a>';
                                            } else {
                                                actionButtons = '<a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-primary atag" id="atag" href="banner_edit.php?bannerid=' + row.bannerid + '"><i class="bx bx-edit mt-0 label-primary" " style="font-size:14px"></i></a>&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-primary" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a>&nbsp;<button type="button" title=<?php echo $GLOBALS['bannerpreview_list']; ?> id="preview_button" onclick="previewBanner(' + row.bannerid + ')" class="btn btn-icon btn-xs btn-primary" data-bs-toggle="modal" data-bs-target="#modalpreview"><i class="bx bx-show"></i></button>&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash label-Primary" style="font-size:15px;color:white;" title=<?php echo $GLOBALS['delete']; ?> onclick="deleteBanner(' + row.bannerid + ')"></i></a>';
                                            }
                                        }
                                        return actionButtons;
                                    }
                                },
                            ],
                        });

                        // Handle click on checkbox
                        $('#Bannerlist tbody').on('click', 'input[type="checkbox"]', function(e) {
                            let $row = $(this).closest('tr');
                            let data = table.row($row).data();
                            let rowId = table.row(this).data[0];
                            let index = $.inArray(rowId, rows_selected);

                            if (this.checked && index === -1) {
                                rows_selected.push(rowId);
                            } else if (!this.checked && index !== -1) {
                                rows_selected.splice(index, 1);
                            }

                            if (this.checked) {
                                $row.addClass('selected');
                                document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            } else {
                                $row.removeClass('selected');
                                document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            }
                            updateDataTableSelectAllCtrl(table);
                            e.stopPropagation();
                        });

                        // Handle click on "Select all" control
                        $('thead input[name="select_all"]', table.table().container()).on('click', function(e) {
                            if (this.checked) {
                                $('#Bannerlist tbody input[type="checkbox"]:not(:checked)').trigger('click');
                                document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            } else {
                                $('#Bannerlist tbody input[type="checkbox"]:checked').trigger('click');
                                document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            }
                            e.stopPropagation();
                        });

                        // Handle table draw event
                        table.on('draw', function() {
                            updateDataTableSelectAllCtrl(table);
                        });
                    }
                },
                error: function(xhr, status, errorThrown) {
                    console.log("error");
                    // $('#Bannerlist').DataTable({
                    //     ordering: false,
                    //     destroy: true,
                    //     responsive: true,
                    //     bPaginate: false,
                    //     bAutoWidth: false,
                    //     bInfo: false,
                    //     data: [],
                    //     searching: false,
                    //     oLanguage: {
                    //         sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                    //     }
                    // });
                },
                // error: checkError()
            });
            check_permissions();
        };

        // checkError = (xhr, ajaxOptions, thrownError) => {
        //     console.log("error1", thrownError);
        // }

        bannerAdd = () => {
            window.location.href = (getCampaignId == '' && getCampaignName == '') ? 'banner_add.php' :
                'banner_add.php?campaignid=' + getCampaignId + '&campaign_name=' + getCampaignName + '';
        };

        previewBanner = (bannerId) => {
            $.ajax({
                url: live_URL + '/get_banner/' + bannerId,
                type: 'GET',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                success: function(data) {
                    document.getElementById('image_preview').src = data.data.imageurl;
                    document.getElementById('html5_preview').src = data.data.imageurl;
                    document.getElementById('html5_preview').style.display = data.data.ext_bannertype == 'bannerTypeHtml:oxHtml:html5' ? "block" : "none";
                    document.getElementById('image_preview').style.display = data.data.ext_bannertype == 'web' ? 'inline' :
                        data.data.ext_bannertype == 'sql' ? 'inline' : data.data.ext_bannertype == 'url' ? 'inline' :
                        data.data.ext_bannertype == "bannerTypeText:oxText:genericText" ? "none" : "none";
                    document.getElementById('append_data').style.display = data.data.append == "" ? "none" : "block";
                    document.getElementById('prepend_data').style.display = data.data.prepend == "" ? "none" : "block";
                    document.getElementById('append_data').innerHTML = data.data.append;
                    document.getElementById('prepend_data').innerHTML = data.data.prepend;
                    document.getElementById('banner_preview').href = data.data.url !== "" ? data.data.url : "";
                    document.getElementById('banner_preview').target = data.data.url !== "" ? "_blank" : "";

                    document.getElementById('htmlText_preview').style.display = data.data.ext_bannertype == "bannerTypeText:oxText:genericText" ? "block" : "none";
                    document.getElementById('htmlText_preview').innerHTML = (data.data.ext_bannertype == "bannerTypeText:oxText:genericText" && data.data.bannertext == "") ? `<?php echo $GLOBALS['no_text']; ?>` : data.data.bannertext;
                    document.getElementById('htmlText_preview').style.color = (data.data.ext_bannertype == "bannerTypeText:oxText:genericText" && data.data.url == "") ? "black" : "blue";
                    document.getElementById('htmlText_preview').style.cursor = (data.data.ext_bannertype == "bannerTypeText:oxText:genericText" && data.data.url == "") ? "context-menu" : "pointer";

                    document.getElementById('htmlTag_preview').innerHTML = data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" ? `${data.data.htmltemplate}` : "";
                    document.getElementById('htmlTag_preview').style.display = data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" ? "block" : "none";
                    document.getElementById('htmlTag_preview').style.color = (data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" && data.data.url == "") ? "black" : "blue";
                    document.getElementById('htmlTag_preview').style.cursor = (data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" && data.data.url == "") ? "context-menu" : "pointer";
                    document.getElementById('htmlTag_preview').style.textDecoration = (data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" && data.data.url == "") ? "" : "underline";
                }
            });
        };

        function activeDeactivate(bannerid) {
            swal({
                title: `<?php echo $GLOBALS['update_status']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        type: "POST",
                        url: activeDeactive + bannerid,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        if (data.msg == "Banner Activated successfully!") {
                            location.reload();
                            // $("#activestatus").css("color", "#696cff");
                        } else {
                            location.reload();
                            // $("#activestatus").css("color", "#777");  
                        }
                    });
                } else {
                    console.log(campaignid);
                }
            });
        };

        function deleteBanner(bannerid) {
            swal({
                title: `<?php echo $GLOBALS['want_delete_banner']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {
                $(".loader").show();
                if (isConfirm) {
                    $.ajax({
                        url: delete_url + bannerid,
                        type: "DELETE",
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        if (data.msg = "Banner deleted successfully!" && data.statuscode == 200) {
                            $("#alertsuccess").show('medium');
                            setTimeout(function() {
                                $("#alertsuccess").hide('medium');
                            }, 1700);
                            setTimeout(function() {
                                location.reload();
                            }, 1700);
                        }
                    })
                    $(".loader").hide();
                } else {
                    // swal("Banner is Not Delete");
                    $(".loader").hide();
                }
            });
        };

        $('#deleteBannerButton').on('click', function(e) {
            let employee = [];
            $(".data-checked:checked").each(function() {
                employee.push($(this).attr('data-banner-id'));
            });
            if (employee.length <= 0) {
                alert("Please select records.");
            }
            swal({
                title: `<?php echo $GLOBALS['want_delete_banner']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {
                $(".loader").show();
                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: delete_url + employee,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        if (data.msg = "Banner deleted successfully!" && data.statuscode == 200) {
                            $("#alertsuccess").show('medium');
                            setTimeout(function() {
                                $("#alertsuccess").hide('medium');
                            }, 1700);
                            setTimeout(function() {
                                location.reload();
                            }, 1700);
                        }
                    });
                    $(".loader").hide();
                } else {
                    // swal("Banner Not Deleted");
                    $(".loader").hide();
                }

            });
        });

        $(document).on('click', '.data-checked', function() {
            document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
            document.getElementById('select-all').checked = ($('.data-checked:checked').length == $('.data-checked').length) ? true : false;

            // if ($('.data-checked:checked').length == $('.data-checked').length) {
            //     $('#select-all').prop('checked', true);
            // } else {
            //     $('#select-all').prop('checked', false);
            // }
            // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
        });

        function updateDataTableSelectAllCtrl(table) {
            var $table = table.table().node();
            var $chkbox_all = $('tbody input[type="checkbox"]', $table);
            var $chkbox_checked = $('tbody input[type="checkbox"]:checked', $table);
            var chkbox_select_all = $('thead input[name="select_all"]', $table).get(0);

            // If none of the checkboxes are checked
            if ($chkbox_checked.length === 0) {
                chkbox_select_all.checked = false;
                if (chkbox_select_all) {
                    chkbox_select_all = false;
                }
                // If all of the checkboxes are checked
            } else if ($chkbox_checked.length === $chkbox_all.length) {
                chkbox_select_all.checked = true;
                if (chkbox_select_all) {
                    chkbox_select_all.indeterminate = false;
                }
                // If some of the checkboxes are checked
            } else {
                chkbox_select_all.checked = false;
            }
        }

        function check_permissions() {
            $.ajax({
                url: live_URL + '/get_permissions/' + userid,
                type: 'GET',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
            }).done(function(data) {
                if (data.data) {
                    for (var i = 0; i < data.data.length; i++) {
                        var per_val = data.data[i].permission_id;
                        //console.log(per_val);
                        if (per_val == "1") {
                            perm_1 = false;
                        }
                        if (per_val == "2") {
                            perm_2 = false;
                        }
                        if (per_val == "4") {
                            perm_4 = false;
                        }
                        if (per_val == "10") {
                            perm_10 = false;
                        }
                        if (per_val == "11") {
                            perm_11 = false;
                        }
                    }
                }
                console.log(perm_1, perm_2, perm_4, perm_10, perm_11);
                if (perm_4 == true) {
                    $('.atag').on("click", function(e) {
                        e.preventDefault();
                    });
                }
            });
        }

        // function bannerlist() {
        //     var camplist_option = $('#bannerlist option:selected').val();
        //     $.ajax({
        //         type: "GET",
        //         url: campaignAllStats_URL + ','+ camplist_option,
        //         beforeSend: function (xhr) {
        //             xhr.setRequestHeader('Authorization', token);
        //         },
        //         data: {},
        //         dataType: "json",
        //         encode: true,
        //     }).done(function (data) {
        //         console.log(data);
        //         showdata(data);
        //     });
        // }
    </script>
</body>

</html>