<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['user_access']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

    <style>
        .swal-button--danger {
            background-color: #2523b3;
        }

        .swal-button--cancel {
            color: white;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .text-hide {
            display: block;
            width: 270px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: hidden;
        }

        .card-body {
            padding: 0 !important;
        }

        select {
            float: right;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload="get_userdetails();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-5">
                            <div class="card-header">
                                <div class="row">
                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                        id="alertsuccess1"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['useraccess_success']; ?>
                                    </p>
                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                        id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['user_success_msg_mail']; ?>
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['user_failed_msg']; ?>
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed1">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['user_exist']; ?>
                                    </p>
                                </div>
                                <div class="row">
                                    <p class="h4">
                                        <?php echo $GLOBALS['useraccess']; ?> <span id="username1"
                                            class="text-secondary"></span>
                                    </p>
                                    <hr class="solid">
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="row mb-2" style="padding-left:5%">
                                        <div class="col-4">
                                            <label class="col-form-label">
                                                <?php echo $GLOBALS['strUsername']; ?><span
                                                    class="required text-danger">
                                                    *</span>
                                            </label>
                                        </div>
                                        <div class="col-6">
                                            <!-- <?php echo $GLOBALS['']; ?><span id="username1" class="text-dark"></span> -->
                                            <input type="text" class="form-control" id="username" name="username"
                                                style="" disabled>
                                        </div>
                                    </div>

                                    <div class="row mb-2" style="padding-left:5%">
                                        <div class="col-4">
                                            <label class="col-form-label">
                                                <?php echo $GLOBALS['contact_name']; ?><span
                                                    class="required text-danger">
                                                    *</span>
                                            </label>
                                        </div>
                                        <div class="col-6">
                                            <!-- <?php echo $GLOBALS['']; ?><span id="contactname" class="text-dark"></span> -->
                                            <input type="text" class="form-control" id="contactname" name="contactname"
                                                onkeyup="onchangecontact(this.value);"
                                                onchange="onchangecontact(this.value);" disabled>
                                            <span id="contact_msg" style="color:red"> </span>
                                        </div>
                                    </div>

                                    <div class="row mb-1" style="padding-left:5%">
                                        <div class="col-4">
                                            <label class="col-form-label">
                                                <?php echo $GLOBALS['Email']; ?><span class="required text-danger">
                                                    *</span>
                                            </label>
                                        </div>
                                        <div class="col-6">
                                            <!-- <?php echo $GLOBALS['']; ?><span id="email" class="text-dark"></span> -->
                                            <input type="text" class="form-control" id="email" name="email" style=""
                                                onkeyup="onchangeemail(this.value);"
                                                onchange="onchangeemail(this.value);" disabled>
                                            <span id="email_msg" style="color:red"> </span>
                                        </div>
                                    </div>

                                    <div class="row mb-2" style="padding-left:5%">
                                        <div class="col-4">
                                            <label class="col-form-label">
                                                <?php echo $GLOBALS['language']; ?>
                                            </label>
                                        </div>
                                        <div class="col-6">
                                            <label class="col-form-label">
                                                <select class="form-select text-dark" name="language" id="language"
                                                    disabled>
                                                    <option value="en">
                                                        <?php echo $GLOBALS['english']; ?>
                                                    </option>
                                                    <option value="de">
                                                        <?php echo $GLOBALS['deutsch']; ?>
                                                    </option>
                                                </select>
                                        </div>
                                    </div>

                                    <div class="row" style="padding-left:5%;">
                                        <p class="h5 mt-4" id="userperm">
                                            <?php echo $GLOBALS['permissions']; ?>
                                        </p>
                                        <hr class="solid">
                                        <div class="col-12 mb-1 user_perm" id="perm_10">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_10" name="permissions[]" value="10">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_users']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_12">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_12" name="permissions[]" value="12">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_user_delete']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_31">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_31" name="permissions[]" value="31">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_create_orders_jobs']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_32">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_32" name="permissions[]" value="32">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_delete_orders_jobs']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_33">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_33" name="permissions[]" value="33">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_create_campaign']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_34">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_34" name="permissions[]" value="34">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_delete_campaign']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_35">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_35" name="permissions[]" value="35">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_create_banner']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_36">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_36" name="permissions[]" value="36">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_delete_banner']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_37">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_37" name="permissions[]" value="37">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_delivery_options']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_38">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_38" name="permissions[]" value="38">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_create_webisite']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_39">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_39" name="permissions[]" value="39">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_delete_webisite']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_40">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_40" name="permissions[]" value="40">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_create_zone']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_41">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_41" name="permissions[]" value="41">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_delete_zone']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_42">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_42" name="permissions[]" value="42">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_export_ad_tag']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_43">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_43" name="permissions[]" value="43">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_view_statistics_reports']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_44">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_44" name="permissions[]" value="44">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_export_statistics_reports']; ?>
                                            </label>
                                        </div>
                                        <div class="col-12 mb-1 user_perm" id="perm_45">
                                            <input type="checkbox" class="form-check-input permission_check"
                                                id="permissions_45" name="permissions[]" value="45">
                                            <label class="">&nbsp;
                                                <?php echo $GLOBALS['allow_export_notification_emails']; ?>
                                            </label>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row mb-3">
                                        <div
                                            class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        </div>
                                        <div
                                            class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button type="button" class="btn btn-warning " style="position:relative;"
                                                id="back"
                                                onclick="window.location.href='agency_user_start.php?agencyid=<?php echo $_SESSION['agencyid']; ?>'">
                                                <?php echo $GLOBALS['']; ?>back
                                            </button>&nbsp;
                                            <button type="button" class="btn btn-warning " style="position:relative;"
                                                onclick="add_permission();" id="submitbtn">
                                                <?php echo $GLOBALS['save_changes']; ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- / Content -->

                    <!-- Footer -->

                    <?php include('footer.php'); ?>

                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var agencyid = '<?php echo $_GET['agencyid']; ?>';
        var user_id = '<?php echo $_GET['user_id']; ?>';
        var username1 = '<?php echo $_GET['login']; ?>';



        function get_userdetails() {
            if (user_id == '') {
                $('#userperm').show();
                $.ajax({
                    url: live_URL + '/get_user_new/' + username1,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    dataType: 'json',
                    encode: true,
                    success: function (data) {
                        if (data.length > 0) {
                            for (i = 0; i < data.length; i++) {
                                var username = data[i].username;
                                $('#username1').html(username);
                                var user_id = data[i].user_id;
                                if (username == username1) {
                                    var user = $("#username").val(username);
                                    if (user != '') {
                                        $("#username").prop('disabled', true);
                                    } else {
                                        $("#username").prop('disabled', false);
                                    }
                                    var contact = $("#contactname").val(data[i].contact_name);
                                    if (contact != '') {
                                        $("#contactname").prop('disabled', true);
                                    } else {
                                        $("#contactname").prop('disabled', false);
                                    }
                                    var email = $("#email").val(data[i].email_address);
                                    if (email != '') {
                                        $("#email").prop('disabled', true);
                                    } else {
                                        $("#email").prop('disabled', false);
                                    }
                                    var lang = $("#language").val(data[i].language);
                                    if (lang != '') {
                                        $("#language").prop('disabled', true);
                                    } else {
                                        $("#language").prop('disabled', false);
                                    }
                                    $(".permission_check").prop('checked', false);
                                    get_permissions(user_id);
                                } else {
                                    $("#username").val(username1);
                                    $(".permission_check").prop('checked', true);
                                }
                            }
                        } else {
                            $("#username").val(username1);
                            $('#username1').html(username1);
                            $("#username").prop('disabled', false);
                            $("#contactname").prop('disabled', false);
                            $("#email").prop('disabled', false);
                            $("#language").prop('disabled', false);
                            $(".permission_check").prop('checked', true);
                        }

                    },
                    error: function () { },
                });
            } else {
                $(".user_perm").hide();
                $('#userperm').hide();
                $.ajax({
                    url: live_URL + '/get_user_details/' + user_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    dataType: 'json',
                    encode: true,
                }).done(function (data) {
                    document.getElementById('username').value = data.username;
                    var x = data.username;
                    $('#username1').html(x);
                    document.getElementById('contactname').value = data.contact_name;
                    document.getElementById('email').value = data.email_address;
                    if (data.language == 'key=0') {
                        language = 'en';
                    } else {
                        language = data.language;
                    }
                    document.getElementById('language').value = language;
                    $("#back").hide();
                    get_permissions(user_id);
                });
            }
        }

        function get_permissions(user_id) {
            $.ajax({
                url: live_URL + '/get_permissions/' + user_id,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
            }).done(function (data) {
                if (data.msg == 'success') {
                    $('#userperm').show();
                    for (var i = 0; i < data.data.length; i++) {
                        document.getElementById("perm_" + data.data[i]).style.display = "block";
                        $("#permissions_" + data.data[i]).prop('checked', true);
                        $("#perm_" + data.data[i]).show();
                    }
                } else {
                    $('#userperm').hide();
                    $('#submitbtn').hide();
                }
            });
        }

        function onchangecontact(that) {
            if (that == "") {
                document.getElementById('contact_msg').innerHTML = '<?php echo $GLOBALS['enter_contact']; ?>';
                document.getElementById('contact_msg').style.color = "red";
            } else if (that !== "") {
                document.getElementById('contact_msg').innerHTML = "";
            }
        }

        function onchangeemail(that) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

            if (that == '') {
                $("#email_msg").html("<?php echo $GLOBALS['enter_emailid']; ?>");
                $("#email_msg").css("color", "red").val(that);
            }
            else if (regex.test(that) == false) {
                $("#email_msg").html("<span style='padding-top:10px;'><?php echo $GLOBALS['enter_right_emailid']; ?></span>");
                //$("#txtContactEmail").val('');
                $("#email_msg").css("color", "red").val(that);
            } else {
                $("#email_msg").html("");
            }
        }

        function add_permission() {
            if ($("#username").prop('disabled') == true) {
                edit_permission();
            } else {
                save_permission();
            }
        }

        function save_permission() {
            var formData = [];
            var check_vals = [];
            var username = $("#username").val();
            var contactname = $("#contactname").val();
            var email = $("#email").val();
            var language = $("#language").val();

            if (contactname == "") {
                document.getElementById('contact_msg').innerHTML = '<?php echo $GLOBALS['enter_contact']; ?>';
                document.getElementById('contact_msg').style.color = "red";
            } else {
                document.getElementById('contact_msg').innerHTML = "";
            }

            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

            if (email == '') {
                $("#email_msg").html("<?php echo $GLOBALS['enter_emailid']; ?>");
                $("#email_msg").css("color", "red").val(email);
            }

            else if (regex.test(email) == false) {
                $("#email_msg").html("<span style='padding-top:10px;'><?php echo $GLOBALS['enter_right_emailid']; ?></span>");
                $("#email_msg").css("color", "red").val(email);
            } else {
                $("#email_msg").html("");
            }

            $('.permission_check:checked').each(function () {
                check_vals += this.value + ',';
            });
            var check_val = check_vals.toString().replace(/(^,)|(,$)/g, "");
            var formData = {
                "username": "" + username + "",
                "contactname": "" + contactname + "",
                "email": "" + email + "",
                "language": "" + language + "",
                "check_val": "" + check_val + "",
            };
            $.ajax({
                url: live_URL + '/addusernew_test/' + agencyid,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: formData,
            }).done(function (data) {
                if (data.msg == 'User Created sucessfully') {
                    window.scrollTo(0, 0);
                    $("#alertsuccess").show('medium');
                    setTimeout(function () {
                        $("#alertsuccess").hide('medium');
                    }, 1700);
                    setTimeout(function () {
                        window.location.href = "agency_access.php";
                    }, 1700);
                } else if (data.msg == 'Username already exists') {
                    window.scrollTo(0, 0);
                    $("#alertfailed1").show('medium');
                    setTimeout(function () {
                        $("#alertfailed1").hide('medium');
                    }, 2000);
                } else {
                    window.scrollTo(0, 0);
                    $("#alertfailed").show('medium');
                    setTimeout(function () {
                        $("#alertfailed").hide('medium');
                    }, 2000);
                }
            });
        }

        function edit_permission() {
            var username = $("#username").val();
            var formData = [];
            var check_vals = [];
            $('.permission_check:checked').each(function () {
                check_vals += this.value + ',';
            });
            var check_val = check_vals.toString().replace(/(^,)|(,$)/g, "");
            var formData = {
                "check_val": "" + check_val + "",
            };
            $.ajax({
                url: live_URL + '/update_user/' + username + ',' + agencyid,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: formData,
            }).done(function (data) {
                if (data.msg == 'user permission has been updated successfully!') {
                    window.scrollTo(0, 0);
                    $("#alertsuccess1").show('medium');
                    setTimeout(function () {
                        $("#alertsuccess1").hide('medium');
                    }, 1700);
                    setTimeout(function () {
                        window.location.href = "agency_access.php";
                    }, 1700);
                }
            });
        }
    </script>
</body>

</html>