<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['adv_user']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

    <style>
        .swal-button--danger {
            background-color: #2523b3;
        }

        .swal-button--cancel {
            color: white;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .text-hide {
            display: block;
            width: 270px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: hidden;
        }

        .card-body {
            padding: 0 !important;
        }

        select {
            float: right;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload="get_userdetails();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-5">
                            <div class="card-header">
                                <div class="row">
                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                        id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['']; ?>user has been created successfully
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['']; ?>user has been created failed
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed1">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['']; ?>User name alreay exists
                                    </p>
                                </div>
                                <div class="row">
                                    <p class="h4">
                                        <?php echo $GLOBALS['advertiser']; ?> <span id="username1"
                                            class="text-secondary"></span>
                                    </p>
                                    <hr class="solid">
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="container">
                                        <div class="row mb-1">
                                            <p class="h5 mb-4">
                                                <?php echo $GLOBALS['user_details']; ?>
                                            </p>
                                            <hr class="solid">
                                        </div>

                                        <div class="row mb-2" style="padding-left:5%">
                                            <div class="col-4">
                                                <label class="col-form-label">
                                                    <?php echo $GLOBALS['strUsername']; ?>
                                                </label>
                                            </div>
                                            <div class="col-6">
                                                <!-- <?php echo $GLOBALS['']; ?><span id="username1" class="text-dark"></span> -->
                                                <input type="text" class="form-control" id="username" name="username"
                                                    style="">
                                            </div>
                                        </div>

                                        <div class="row mb-2" style="padding-left:5%">
                                            <div class="col-4">
                                                <label class="col-form-label">
                                                    <?php echo $GLOBALS['contact_name']; ?>
                                                </label>
                                            </div>
                                            <div class="col-6">
                                                <!-- <?php echo $GLOBALS['']; ?><span id="contactname" class="text-dark"></span> -->
                                                <input type="text" class="form-control" id="contactname"
                                                    name="contactname" style="">
                                            </div>
                                        </div>

                                        <div class="row mb-1" style="padding-left:5%">
                                            <div class="col-4">
                                                <label class="col-form-label">
                                                    <?php echo $GLOBALS['Email']; ?>
                                                </label>
                                            </div>
                                            <div class="col-6">
                                                <!-- <?php echo $GLOBALS['']; ?><span id="email" class="text-dark"></span> -->
                                                <input type="text" class="form-control" id="email" name="email"
                                                    style="">
                                            </div>
                                        </div>

                                        <div class="row mb-1" style="padding-left:5%">
                                            <div class="col-4">
                                                <label class="col-form-label">
                                                    <?php echo $GLOBALS['language']; ?>
                                                </label>
                                            </div>
                                            <div class="col-6">
                                                <label class="col-form-label">
                                                    <select class="form-select text-dark" name="language" id="language">
                                                        <option value="en">
                                                            <?php echo $GLOBALS['english']; ?>
                                                        </option>
                                                        <option value="de">
                                                            <?php echo $GLOBALS['deutsch']; ?>
                                                        </option>
                                                    </select>
                                            </div>
                                        </div>
                                        <hr class="solid">

                                        <div class="row mb-1">
                                            <p class="h5 mt-4">
                                                <?php echo $GLOBALS['permissions']; ?>
                                            </p>
                                            <hr class="solid">
                                        </div>

                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_10" name="permissions[]" value="10">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['allow_users']; ?>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_4" name="permissions[]" value="4">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['allow_modify_ban']; ?>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_2" name="permissions[]" value="2">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['allow_deactivate_ban']; ?>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_1" name="permissions[]" value="1">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['allow_activate_ban']; ?>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_11" name="permissions[]" value="11">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['allow_audit_trial']; ?>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_21" name="permissions[]" value="21">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['']; ?>Allow this user to make delivery options
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_22" name="permissions[]" value="22">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['']; ?>Allow this user to create their own
                                                    campaign
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_23" name="permissions[]" value="23">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['']; ?> Allow this user to edit campaign
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_24" name="permissions[]" value="24">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['']; ?>Allow this user to delete campaign
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_25" name="permissions[]" value="25">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['']; ?>Allow this user to Create Banner
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-left:5%">
                                            <div class="col-6">
                                                <input type="checkbox" class="form-check-input permission_check"
                                                    id="permissions_26" name="permissions[]" value="26">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['']; ?>Allow this user to Delete Banner
                                                </label>
                                            </div>
                                        </div>
                                        <hr class="solid"><br>
                                        <button type="button" class="btn btn-primary " style="position:relative;"
                                            onclick="window.location.href='advertiser_user_start.php?clientid=<?php echo $_GET['clientid']; ?>'">
                                            <?php echo $GLOBALS['']; ?>back
                                        </button>&nbsp;
                                        <button type="button" class="btn btn-primary " style="position:relative;"
                                            onclick="add_permission();">
                                            <?php echo $GLOBALS['']; ?>Add user
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- / Content -->

                    <!-- Footer -->

                    <?php include('footer.php'); ?>

                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';
        var agencyid = '<?php echo $_SESSION['agencyid']; ?>';
        var username1 = '<?php echo $_GET['login']; ?>';
        //alert(clientid);
        //$("#username1").val(username);

        function get_userdetails() {
            $.ajax({
                url: live_URL + '/get_user_new/' + clientid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    console.log(data);
                    for(i=0;i<data.length;i++){
                        var username=data[i].username;
                        var user_id=data[i].user_id;
                        if(username==username1){
                            var user=$("#username").val(username);
                            if(user!=''){
                                $("#username").prop('disabled',true); 
                            }else{
                                $("#username").prop('disabled',false); 
                            }
                            var contact=$("#contactname").val(data[i].contact_name);
                            if(contact!=''){
                                $("#contactname").prop('disabled',true); 
                            }else{
                                $("#contactname").prop('disabled',false); 
                            }
                            var email=$("#email").val(data[i].email_address);
                            if(email!=''){
                                $("#email").prop('disabled',true); 
                            }else{
                                $("#email").prop('disabled',false); 
                            }
                            var lang=$("#language").val(data[i].language);
                            if(lang!=''){
                                $("#language").prop('disabled',true); 
                            }else{
                                $("#language").prop('disabled',false); 
                            }
                            $(".permission_check").prop('checked',false);
                            get_permissions(user_id);
                        }else{
                            $("#username").val(username1);
                            $(".permission_check").prop('checked',true);
                        }
                        
                    }
                    
                },
                error: function () { },
            });
        }

        function get_permissions(user_id) {
            //alert(user_id);
            $.ajax({
                url: live_URL + '/get_permissions/' + user_id,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
            }).done(function (data) {
                console.log("test", data);
                if (data.data) {
                    for (var i = 0; i < data.data.length; i++) {
                        console.log(data.data[i].permission_id);
                        $("#permissions_" + data.data[i].permission_id).prop('checked', true);
                    }
                }
            });
        }

        function add_permission(){
            if($("#username").prop('disabled')==true){
                edit_permission();
            }else{
                save_permission();
            }
        }

        function save_permission() {
            var formData = [];
            var check_vals = [];
            var username = $("#username").val();
            var contactname = $("#contactname").val();
            var email = $("#email").val();
            var language = $("#language").val();

            $('.permission_check:checked').each(function () {
                check_vals += this.value + ',';
            });
            var check_val = check_vals.replace(/(^,)|(,$)/g, "");
            var formData = {
                "username": "" + username + "",
                "contactname": "" + contactname + "",
                "email": "" + email + "",
                "language": "" + language + "",
                "check_val": "" + check_val + "",
            };
            console.log(formData);
            $.ajax({
                url: live_URL + '/add_user_new/' + clientid,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: formData,
            }).done(function (data) {
                console.log("aaa", data);
                if (data.msg == 'user has been created successfully!') {
                    window.scrollTo(0, 0);
                    $("#alertsuccess").show('medium');
                    setTimeout(function () {
                        $("#alertsuccess").hide('medium');
                    }, 1700);
                    setTimeout(function () {
                        window.location.href = "advertiser_access.php?clientid=<?php echo $_GET['clientid']; ?>";
                    }, 1700);
                }else if (data.msg == 'Username already exists') {
                    window.scrollTo(0, 0);
                    $("#alertfailed1").show('medium');
                    setTimeout(function () {
                        $("#alertfailed1").hide('medium');
                    }, 2000);
                } else {
                    window.scrollTo(0, 0);
                    $("#alertfailed").show('medium');
                    setTimeout(function () {
                        $("#alertfailed").hide('medium');
                    }, 2000);
                }
            });
        }

        function edit_permission() {
            var formData = [];
            var check_vals = [];

            $('.permission_check:checked').each(function () {
                check_vals += this.value + ',';
            });
            var check_val = check_vals.replace(/(^,)|(,$)/g, "");
            var formData = {
                "check_val": "" + check_val + "",
            };
            console.log(formData);
            $.ajax({
                url: live_URL + '/edit_permission/' + userid,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: formData,
            }).done(function (data) {
                console.log("aaa", data);
                if (data.msg == 'user permission has been updated successfully!') {
                    window.scrollTo(0, 0);
                    $("#alertsuccess").show('medium');
                    setTimeout(function () {
                        $("#alertsuccess").hide('medium');
                    }, 1700);
                    setTimeout(function () {
                        window.location.href = "advertiser_access.php?clientid=<?php echo $_GET['clientid']; ?>";
                    }, 1700);
                }
            });
        }
    </script>
</body>

</html>