<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['ordersjobs']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        /* #clientname,
        #contact,
        #email {
            width: 50%;
            display: inline;
        }

        #check {
            margin-left: 4rem;
        } */

        .alert {
            display: none;
        }
    </style>
</head>

<body onload=getadvertiser();>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top my-4 mx-3">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><span class="text-warning">
                                            <?php echo $GLOBALS['adv_properties']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="advertiser_trackers.php?clientid=<?php echo $_GET['clientid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['trackers']; ?>
                                        </span></a>
                                </li>
                                <!-- <li class="nav-item">
                                        <a class="nav-link"
                                            href="advertiser_access.php?clientid=<?php echo $_GET['clientid']; ?>"><span
                                                class="text-dark">
                                                <?php echo $GLOBALS['user_access']; ?>
                                            </span></a>
                                    </li> -->
                            </ul>
                            <div class="tab-content">
                                <div>
                                    <p class="alert bg-success alert-dismissible fade show text-white" id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['adv_update_success_msg']; ?>
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['adv_update_failed_msg']; ?>
                                    </p>
                                </div>
                                <div class="row mb-2">
                                    <h5>
                                        <?php echo $GLOBALS['strBasicInformation']; ?>
                                    </h5>
                                    <hr class="solid">
                                </div>

                                <div class="row mb-2">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <label for="inputName" class="form-label">
                                            <?php echo $GLOBALS['strName']; ?> <span class="required text-danger">*</span>
                                        </label>
                                        <input type="text" class="form-control" id="clientname" name="clientname" oninput="onchangename(this.value);" onkeyup="onchangename(this.value);" onchange="onchangename(this.value);">
                                        <p id="name_msg"></p>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <label for="inputName" class="form-label">
                                            <?php echo $GLOBALS['contact']; ?> <span class="required text-danger">*</span>
                                        </label>
                                        <input type="text" class="form-control" id="contact" name="contact" oninput="onchangecontact(this.value);" onkeyup="onchangecontact(this.value);" onchange="onchangecontact(this.value);">
                                        <p id="contact_msg"></p>
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <label for="inputName" class="form-label">
                                            <?php echo $GLOBALS['Email']; ?> <span class="required text-danger">*</span>
                                        </label>
                                        <input type="text" class="form-control" id="email" name="email" oninput="onchangeemail(this.value);" onkeyup="onchangeemail(this.value);" onchange="onchangeemail(this.value);">
                                        <p id="email_msg"></p>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <label for="inputName" class="form-label">
                                            <?php echo $GLOBALS['notification_emails']; ?>
                                        </label>
                                        <textarea type="text" class="form-control" name="notification_email" id="notification_email" placeholder="<?php echo $GLOBALS['notification_emails_msg']; ?>"></textarea>
                                    </div>
                                </div>
                                <div class="row mb-3 mt-2">
                                    <h5><?php echo $GLOBALS['orderjobreport']; ?></h5>
                                    <hr class="solid">
                                </div>

                                <div class="row mb-3">
                                    <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <input class="form-check-input" type="checkbox" id="reportdeactivate" name="reportdeactivate">
                                        <label class="form-label" for="flexSwitchCheckDefault">
                                            <?php echo $GLOBALS['campaign_activate_deactivate']; ?>
                                        </label>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <input class="form-check-input" type="checkbox" id="report" name="report">
                                        <label class="form-label" for="flexSwitchCheckDefault">
                                            <?php echo $GLOBALS['campaign_delivery_reports']; ?>
                                        </label>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <label for="inputName" class="form-label">
                                            <?php echo $GLOBALS['noofdays_delivery_reports']; ?>
                                        </label>
                                        <input type="text" min="0" value="7" class="form-control" id="reportinterval" name="reportinterval" oninput="onchangeinterval(this.value);" onkeyup="onchangeinterval(this.value);" onchange="onchangeinterval(this.value);">
                                        <div id="reportinterval_msg"></div>
                                    </div>
                                </div>


                                <!-- <h5>
                                        <?php echo $GLOBALS['Miscellaneous']; ?>
                                    </h5>
                                    <hr class="solid">
                                    <div class="form-check mt-2" id="check">
                                        <input class="form-check-input" type="checkbox" id="advertiser_limitation"
                                            name="advertiser_limitation">
                                        <label class="form-label" for="flexSwitchCheckDefault">
                                            <?php echo $GLOBALS['display_one_banner']; ?>
                                        </label>
                                    </div>
                                    <div class="mt-5 mb-4 col-2" id="check">
                                        <label for="inputName" class="form-label">
                                            <?php echo $GLOBALS['strInventory_Comments']; ?>
                                        </label> <br />
                                    </div>
                                    <div class="mt-3 mb-4 col-md-5">
                                        <textarea type="textarea" id="comments" class="form-control"
                                            rows="4"></textarea>
                                    </div> -->

                                <div class="row mb-3">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-outline-danger" style="" onclick="window.location.href='advertiser-index.php'">
                                            <?php echo $GLOBALS['strCancel']; ?>
                                        </button>&nbsp;
                                        <button type="button" id="submitbtn" class="btn btn-warning submitbtn" onclick="advertiseredit()">
                                            <?php echo $GLOBALS['strUpdate']; ?>
                                        </button>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="../js/sweetalert.min.js"></script>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';

        function getadvertiser() {
            $.ajax({
                url: live_URL + '/get_advertiser_new/' + clientid,
                type: 'GET',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: 'json',
                encode: true,
            }).done(function(data) {
                document.getElementById('clientname').value = data.data[0].clientname;
                document.getElementById('contact').value = data.data[0].contact;
                document.getElementById('email').value = data.data[0].email;
                document.getElementById('reportinterval').value = data.data[0].reportinterval;
                document.getElementById('notification_email').value = data.data[0].notification_emails;

                var x = data.data[0].clientname;
                $('#len').html(x);

                var report = data.data[0].report;
                if (report == 't') {
                    $("#report").prop('checked', true);
                } else {
                    $("#report").prop('checked', false);
                }
                var reportdeactivate = data.data[0].reportdeactivate;
                if (reportdeactivate == 't') {
                    $("#reportdeactivate").prop('checked', true);
                } else {
                    $("#reportdeactivate").prop('checked', false);
                }
                // var advertiser_limitation = data.data[0].advertiser_limitation;
                // if (advertiser_limitation == 1) {
                //     $("#advertiser_limitation").prop('checked', true);
                // } else {
                //     $("#advertiser_limitation").prop('checked', false);
                // }
            });
        }

        function onchangename(that) {
            if (that == "") {
                document.getElementById('name_msg').innerHTML = '<?php echo $GLOBALS['enter_name']; ?>';
                document.getElementById('name_msg').style.color = "red";
            } else if (that !== "") {
                document.getElementById('name_msg').innerHTML = "";
            }
        }

        function onchangecontact(that) {
            if (that == "") {
                document.getElementById('contact_msg').innerHTML = '<?php echo $GLOBALS['enter_contact']; ?>';
                document.getElementById('contact_msg').style.color = "red";
            } else if (that !== "") {
                document.getElementById('contact_msg').innerHTML = "";
            }
        }

        function onchangeemail(that) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

            if (that == '') {
                $("#email_msg").html("<?php echo $GLOBALS['enter_emailid']; ?>");
                $("#email_msg").css("color", "red").val(that);
            } else if (regex.test(that) == false) {
                $("#email_msg").html("<span style='padding-top:10px;'><?php echo $GLOBALS['enter_right_emailid']; ?></span>");
                //$("#txtContactEmail").val('');
                $("#email_msg").css("color", "red").val(that);
            } else {
                $("#email_msg").html("");
            }
        }

        function onchangeinterval(that) {
            if (that < 0) {
                document.getElementById('reportinterval_msg').innerHTML = '<?php echo $GLOBALS['enter_positive_num']; ?>';
                document.getElementById('reportinterval_msg').style.color = "red";
            } else {
                document.getElementById('reportinterval_msg').innerHTML = "";
            }
        }

        function advertiseredit() {
            var clientname = $('#clientname').val();
            var contact = $('#contact').val();
            var email = $('#email').val();
            var notification_emails = $('#notification_email').val();
            var reportinterval = $('#reportinterval').val();
            if (reportinterval == '') {
                reportinterval = 1;
            }

            var report;
            if ($('#report').prop("checked")) {
                report = "t";
            } else {
                report = "f";
            }

            var reportdeactivate;
            if ($('#reportdeactivate').prop("checked")) {
                reportdeactivate = "t";
            } else {
                reportdeactivate = "f";
            }

            // var advertiser_limitation;
            // if ($('#advertiser_limitation').prop("checked")) {
            //     advertiser_limitation = 1;
            // } else {
            //     advertiser_limitation = 0;
            // }

            var formData;
            formData = {
                "clientname": clientname,
                "contact": contact,
                "email": email,
                "notification_emails": notification_emails,
                "reportinterval": reportinterval,
                "report": report,
                "reportdeactivate": reportdeactivate,
            };

            if (clientname == "") {
                document.getElementById('name_msg').innerHTML = '<?php echo $GLOBALS['enter_name']; ?>';
                document.getElementById('name_msg').style.color = "red";
            } else {
                document.getElementById('name_msg').innerHTML = "";
            }

            if (contact == "") {
                document.getElementById('contact_msg').innerHTML = '<?php echo $GLOBALS['enter_contact']; ?>';
                document.getElementById('contact_msg').style.color = "red";
            } else {
                document.getElementById('contact_msg').innerHTML = "";
            }


            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if (email == '') {
                $("#email_msg").html("<?php echo $GLOBALS['enter_emailid']; ?>");
                $("#email_msg").css("color", "red").val(email);
            }

            if (regex.test(email) == false) {
                $("#email_msg").html("<span style='padding-top:10px;'><?php echo $GLOBALS['enter_right_emailid']; ?></span>");
                //$("#txtContactEmail").val('');
                $("#email_msg").css("color", "red").val(email);
            } else {
                $("#email_msg").html("");
            }

            if (reportinterval < 0) {
                document.getElementById('reportinterval_msg').innerHTML = '<?php echo $GLOBALS['enter_positive_num']; ?>';
                document.getElementById('reportinterval_msg').style.color = "red";
            } else {
                document.getElementById('reportinterval_msg').innerHTML = "";
            }

            if (clientname != '' && contact != '' && email != '' && reportinterval != '' && reportinterval > 0) {
                $.ajax({
                    type: "POST",
                    url: live_URL + "/advertiser_edit_new/" + clientid,
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: formData,
                    dataType: "json",
                    encode: true,
                }).done(function(data) {
                    if (data.msg == "Advertiser has been updated successfully!") {
                        window.scrollTo(0, 0);
                        $("#alertsuccess").show('medium');
                        setTimeout(function() {
                            $("#alertsuccess").hide('medium');
                        }, 2000);
                        setTimeout(function() {
                            location.reload();
                        }, 1200);
                    } else {
                        window.scrollTo(0, 0);
                        $("#alertfailed").show('medium');
                        setTimeout(function() {
                            $("#alertfailed").hide('medium');
                        }, 2000);
                    }
                })
            }
        }
    </script>


</body>

</html>