<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['strInventory_Campaign_List_Head']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

    <style>
        .tableName {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }


        .list:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .statuswidth {
            width: 13%;
        }

        .dataTables_scrollBody {
            height: auto !important;
        }

        .campaign-name {
            display: block;
            height: 20px;
            overflow-y: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text_convert {
            text-transform: capitalize;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload="get_all_advertiser();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card my-4">
                            <div class="card-body">
                                <div class="row">
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3">
                                            <?php echo $GLOBALS['campaigns']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2">
                                        <select id="advlist" name="advlist" class="form-select text-dark"
                                            onchange="campaignlist('changed')">
                                            <option selected value="0">
                                                <?php echo $GLOBALS['all_orderjob']; ?>
                                            </option>

                                        </select>
                                    </div>

                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">

                                    </div>

                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <span class="rows_selected" id="select_count"></span>
                                        <button type="button" class="btn btn-warning" id="backTo_advertiserList"
                                            onclick="window.location.href='advertiser-index.php'" style="display:none;">
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>&nbsp;
                                        <button type="button" class="btn btn-warning" id="deleteall"
                                            style="display:none;">
                                            <i class="bx bx-trash bg-label-white" aria-hidden="true" title="Delete"></i>
                                            <?php echo $GLOBALS['strInventory_DeleteCampaign']; ?>
                                        </button>&nbsp;
                                        <button type="button" class="btn btn-warning" id="addcampaignButton"
                                            onclick="campaign_add()" style="display:none;">
                                            <i class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['strInventory_AddCampaign']; ?>
                                        </button>
                                    </div>
                                </div>
                                <hr class="solid">

                                <div class="row">
                                    <div class="col-12">
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['campaign_deleted_successfully']; ?>
                                        </p>
                                        <p id="warning" class="h6 alert text-black"
                                            style="background: #ffffb3; display:none;"><strong>
                                                <?php echo $GLOBALS['warning']; ?>
                                            </strong>&nbsp;<span id="warning_msg"></span></p>
                                    </div>
                                </div>
                                <div
                                    class="row justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2 d-flex justify-content-end ">
                                        <select id="camplist" name="camplist" class="form-select text-dark "
                                            onchange="campaignlist()">
                                            <option selected value="1">
                                                <?php echo $GLOBALS['all_campaigns']; ?>
                                            </option>
                                            <option value="0">
                                                <?php echo $GLOBALS['active_campaigns']; ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="table-responsive text-nowrap">
                                        <table id="example" class="table table-striped table-responsive table-hover">
                                            <thead>
                                                <tr class="text-nowrap">
                                                    <th class="th-color text-center"><input name="select_all"
                                                            class="form-check-input" type="checkbox"></th>
                                                    <th class="th-color text-left">
                                                        <?php echo $GLOBALS['strName']; ?>
                                                    </th>
                                                    <th class="th-color">
                                                        <?php echo $GLOBALS['strInventory_Campaign_List_Type']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['strInventory_Campaign_List_Update']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['strInventory_Campaign_List_Status']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['strInventory_Campaign_List_Action']; ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var agencyid = document.getElementById('agencyid').value;
        var campaignAllStats_URL = live_URL + '/get_all_active_campaigns/';
        var deleteCampaign = live_URL + '/campaign_delete/';
        var activeDeactive = live_URL + '/campaign_status_update/';
        let userid = '<?php echo $_SESSION['user_id']; ?>';
        var permissions = [];
        var cliname = '<?php echo $_REQUEST['clientid']; ?>'

        var advValue = localStorage.getItem('advValue');
        document.getElementById('backTo_advertiserList').style.display = (cliname == "") ? "none" : "block";

        if (cliname) {
            $('#advlist').attr("disabled", true);
        }

        function get_all_advertiser() {
            // var camplist_option = $('#camplist option:selected').val();
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_advertiser/' + agencyid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                console.log("success data", data);
                var client_name = [];
                if (!data.data) {
                    $('#advlist').hide();
                    $('#camplist').hide();
                    $('#addcampaignButton').show();
                    $('#deleteall').show();
                    $('#addcampaignButton').attr("disabled", true);
                    $('#warning').show();
                    $('#warning_msg').html("There are currently no Campaigns defined,because there are no Orders/Jobs.To create a campaign,add a new Orders/Job first.");
                    campaignlist();
                } else {
                    $('#advlist').show();
                    $('#camplist').show();
                    data.data.map((data) => {
                        getclientLength = (data.clientname.length > 30) ? (data.clientname.slice(0, 30) + '...') : data.clientname;
                        client_name += `<option value=${data.clientid} title="${data.clientname}">${getclientLength}</option>`;
                        document.getElementById('advlist').innerHTML = client_name;

                    });
                    console.log(advValue);
                    if (cliname != "") {
                        document.getElementById('advlist').value = cliname;
                    } else if (advValue != '' && advValue != null && advValue != 'undefined') {
                        $('#advlist option').each(function () {
                            if (this.value == advValue) {
                                $("#advlist").val(advValue);
                            }
                        });
                        // document.getElementById('advlist').value = advValue;
                    }
                    campaignlist();
                }
            });
        }

        function activeDeactivate(campaignid) {

            console.log("campaignid", campaignid);
            swal({
                title: `<?php echo $GLOBALS['update_status']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        type: "POST",
                        url: activeDeactive + campaignid,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        console.log(data.msg);
                        console.log(campaignid);
                        if (data.msg == "Campaign Activated successfully!") {
                            location.reload();

                        } else {
                            location.reload();

                        }
                    });

                } else {
                    console.log(campaignid);
                }
            });
        }


        function Deletebtn(campaignid) {
            console.log("campaignid", campaignid)

            swal({
                title: `<?php echo $GLOBALS['want_delete_campaign']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {

                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: deleteCampaign + campaignid,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.msg = "Campaign has been deleted successfully!" && data.statuscode == 200) {
                            //swal("Zone Deleted Successfully");
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 1700);
                            setTimeout(function () {
                                location.reload();
                            }, 1700);
                        }
                    });
                    //swal(`<?php echo $GLOBALS['campaign_deleted_successfully']; ?>`);
                } else {
                    //swal("Campaign delete failed");
                }
            });

        }

        $("#deleteall").prop('disabled', true);


        // $(document).on('click', '#select-all', function () {
        //     $(".chkCountry").prop("checked", this.checked);
        //     if ($('.chkCountry:checked').length > 0) {
        //         $("#deleteall").prop('disabled', false);
        //     } else {
        //         $("#deleteall").prop('disabled', true);
        //     }
        //     // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
        // });
        $(document).on('click', '.chkCountry', function () {

            if ($('.chkCountry:checked').length > 0) {
                $("#deleteall").prop('disabled', false);
            } else {
                $("#deleteall").prop('disabled', true);
            }

            if ($('.chkCountry:checked').length == $('.chkCountry').length) {
                $('#select-all').prop('checked', true);
            } else {
                $('#select-all').prop('checked', false);
            }
            // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
        });


        document.getElementById('deleteall').onclick = function (e) {

            var campaigndeleteids = [];
            $(".chkCountry:checked").each(function () {
                campaigndeleteids.push($(this).attr('data-campaign-id'));
            });
            if (campaigndeleteids.length <= 0) {
                alert("Please select campaign.");
            }

            //console.log(campaigndeleteids);
            swal({
                title: `<?php echo $GLOBALS['want_delete_campaign']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {

                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: deleteCampaign + campaigndeleteids,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.msg = "Campaign has been deleted successfully!" && data.statuscode == 200) {
                            //swal("Zone Deleted Successfully");
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 1700);
                            setTimeout(function () {
                                location.reload();
                            }, 1700);
                        }
                    });
                    //swal(`<?php echo $GLOBALS['campaign_deleted_successfully']; ?>`);
                } else {
                    //swal("Campaign delete failed");
                }

            });
        }

        function updateDataTableSelectAllCtrl(table) {
            var $table = table.table().node();
            var $chkbox_all = $('tbody input[type="checkbox"]', $table);
            var $chkbox_checked = $('tbody input[type="checkbox"]:checked', $table);
            var chkbox_select_all = $('thead input[name="select_all"]', $table).get(0);

            // If none of the checkboxes are checked
            if ($chkbox_checked.length === 0) {
                chkbox_select_all.checked = false;
                if (chkbox_select_all) {
                    chkbox_select_all = false;
                }
                // If all of the checkboxes are checked
            } else if ($chkbox_checked.length === $chkbox_all.length) {
                chkbox_select_all.checked = true;
                if (chkbox_select_all) {
                    chkbox_select_all = false;
                }
                // If some of the checkboxes are checked
            } else {
                chkbox_select_all.checked = false;
            }
        }

        function campaignlist(changed) {

            if (cliname != "") {

                var clientid = cliname;
            } else {
                var clientid = $("#advlist option:selected").val();
            }


            var camplist_option = $('#camplist option:selected').val();
            if (clientid == '0') {
                $('#example').DataTable({
                    ordering: false,
                    destroy: true,
                    responsive: true,
                    bPaginate: false,
                    bAutoWidth: false,
                    bInfo: false,
                    data: [],
                    searching: false,
                    oLanguage: {
                        sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                    }
                });
            }
            else {
                $.ajax({
                    type: "GET",
                    url: campaignAllStats_URL + clientid + ',' + camplist_option,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    dataType: "json",
                    encode: true,
                }).done(function (data) {
                    console.log("success data", data);
                    if (data.msg == 'No Data') {
                        $('#example').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bAutoWidth: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } else if (data.msg == 'No campaigns available for this clientid!' && data.statuscode == 200) {
                        $('#example').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bAutoWidth: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } else {
                        $(document).ready(function () {
                            var rows_selected = [];
                            var table = $('#example').DataTable({
                                destroy: true,
                                targets: 0,
                                searchable: false,
                                orderable: false,
                                stateSave: true,
                                //className: 'dt-body-center',
                                responsive: false,
                                data: data.data,
                                columns: [{
                                    data: 'campaignid',
                                    className: "text-center",
                                    //    "targets": [0], "orderable": false,
                                    render: function (data, type, row, meta) {
                                        return '<input type="checkbox" name="checkrow" class="form-check-input chkCountry" id="checedkrows" value="' + row.campaignid + '" data-campaign-id="' + row.campaignid + '">';
                                    }
                                },
                                {
                                    'data': null,
                                    title: 'Name',
                                    wrap: true,
                                    className: "text-left tableName",
                                    "render": function (campaign) {
                                        if (cliname != '') {
                                            return '<a href="campaign_edit.php?clientid=' + campaign.clientid + '&' + 'campaignid=' + campaign.campaignid + '&' + 'params=1">' + campaign.campaignname + '</a>'
                                        } else {
                                            return '<a href="campaign_edit.php?client_id=' + campaign.clientid + '&' + 'campaignid=' + campaign.campaignid + '">' + campaign.campaignname + '</a>'
                                        }

                                        //    return '<a href="#">' + campaign.campaignname + '</a>'
                                    }
                                },
                                // <div class="campaign-name text-wrap text-break"></div>
                                {
                                    data: 'priority',
                                    className: "text-start text-center",
                                    render: function (data, type, row, meta) {
                                        if (row.priority == 0) {
                                            var priority = `<?php echo $GLOBALS['strRemnant']; ?>`;
                                        } else if (row.priority == -1) {
                                            var priority = `<?php echo $GLOBALS['strOverride']; ?>`;
                                        } else if (row.priority > 0 || row.priority < 10) {
                                            var priority = `<?php echo $GLOBALS['strContract']; ?>`;
                                        }
                                        return priority;
                                    }
                                },
                                {
                                    data: 'updated',
                                    className: "text-center"
                                },
                                {
                                    data: 'status',
                                    className: "statuswidth text-center",
                                    render: function (data, type, row, meta) {
                                        if (row.status == 0) {
                                            var status = '<span class="badge bg-success fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['strInventory_Campaign_List_Active']; ?> &nbsp;</span> &nbsp;';
                                            // <a href="#"> <i class="fa fa-toggle-on mt-0 " id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['deactivate']; ?> style="font-size:20px;color:red"  onclick="activeDeactivate('+row.campaignid+');"></i></a>
                                        } else if (row.status == 1) {
                                            var status = '<span class="badge bg-info fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['strInventory_Campaign_List_Paused']; ?> &nbsp;</span>  &nbsp;';
                                            // <a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a>
                                        } else if (row.status == 2) {
                                            var status = '<span class="badge bg-warning  fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['awaiting']; ?> &nbsp;</span> &nbsp;';
                                            // <a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a>
                                        } else if (row.status == 3) {
                                            var status = '<span class="badge bg-primary  fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['strInventory_Campaign_List_Completed']; ?> &nbsp;</span> &nbsp;';
                                            // <a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a>
                                        } else if (row.status == 4) {
                                            var status = '<span class="badge bg-danger  fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['strInventory_Campaign_List_Inactive']; ?>  &nbsp;</span>  &nbsp;';
                                            // <a href="#"> <i class="fa fa-toggle-on mt-0 " id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['activate']; ?> style="font-size:20px;color:green"  onclick="activeDeactivate('+row.campaignid+');"></i></a>
                                        }
                                        return status;
                                    }
                                },
                                {
                                    data: 'campaignid',
                                    //   "targets": [0], "orderable": false,
                                    className: "text-center",
                                    render: function (data, type, row, meta) {
                                        if (row.status == 4) {
                                            var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0" id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['activate']; ?> style="font-size:20px;color:green"  onclick="activeDeactivate(' + row.campaignid + ');"></i></a>';
                                        } else if (row.status == 1) {
                                            var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a>';
                                        } else if (row.status == 2) {
                                            var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a>';
                                        } else if (row.status == 3) {
                                            var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0 " disabled style="font-size:20px;color:grey"></i></a>';
                                        } else if (row.status == 0) {
                                            var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0 " id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['deactivate']; ?> style="font-size:20px;color:red"  onclick="activeDeactivate(' + row.campaignid + ');"></i></a>';
                                        }
                                        if (cliname != '') {
                                            var bannericon = '<a class="btn btn-icon btn-xs btn-warning" href="bannerlist.php?campaign_id=' + row.campaignid + '&clientid=' + row.clientid + '"><i class="bx bx-list-ul  fa-4x" style="font-size:14px" id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['campaign_wise_banner']; ?>"></i></a>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-warning" href="campaign_zones.php?campaignid=' + row.campaignid + '&clientid=' + row.clientid + '"><i class="fas fa-link"></i></a>&nbsp;';

                                            var addbanner = '<a class="btn btn-icon btn-xs btn-warning delete_permission"  href="banner_add.php?campaign_id=' + row.campaignid + '&clientid=' + row.clientid + '&params=1"><i class="bx bx-plus fa-4x" style="font-size:14px" title=<?php echo $GLOBALS['add_new_banner']; ?> style="font-size:14px;"></i></a>&nbsp;';

                                            return '<div class="row"><div>' + addbanner + ' ' + bannericon + ' </div></div>';
                                        }
                                        else {
                                            var bannericon = '<a class="btn btn-icon btn-xs btn-warning" href="bannerlist.php?campaign_id=' + row.campaignid + '&client_id=' + row.clientid + '"><i class="bx bx-list-ul  fa-4x" style="font-size:14px" id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['campaign_wise_banner']; ?>"></i></a>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-warning" href="campaign_zones.php?campaignid=' + row.campaignid + '&client_id=' + row.clientid + '"><i class="fas fa-link"></i></a>&nbsp;';

                                            var addbanner = '<a class="btn btn-icon btn-xs btn-warning delete_permission"  href="banner_add.php?campaign_id=' + row.campaignid + '&client_id=' + row.clientid + '&params=1"><i class="bx bx-plus fa-4x" style="font-size:14px" title=<?php echo $GLOBALS['add_new_banner']; ?> style="font-size:14px;"></i></a>&nbsp;';

                                            return '<div class="row"><div>' + addbanner + ' ' + bannericon + ' </div></div>';

                                        }


                                    }
                                }
                                ]
                            })

                            // Handle click on checkbox
                            $('#example tbody').on('click', 'input[type="checkbox"]', function (e) {
                                var $row = $(this).closest('tr');
                                var data = table.row($row).data();
                                var rowId = table.row(this).data[0];
                                var index = $.inArray(rowId, rows_selected);

                                if (this.checked && index === -1) {
                                    rows_selected.push(rowId);
                                } else if (!this.checked && index !== -1) {
                                    rows_selected.splice(index, 1);
                                }

                                if (this.checked) {
                                    $row.addClass('selected');
                                    document.getElementById('deleteall').disabled = $('.chkCountry:checked').length > 0 ? false : true;
                                } else {
                                    $row.removeClass('selected');
                                    document.getElementById('deleteall').disabled = $('.chkCountry:checked').length > 0 ? false : true;
                                }

                                updateDataTableSelectAllCtrl(table);
                                e.stopPropagation();
                            });
                            // Handle click on "Select all" control
                            $('thead input[name="select_all"]', table.table().container()).on('click', function (e) {
                                if (this.checked) {
                                    $('#example tbody input[type="checkbox"]:not(:checked)').trigger('click');
                                    document.getElementById('deleteall').disabled = $('.chkCountry:checked').length > 0 ? false : true;
                                } else {
                                    $('#example tbody input[type="checkbox"]:checked').trigger('click');
                                    document.getElementById('deleteall').disabled = $('.chkCountry:checked').length > 0 ? false : true;
                                }
                                e.stopPropagation();
                            });
                            // Handle table draw event
                            table.on('draw', function () {
                                updateDataTableSelectAllCtrl(table);
                            });
                        })
                    }

                    $.ajax({
                        type: "GET",
                        url: live_URL + '/get_permissions/' + userid,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        let get_data = data.data;
                        if (get_data) {
                            for (var i = 0; i < get_data.length; i++) {
                                permissions[i] = get_data[i];
                            }
                        } else {
                            permissions = '';
                        }
                        if (!permissions.includes('33')) {
                            $('#addcampaignButton').hide();
                        } else {
                            $('#addcampaignButton').show();
                        }
                        if (!permissions.includes('34') || !permissions.includes('12')) {
                            // $('input[type="checkbox"]').hide();
                            $('#example').DataTable().column(0).visible(false);
                            $('#deleteall').hide();

                        } else {
                            $('#example').DataTable().column(0).visible(true);
                            $('#deleteall').show();
                        }
                        if (!permissions.includes('35')) {

                            $('.delete_permission').hide();

                        } else {
                            $('.delete_permission').show();
                        }

                    });
                });
            }
            localStorage.setItem('advValue', $("#advlist option:selected").val());
        }


        function campaign_add() {

            let clientid = $('#advlist').val();

            // $('#add_zone_btn').attr('href', 'zone_add.php?affiliateid=' + affiliateid);
            window.location.href = cliname == '' ? 'campaign_add.php?client_id=' + clientid + '' :
                'campaign_add.php?clientid=' + cliname + '';
            // window.location.href = 'zone_add.php?affiliateid='+affiliateid+'';


        }
    </script>
</body>

</html>