<?php
include('session.php');
include('../config.php');
include('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - <?php echo $GLOBALS['website_dist']; ?></title>

    <meta name="description" content="" />
    <style>
        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 250%;
        }

        .tableName {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            /* word-break: break-all; */
        }

        /* Close Button */
        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }
    </style>
    <?php include('head.php'); ?>
</head>

<body onload="onChangeDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-4">
                            <div class="card-body">
                                <div class="row mb-2">
                                    <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3" id='reportTitle'><?php echo $GLOBALS['website_dist']; ?></p>
                                        <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
                                        <!-- <input type='hidden' id="startDate" value="<?php echo $_GET['start_date']; ?>" />
                                        <input type='hidden' id="endDate" value="<?php echo $_GET['end_date']; ?>" /> -->
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-7 col-lg-7 col-xl-7 col-xxl-7"></div>
                                    <div class="col col-12 col-sm-12 col-md-5 col-lg-5 col-xl-5 col-xxl-5 mt-2 mt-sm-2 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-warning" id="campaignList_backButton" onclick="back_btn()" style="margin-right: 3%;">
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>
                                        <select id="getwebsite" name="allfilter" class="form-select text-dark w-50" aria-label="Default select example" onchange="onChangeDetails(this.value)">
                                            <option value="Today" selected><?php echo $GLOBALS['strToday']; ?></option>
                                            <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                            <option value="Last 7 days"><?php echo $GLOBALS['strLast_7_days']; ?></option>
                                            <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                            <option value="Last Month"><?php echo $GLOBALS['strLast Month']; ?></option>
                                            <option value="This Month"><?php echo $GLOBALS['strThis Month']; ?></option>
                                            <option value='All Statistics'><?php echo $GLOBALS['strAll Statistics']; ?></option>
                                            <option value="Custom"><?php echo $GLOBALS['strCustom']; ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <input style="display: none; margin-left:3%" id="daterange" name="daterange" class="mt-2" />
                                </div>

                                <div class="table-responsive text-nowrap mt-sm-3">
                                    <table id="website_report" class="table table-striped" width='100%'>
                                        <!-- <caption style="font-size:140%;padding:5px;">Wish list status <b>Tyde</b>
                                            <input type="button" id="lockList" name="lockList" value="Lock WL" />
                                        </caption> -->
                                        <thead>
                                            <tr>
                                                <th class="text-center" rowspan="2"><?php echo $GLOBALS['website']; ?></th>
                                                <th class="text-center" colspan="4"><?php echo $GLOBALS['strImpression']; ?></th>
                                                <th class="text-center" rowspan="2"><?php echo $GLOBALS['strClicks']; ?></th>
                                                <th class="text-center" rowspan="2"><?php echo $GLOBALS['strCTR']; ?></th>
                                                <th class="text-center" rowspan="2"><?php echo $GLOBALS['per_to_delivery']; ?></th>
                                                <th class="text-center" rowspan="2"><?php echo $GLOBALS['deadline']; ?></th>
                                                <th class="text-center" rowspan="2"><?php echo $GLOBALS['action']; ?></th>
                                                <!-- <th class="text-center" style="padding-right: 30px;"><button type="button" class="btn btn-warning btn-sm" style="background-color: transparent;border-color:#000000; width:100%;" id="campaign_email_report" onclick="campaign_email_report()"><i class="bx bx-export label-primary" style="font-size:14px"></i>&nbsp;<?php echo $GLOBALS['campaign_email_report']; ?></button></th> -->

                                            </tr>
                                            <tr>
                                                <th class="text-center"><?php echo $GLOBALS['viewable']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['booked']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['delivered']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['remaining']; ?></th>
                                                <!-- <th class="text-center" style="padding-right: 30px;"><button type="button" class="btn btn-warning btn-sm" style="background-color: transparent;border-color:#000000; width:100%;" id="campaign_report" onclick="campaign_report()"><i class="bx bx-export label-primary" style="font-size:14px"></i>&nbsp;<?php echo $GLOBALS['Campaign_Report']; ?></button></th> -->
                                            </tr>
                                        </thead>
                                        <tbody id="table_data"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <script>
                        const token = 'Bearer ' + document.getElementById('token').value;
                        const live_URL = '<?php echo $apistatpath; ?>';
                        const live_URL1 = '<?php echo $apiinvenpath; ?>';
                        let campaign_id = document.getElementById('campaignid').value;
                        let userid = '<?php echo $_SESSION['user_id']; ?>';
                        let clientid = '<?php echo $_GET['clientid']; ?>';
                        let getparams = '<?php echo $_GET['params']; ?>';
                        let getTodayDate;
                        var report_data;
                        document.getElementById('campaignList_backButton').style.display = "none";
                        var permissions = [];

                        // API's
                        let website_distribution = live_URL + '/get_website_distribution/';

                        function onChangeDetails() {
                            $(".loader").show();
                            const date = new Date();
                            let getSelectedDay = document.getElementById('getwebsite').value;

                            document.getElementById('daterange').style.display = getSelectedDay == 'Custom' ? "block" : "none";

                            if (getSelectedDay == 'Today') {
                                let v3 = JSON.stringify(date).slice(1, 11);
                                getTodayDate = v3;
                                getwebsite(v3, v3);
                            } else if (getSelectedDay == 'Yesterday') {
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                                getwebsite(yesterday_date, yesterday_date);
                            } else if (getSelectedDay == 'Last 7 days') {
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date).slice(1, 11);

                                let date1 = new Date();
                                let current_date = date1.setDate(date1.getDate() - 1);
                                const get_7Days = new Date(date1);
                                let date_end = JSON.stringify(get_7Days).slice(1, 11);
                                getwebsite(first_day, date_end);
                            } else if (getSelectedDay == 'Last 30 days') {
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date).slice(1, 11);

                                let date1 = new Date();
                                let current_date = date1.setDate(date1.getDate() - 1);
                                const get_30Days = new Date(date1);
                                let date_end = JSON.stringify(get_30Days).slice(1, 11);
                                getwebsite(first_day, date_end);
                            } else if (getSelectedDay == 'This Month') {
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cDate = firstDay.getDate(),
                                    cMonth = firstDay.getMonth() + 1,
                                    cYear = firstDay.getFullYear();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getwebsite(first_day, date_end);
                            } else if (getSelectedDay == 'Last Month') {
                                let prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                let prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                let formatDateComponent = function(dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                let formatDate = function(date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                getwebsite(formatDate(prevMonthFirstDate), formatDate(prevMonthLastDate));
                            } else if (getSelectedDay == 'All Statistics') {
                                getwebsite(start_date = 0, end_date = 0);
                            } else if (getSelectedDay == 'Custom') {
                                $(".loader").hide();
                                getwebsite(getTodayDate, getTodayDate);
                                $(function() {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MM/YYYY'
                                        },
                                    }, function(start, end, label) {
                                        getwebsite(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                    });
                                })
                            }
                        };

                        function getwebsite(startDate, endDate) {
                            report_data = '';
                            let payload;
                            var delivery_sum = 0;
                            document.getElementById('campaignList_backButton').style.display = "block";
                            payload = (startDate == 0 && endDate == 0) ? {
                                "action": 'all'
                            } : {
                                "action": '',
                                "start_date": startDate + ' 00:00:00,',
                                "end_date": endDate + ' 23:59:59,'
                            }
                            $.ajax({
                                url: website_distribution + campaign_id,
                                type: 'POST',
                                beforeSend: function(xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: payload,
                                success: function(data) {
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        //$('#campaign_report').attr("disabled", true);
                                        //$('#campaign_email_report').attr("disabled", true);
                                        $('#website_report').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: false,
                                            bPaginate: false,
                                            bInfo: false,
                                            data: [],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                            }
                                        });
                                    } else {
                                        report_data = data.data;
                                        var del_data = data.data;
                                        for (var i = 0; i < del_data.length; i++) {
                                            delivery_sum += parseInt(del_data[i].impressions);
                                        }
                                        //$('#campaign_report').attr("disabled", false);
                                        //$('#campaign_email_report').attr("disabled", false);
                                        $('#website_report').DataTable({
                                            ordering: true,
                                            destroy: true,
                                            data: data.data,
                                            columns: [{
                                                    data: 'website',
                                                    className: 'text-start',
                                                    render: function(data, type, row, meta) {
                                                        return row.website;
                                                    }
                                                },
                                                {
                                                    data: 'views',
                                                    className: 'text-center',
                                                    render: function(data, type, row, meta) {
                                                        return row.views;
                                                    }
                                                },
                                                {
                                                    data: 'booked_impression',
                                                    className: 'text-center',
                                                    render: function(data, type, row, meta) {
                                                        return row.booked_impression;
                                                    }
                                                },
                                                {
                                                    data: 'impressions',
                                                    className: 'text-center',
                                                    render: function(data, type, row, meta) {
                                                        return row.impressions;
                                                    }
                                                },
                                                {
                                                    data: '',
                                                    className: "text-center",
                                                    render: function(data, type, row, meta) {
                                                        return row.booked_impression - delivery_sum;
                                                    }
                                                },
                                                {
                                                    data: 'clicks',
                                                    className: 'text-center',
                                                    render: function(data, type, row, meta) {
                                                        return row.clicks;
                                                    }
                                                },
                                                {
                                                    data: 'ctr',
                                                    className: 'text-center',
                                                    render: function(data, type, row, meta) {
                                                        return row.ctr;
                                                    }
                                                },
                                                {
                                                    data: '',
                                                    className: "text-center",
                                                    render: function(data, type, row, meta) {
                                                        var remaining = row.booked_impression - delivery_sum;
                                                        return (row.booked_impression > 0) ? parseFloat((remaining * 100) / row.booked_impression).toFixed(2) + '%' : '-'
                                                    }
                                                },

                                                {
                                                    data: 'expire_time',
                                                    className: "text-center",
                                                    render: function(data, type, row, meta) {
                                                        return (row.expire_time == null) ? '-' : row.expire_time;
                                                    }
                                                },
                                                {
                                                    data: 'website_id',
                                                    className: "text-center",
                                                    orderable: false,
                                                    render: function(data, type, row, meta) {
                                                        return '<button type="button" class="btn btn-warning btn-sm" id="website_report" onclick="website_report(' + row.website_id + ')"><i class="bx bx-export label-primary" style="font-size:14px"></i>&nbsp;<?php echo $GLOBALS['website_report']; ?></button>';
                                                    }
                                                },
                                            ],
                                            // "footerCallback": function(row, data, start, end, display) {
                                            //     var api = this.api(),
                                            //         data;
                                            // },
                                        });
                                    }
                                },
                                error: function() {},
                            });
                            $.ajax({
                                type: "GET",
                                url: live_URL1 + '/get_permissions/' + userid,
                                beforeSend: function(xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                dataType: "json",
                                encode: true,
                            }).done(function(data) {
                                let get_data = data.data;
                                if (get_data) {
                                    for (var i = 0; i < get_data.length; i++) {
                                        permissions[i] = get_data[i];
                                    }
                                } else {
                                    permissions = '';
                                }
                                if (!permissions.includes('44')) {
                                    $('#website_report').DataTable().column(9).visible(false);
                                } else {
                                    $('#website_report').DataTable().column(9).visible(true);
                                }
                                // if (!permissions.includes('45')) {
                                //     $('#campaign_email_report').hide();
                                // } else {
                                //     $('#campaign_email_report').show();
                                // }
                            });
                        }

                        // function campaign_report() {
                        //     var dist = [];
                        //     var distribution_url = "http://mkt-reports.ced.cy:6001/api/reports/distribution";
                        //     var delivered_sum = 0;

                        //     if (report_data) {
                        //         var agency_head = {
                        //             "agency": report_data[0].agency_name,
                        //             "name": report_data[0].client_name,
                        //         };

                        //         if (report_data.length > 0) {
                        //             for (var i = 0; i < report_data.length; i++) {
                        //                 delivered_sum += parseInt(report_data[i].impressions);
                        //             }
                        //             for (var i = 0; i < report_data.length; i++) {
                        //                 let remaining = report_data[i].booked_impression - delivered_sum;
                        //                 let delivery_per = (report_data[i].booked_impression > 0) ? parseFloat((remaining * 100) / report_data[i].booked_impression).toFixed(2) : 0;
                        // 				//console.log(delivery_per);
                        //                 dist[i] = {
                        //                     "order": report_data[i].client_name,
                        //                     "publisher": report_data[i].publisher_name,
                        //                     "ctr": parseFloat(report_data[i].ctr),
                        //                     "delivery": parseFloat(delivery_per),
                        //                     "website": report_data[i].website,
                        //                     "booked_impressions": parseInt(report_data[i].booked_impression),
                        //                     "viewable_impressions": parseInt(report_data[i].views),
                        //                     "impressions": parseInt(report_data[i].impressions),
                        //                     "remaining_impressions": remaining,
                        //                     "clicks": parseInt(report_data[i].clicks),
                        //                     "deadline": report_data[i].expire_time
                        //                 }
                        //             }
                        //         }
                        //         let formData = {
                        //             "advertiser": agency_head,
                        //             "distribution": dist
                        //         }
                        // 		//console.log(JSON.stringify(formData));
                        //         window.location.href = "distribution.php?data=" + JSON.stringify(formData);
                        //     }
                        // }
                        // function campaign_email_report() {
                        //     var dist = [];
                        //     var distribution_url = "http://mkt-reports.ced.cy:6001/api/reports/distribution";
                        //     var delivered_sum = 0;
                        //     if (report_data) {
                        //         var agency_head = {
                        //             "notification_emails" : report_data[0].notification_emails,
                        //             "agency": report_data[0].agency_name,
                        //             "name": report_data[0].client_name,
                        //         };

                        //         if (report_data.length > 0) {
                        //             for (var i = 0; i < report_data.length; i++) {
                        //                 delivered_sum += parseInt(report_data[i].impressions);
                        //             }
                        //             for (var i = 0; i < report_data.length; i++) {
                        //                 let remaining = report_data[i].booked_impression - delivered_sum;
                        //                 let delivery_per = (report_data[i].booked_impression > 0) ? parseFloat((remaining * 100) / report_data[i].booked_impression).toFixed(2) : 0;
                        //                 dist[i] = {
                        // 				    "order": report_data[i].client_name,
                        //                     "publisher": report_data[i].publisher_name,
                        //                     "ctr": parseFloat(report_data[i].ctr),
                        //                     "delivery": parseFloat(delivery_per),
                        //                     "website": report_data[i].website,
                        //                     "booked_impressions": parseInt(report_data[i].booked_impression),
                        //                     "viewable_impressions": parseInt(report_data[i].views),
                        //                     "impressions": parseInt(report_data[i].impressions),
                        //                     "remaining_impressions": remaining,
                        //                     "clicks": parseInt(report_data[i].clicks),
                        //                     "deadline": report_data[i].expire_time,
                        //                     "email": report_data[i].publisher_email
                        //                 }
                        //             }
                        //         }
                        //         let formData = {
                        //             "advertiser": agency_head,
                        //             "distribution": dist
                        //         }
                        //         console.log("formData", JSON.stringify(formData));
                        //         window.location.href = "distribution.php?data=" + JSON.stringify(formData);
                        //     }
                        // }

                        function website_report(id) {
                            var wibsite_url = "http://mkt-reports.ced.cy:6001/api/reports/agency";
                            var delivered_sum = 0;
                            if (report_data.length > 0) {
                                for (var i = 0; i < report_data.length; i++) {
                                    delivered_sum += parseInt(report_data[i].impressions);
                                }
                                for (var i = 0; i < report_data.length; i++) {
                                    var web = report_data[i].website_id;
                                    let remaining = report_data[i].booked_impression - delivered_sum;
                                    let delivery_per = (report_data[i].booked_impression > 0) ? parseFloat((remaining * 100) / report_data[i].booked_impression).toFixed(2) : 0;
                                    if (id == web) {
                                        let formData = {
                                            "advertiser": report_data[i].agency_name,
                                            "order": report_data[i].client_name,
                                            "publisher": report_data[i].publisher_name,
                                            "ctr": parseFloat(report_data[i].ctr),
                                            "delivery": delivery_per,
                                            "website": report_data[i].website,
                                            "booked_impressions": parseInt(report_data[i].booked_impression),
                                            "impressions": parseInt(report_data[i].impressions),
                                            "remaining_impressions": remaining,
                                            "clicks": parseInt(report_data[i].clicks),
                                            "deadline": report_data[i].expire_time
                                        }
                                        window.location.href = "distribution_website.php?data=" + JSON.stringify(formData);
                                    }
                                }
                            }

                        }

                        function back_btn() {
                            window.location.href = (getparams == '') ? 'campaignreport.php?clientid=' + clientid : 'campaignreport.php';
                        }
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>