<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <title><?php echo $projecttitle; ?> - <?php echo $GLOBALS['video_report']; ?></title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 200%;
        }

        /* Close Button */
        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }
    </style>
</head>

<body onload="onChangeDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-5">
                            <div class="card-body">
                                <!-- <div> -->
                                <div class="row mb-4 mt-2">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class='h4'><?php echo $GLOBALS['video_report']; ?></p>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="getCampaign" class="form-select text-dark" aria-label="Default select example" 
                                        onchange="onChangeDetails()" style="width: 41%;">
                                            <option selected value="Today"><?php echo $GLOBALS['strToday']; ?></option>
                                            <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                            <option value="Last 7 days"><?php echo $GLOBALS['strLast 7 days']; ?></option>
                                            <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                            <option value="Last Month"><?php echo $GLOBALS['strLast Month']; ?></option>
                                            <option value="This Month"><?php echo $GLOBALS['strThis Month']; ?></option>
                                            <option value='all statistics'><?php echo $GLOBALS['strAll Statistics']; ?></option>
                                            <option value="custom"><?php echo $GLOBALS['strCustom']; ?></option>
                                        </select>
                                    </div>
                                    <div class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <input style="display: none; margin-left:3%" id="daterange" name="daterange" class='mt-2' />
                                    </div>
                                </div>
                                <div class="table-responsive text-nowrap">
                                    <!-- id="example2" -->
                                    <table id="camapaignrep" class="table table-striped">
                                        <thead>
                                            <tr class="text-dark">
                                                <!-- <th class="text-dark text-center" style="text-align: center; width: 20%">Date</th> -->
                                                <th class="text-dark"><?php echo $GLOBALS['banner']; ?></th>
                                                <th class="text-dark text-center"><?php echo $GLOBALS['campaign']; ?></th>
                                                <th class="text-dark text-center"><?php echo $GLOBALS['started']; ?></th>
                                                <th class="text-dark text-center" style="text-align: center;"><?php echo $GLOBALS['midpoint']; ?></th>
                                                <th class="text-dark text-center" style="text-align: center;"><?php echo $GLOBALS['first_quartile']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['third_quartile']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['complete']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['mute']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['replay']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['full_screen']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['stop']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['strInventory_Campaign_List_Paused']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['resume']; ?></th>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['unmute']; ?></th>

                                                <!--<th class="text-dark text-start"><?php echo $GLOBALS['bannerid']; ?></th>-->
                                            </tr>
                                        </thead>
                                        <tbody id="camp_table"></tbody>
                                    </table>
                                </div>
                                <!-- </div> -->
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <script>
                        var live_URL = '<?php echo $apistatpath; ?>';
                        var domain_url = live_URL + '/get_agency_video_statistics/';
                        var token = 'Bearer ' + document.getElementById('token').value;
                        var agency_id = document.getElementById('agencyid').value;
                        var getCampData = "";

                        function onChangeDetails() {
                            $(".loader").show();
                            const date = new Date();
                            var getSelectedDay = document.getElementById('getCampaign').value;
                            var getCampData = "";

                            if (getSelectedDay == 'Today') {
                                $("#daterange").css("display", "none");
                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3,
                                    end_date = v3;
                                getCampaignDate(start_date, end_date);
                            } else if (getSelectedDay == 'Yesterday') {
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                var start_date = yesterday_date,
                                    end_date = yesterday_date;
                                getCampaignDate(start_date, end_date);
                            } else if (getSelectedDay == 'Last 7 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let todayDate = new Date();
                                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                                const last_7Days = new Date(todayDate);
                                let date_end = JSON.stringify(last_7Days);
                                date_end = date_end.slice(1, 11);
                                getCampaignDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last 30 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let todayDate = new Date();
                                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                                const last_30Days = new Date(todayDate);
                                let date_end = JSON.stringify(last_30Days);
                                date_end = date_end.slice(1, 11);
                                getCampaignDate(first_day, date_end);
                            } else if (getSelectedDay == 'This Month') {
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cYear = firstDay.getFullYear(),
                                    cMonth = firstDay.getMonth() + 1,
                                    cDate = firstDay.getDate();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                let year = lastDay.getFullYear(),
                                    month = lastDay.getMonth() + 1,
                                    day = lastDay.getDate();
                                let date_end = year + "-" + month + "-" + day;
                                getCampaignDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last Month') {
                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function(dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function(date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate),
                                    end_date = formatDate(prevMonthLastDate);
                                getCampaignDate(start_date, end_date);
                            } else if (getSelectedDay == 'all statistics') {
                                $("#daterange").css("display", "none");
                                let payload = (start_date == 0 && end_date == 0) ? {
                                    "action": 'all'
                                } : {
                                    "action": 'all'
                                };
                                $.ajax({
                                    url: domain_url + agency_id,
                                    type: 'POST',
                                    beforeSend: function(xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: payload,
                                    success: function(data) {
                                        console.log("cm data", data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            $('#camapaignrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                                }
                                            });
                                        } else {
                                            $('#camapaignrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [{
                                                        data: 'description',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'campaignname',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'start',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'midpoint',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'firstquartile',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'thirdquartile',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'complete',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'mute',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'replay',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'fullscreen',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'stop',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'unmute',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'resume',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'paused',
                                                        className: "text-start"
                                                    },
                                                ],
                                            });
                                        }
                                    },
                                    error: function() {},
                                });
                            } else if (getSelectedDay == 'custom') {
                                $("#daterange").css("display", "block");
                                $(".loader").hide();
                                $(document).on('change', '#daterange', function() {
                                    var dates = $('#daterange').val();
                                    const daterange = dates.split("-");
                                });
                                $(function() {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MMM/YYYY'
                                        },
                                    }, function(start, end, label) {
                                        var start_date = start.format('YYYY-MM-DD'),
                                            end_date = end.format('YYYY-MM-DD');
                                        getCampaignDate(start_date, end_date);
                                    })
                                })
                            }
                        };

                        function getCampaignDate(start_date, end_date) {
                            let payload = (start_date == 0 && end_date == 0) ? {
                                "action": 'all'
                            } : {
                                "action": '',
                                "start_date": start_date + ' 00:00:00,',
                                "end_date": end_date + ' 23:59:59,'
                            };
                            $.ajax({
                                url: domain_url + agency_id,
                                type: 'POST',
                                beforeSend: function(xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: payload,
                                success: function(data) {
                                    // console.log("data", data);
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data: [],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                            }
                                        });
                                    } else {
                                        $('#camapaignrep').DataTable({
                                            ordering: true,
                                            destroy: true,
                                            // responsive: true,
                                            data: data,
                                            columns: [{
                                                    data: 'description',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'campaignname',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'start',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'midpoint',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'firstquartile',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'thirdquartile',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'complete',
                                                    className: "text-start"
                                                },
                                                {
                                                    data: 'mute',
                                                    className: "text-start"
                                                },
                                                {
                                                    data: 'replay',
                                                    className: "text-start"
                                                },
                                                {
                                                    data: 'fullscreen',
                                                    className: "text-start"
                                                },
                                                {
                                                    data: 'stop',
                                                    className: "text-start"
                                                },
                                                {
                                                    data: 'unmute',
                                                    className: "text-start"
                                                },
                                                {
                                                    data: 'resume',
                                                    className: "text-start"
                                                },
                                                {
                                                    data: 'paused',
                                                    className: "text-start"
                                                }
                                            ],
                                        });
                                    }
                                },
                                error: function() {},
                            });
                        };
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>