<?php
include('session.php');
include('../config.php');
include('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
  data-template="vertical-menu-template-free">

<head>
  <meta charset="utf-8" />
  <meta name="viewport"
    content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <title>
    <?php echo $projecttitle; ?> -
    <?php echo $GLOBALS['change_lang']; ?>
  </title>

  <meta name="description" content="" />

  <?php include('head.php'); ?>

</head>

<body onload="getLanguage()">
  <!-- Layout wrapper -->
  <div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
      <!-- Menu -->

      <?php include('sidebar.php'); ?>

      <!-- / Menu -->

      <!-- Layout container -->
      <div class="layout-page">
        <!-- Navbar -->
        <?php include('navbar.php'); ?>
        <!-- / Navbar -->

        <!-- Content wrapper -->
        <div class="content-wrapper">
          <!-- Content -->

          <div class="container">
            <div class="card mt-5 mb-5">
              <div class="card-header">
                <p class="h3">
                  <?php echo $GLOBALS['name_language']; ?>
                </p>
              </div>
              <div class="card-body">
                <p class="alert bg-success alert-dismissible fade show text-white" id="alertsuccess" style="display:none;"><i
                    class="fa fa-check-circle"></i>
                  <?php echo $GLOBALS['name_language_success']; ?>
                </p>
                <form>
                  <div class="row mb-3">
                    <div class="col-6">
                      <label class="form-label mb-2 " style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['strUsername']; ?>
                      </label>
                      <input type="text" class="form-control" id="userName" readonly />
                    </div>
                    <div class="col-6">
                      <label class="form-label mb-2 " style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['email_address']; ?>
                      </label>
                      <input type="text" class="form-control" id="email_id" readonly />
                    </div>
                  </div>
                  <div class="row mb-3 mt-3">
                    <div class="col-6">
                      <label class="form-label mb-2" style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['full_name']; ?>
                      </label>
                      <input type="text" class="form-control" id="fullName" onchange="fullnamechange()"
                        onkeyup="fullnamechange()" />
                      <span id="fullname_msg" style='color:red;'></span>
                    </div>
                    <div class="col-6">
                      <label class="form-label mb-2 " style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['language']; ?>
                      </label>
                      <select id="language" name="language" class="form-control text-dark"></select>
                    </div>
                  </div>
                  <div class="row justify-content-end mt-2 mb-4">
                    <div class='col'>
                      <a href="../agency/dashboard.php" style="position:relative;left:73%;">
                        <button type="button" class="btn btn-outline-danger">
                          <?php echo $GLOBALS['strCancel']; ?>
                        </button>
                      </a>
                      <button class="btn btn-warning" style="position:relative;left:74%;" onclick="submitLanguage()">
                        <?php echo $GLOBALS['strSubmit']; ?>
                      </button>
                    </div>
                  </div>
                </form>

              </div>
            </div>
            <!-- / Content -->
</div>
            <!-- Footer -->
            <?php include('footer.php'); ?>
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    
    <!-- / Layout wrapper -->

    <!-- build:js assets/vendor/js/core.js -->
    <script src="../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../assets/vendor/libs/popper/popper.js"></script>
    <script src="../assets/vendor/js/bootstrap.js"></script>
    <script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="../assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="../assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="../assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="../assets/js/dashboards-analytics.js"></script>
    <script>
      var live_URL = '<?php echo $apiinvenpath; ?>';
      var token = 'Bearer ' + document.getElementById('token').value;
      let user_id = <?php echo $_SESSION['user_id']; ?>;

      let language_value = [
        //{ id: 1, value: "", key: "Select Language" },
        { id: 1, value: "en", key: "English" },
        { id: 2, value: "de", key: "Deutsch" }
      ];

      let lang = language_value.map((data, index) => {
        return `<option value=${data.value} key=${index}>${data.key}</option>`;
      });
      document.getElementById('language').innerHTML = lang;
      // $(function() {
      //     $('#language').select2();
      // });
      let validName;

      getLanguage = () => {
        $.ajax({
          url: live_URL + '/get_user_language/' + user_id,
          type: "GET",
          beforeSend: function (xhr) {
            xhr.setRequestHeader('Authorization', token);
          },
          data: {},
          dataType: "json",
          encode: true,
        }).done(function (data) {
          document.getElementById('userName').value = data.data.username;
          document.getElementById('email_id').value = data.data.email_address;
          document.getElementById('fullName').value = data.data.contact_name;
          if (data.data.language == 0) {
            language = 'en';
          } else {
            language = data.data.language;
          }
          document.getElementById('language').value = language;
        });
      };

      // let getLanguage = `<?php echo $_SESSION['language']; ?>`;
      // document.getElementById('language').value = getLanguage;
      // console.log("get Language:",getLanguage);
      fullnamechange = (data) => {
        let fullname = document.getElementById("fullName").value;
        document.getElementById('fullname_msg').innerHTML = fullname == "" ? (validName = true, `<?php echo $GLOBALS['enter_fullname']; ?>`) :
          (validName = false, "");
      };

      submitLanguage = () => {
        let lang = document.getElementById('language').value;
        let full_name = document.getElementById('fullName').value;

        let formData = {
          "language": lang,
          "contact_name": full_name,
          "mode": "edit"
        };
        fullnamechange();
        if (full_name != '') {
          $.ajax({
            url: live_URL + '/edit_user_language/' + user_id,
            type: "POST",
            beforeSend: function (xhr) {
              xhr.setRequestHeader('Authorization', token);
            },
            data: formData,
            dataType: "json",
            encode: true,
          }).done(function (data) {
            console.log("data", data.data);
            if (data.data.msg == "language updated successfully!" && data.data.statuscode == 200) {
              $("#alertsuccess").show('medium');
              setTimeout(function () {
                $("#alertsuccess").hide('medium');
              }, 1700);
              setTimeout(function () {
                location.reload();
              }, 1700);
            }
            else {
              console.log("language is not update");
            }
          });
        }
        event.preventDefault();
      }
    </script>
</body>

</html>