<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['publishers']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        .cancel-style {
            color: red !important
        }

        input[type="button"]:hover {
            color: #fff !important;

        }

        .cancel-style:hover {
            color: #fff !important
        }

        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .alert {
            display: none;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }
    </style>
</head>

<body onload="getpublisherDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->
                <!-- Content wrapper <i class="menu-icon tf-icons bx bx-plus"></i> -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="card my-4">
                            <div class="card-body">
                                <div class="row">
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3">
                                            <?php echo $GLOBALS['publishers']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div
                                        class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-warning" id="delete_publisher"
                                            onclick="delete_publishers();" style="display:none;"><i class="bx bx-trash"
                                                aria-hidden="true" title="Delete"></i>
                                            <?php echo $GLOBALS['delete']; ?>
                                        </button>&nbsp;
                                        <button class="btn btn-warning" type="button" id="publisher_add"
                                            onclick="window.location.href='publisher_add.php'" style="display:none;"><i
                                                class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['add_publisher']; ?>
                                        </button>
										&nbsp;
                                        <button class="btn btn-warning" type="button" id="publisher_add"
                                            onclick="window.location.href='publisher_import.php'"><i
                                                class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['import_publishers']; ?>
                                        </button>
                                    </div>
                                </div>
                                <hr />
                                <div class="row mt-1">
                                    <div class="col-12">
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['publisher_delete']; ?>
                                        </p>
                                        <p class="alert bg-danger alert-dismissible fade show text-white"
                                            id="alertfailed">
                                            <i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['publisher_delete_fail']; ?>
                                        </p>
                                        <p id="warning" class="h6 alert text-black"
                                            style="background: #ffffb3; display:none;"><strong>
                                                <?php echo $GLOBALS['warning']; ?>
                                            </strong>&nbsp;<span id="warning_msg"></span></p>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="table-responsive text-nowrap">
                                        <table id="publisher_table" class="table table-striped table-hover">
                                            <thead>
                                                <tr class="text-nowrap">
                                                    <th class="th-color text-center">
                                                        <input type="checkbox" class="form-check-input check-rule"
                                                            id="select_all" name="select_all">
                                                    </th>
                                                    <th class="th-color text-start">
                                                        <?php echo $GLOBALS['strName']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['updated']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['add_websites']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['websites']; ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script>
        const live_URL = '<?php echo $apiinvenpath; ?>';
        const token = 'Bearer ' + document.getElementById('token').value;
        var agencyid = document.getElementById('agencyid').value;;
        var permissions = [];
        //API's
        let getpublisher_url = live_URL + '/get_all_publisher/' + agencyid;
        let delete_url = live_URL + '/delete_publisher_new/';
        let userid = '<?php echo $_SESSION['user_id']; ?>';

        $(document).ready(function () {
            $('#delete_publisher').prop('disabled', true);
        });

        getpublisherDetails = () => {
            //$(".loader").show();
            $.ajax({
                url: getpublisher_url,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                success: function (data) {
                    $(".loader").hide();
                    if (data.msg == 'No Data' || data.msg == 'Enter valid agency Id!') {
                        $('#warning').show();
                        $('#warning_msg').html("<?php echo $GLOBALS['pub_warning']; ?>");
                        $('#publisher_table').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } else {
                        var rows_selected = [];
                        websiteTable = $('#publisher_table').DataTable({
                            destroy: true,
                            targets: 0,
                            searchable: false,
                            orderable: false,
                            stateSave: true,
                            //className: 'dt-body-center',
                            responsive: false,
                            data: data.data,
                            columns: [{
                                data: 'agency_id',
                                className: "text-center",
                                orderable: false,
                                render: function (data, type, row, meta) {
                                    return '<input type="checkbox" class="data-checked form-check-input select-checkbox" value="' + row.id + '" data-pubid="' + row.id + '" name="checkrow" id="checkrow" >';
                                }
                            },
                            {
                                'data': null,
                                title: 'Name',
                                className: "text-start",
                                wrap: true,
                                "render": function (pub) {
                                    return '<a href="publisher_edit.php?pub_id=' + pub.id + '">' + pub.name + '</a>'
                                }
                            },
                            {
                                data: 'updated',
                                className: "text-center",
                                render: function (data, type, row, meta) {
                                    return row.updated;
                                }
                            },
                            {
                                data: null,
                                className: "text-center",
                                render: function (data, type, row, meta) {
                                    return '<a class="" href="websites_add.php?pub_id=' + row.id + '&params=1"> <i class="fa fa-folder-plus" title="<?php echo $GLOBALS['add_new_websites']; ?>"></i>&nbsp;&nbsp;<?php echo $GLOBALS['add_new_websites']; ?></a>';
                                }
                            },
                            {
                                data: 'contact',
                                className: "text-center",
                                render: function (data, type, row, meta) {
                                    return '<a class="" href="websites_list.php?pub_id=' + row.id + '"> <i class="menu-icon tf-icons bx bx-globe" title="<?php echo $GLOBALS['websites_list']; ?>"></i><?php echo $GLOBALS['websites']; ?></a>';
                                }
                            },
                            ]
                        });

                        // Handle click on checkbox
                        $('#publisher_table tbody').on('click', 'input[type="checkbox"]', function (e) {
                            var $row = $(this).closest('tr');
                            var data = websiteTable.row($row).data();
                            var rowId = websiteTable.row(this).data[0];
                            var index = $.inArray(rowId, rows_selected);

                            if (this.checked && index === -1) {
                                rows_selected.push(rowId);
                            } else if (!this.checked && index !== -1) {
                                rows_selected.splice(index, 1);
                            }

                            if (this.checked) {
                                $row.addClass('selected');
                                document.getElementById('delete_publisher').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            } else {
                                $row.removeClass('selected');
                                document.getElementById('delete_publisher').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            }

                            updateDataTableSelectAllCtrl(websiteTable);
                            e.stopPropagation();
                        });
                        // Handle click on "Select all" control
                        $('thead input[name="select_all"]', websiteTable.table().container()).on('click', function (e) {
                            if (this.checked) {
                                $('#publisher_table tbody input[type="checkbox"]:not(:checked)').trigger('click');
                                document.getElementById('delete_publisher').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            } else {
                                $('#publisher_table tbody input[type="checkbox"]:checked').trigger('click');
                                document.getElementById('delete_publisher').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            }
                            e.stopPropagation();
                        });
                        // Handle table draw event
                        websiteTable.on('draw', function () {
                            updateDataTableSelectAllCtrl(websiteTable);
                        });
                    }
                }

            });
            $.ajax({
                type: "GET",
                url: live_URL + '/get_permissions/' + userid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: "json",
                encode: true,
            }).done(function (data) {
                let get_data = data.data;
                if (get_data) {
                    for (var i = 0; i < get_data.length; i++) {
                        permissions[i] = get_data[i];
                    }
                } else {
                    permissions = '';
                }
                if (!permissions.includes('38')) {
                    $('#publisher_add').hide();
                } else {
                    $('#publisher_add').show();
                }
                if (!permissions.includes('39')) {
                    // $('input[type="checkbox"]').hide();
                    $('#publisher_table').DataTable().column(0).visible(false);
                    $('#delete_publisher').hide();

                } else {
                    $('#publisher_table').DataTable().column(0).visible(true);
                    $('#delete_publisher').show();
                }
                if (!permissions.includes('40')) {

                    $('.delete_permission').hide();

                } else {
                    $('.delete_permission').show();
                }

            });

        };

        document.getElementById('select_all').onclick = function () {
            var checkboxes = document.querySelectorAll('input[type="checkbox"]');
            for (var checkbox of checkboxes) {
                checkbox.checked = this.checked;
            }
            document.getElementById('delete_publisher').disabled = $('.data-checked:checked').length > 0 ? false : true;
        }

        $(document).on('click', '.data-checked', function () {
            document.getElementById('delete_publisher').disabled = $('.data-checked:checked').length > 0 ? false : true;
            document.getElementById('select-all').checked = ($('.data-checked:checked').length == $('.data-checked').length) ? true : false;
        });

        function updateDataTableSelectAllCtrl(websiteTable) {
            var $table = websiteTable.table().node();
            var $chkbox_all = $('tbody input[type="checkbox"]', $table);
            var $chkbox_checked = $('tbody input[type="checkbox"]:checked', $table);
            var chkbox_select_all = $('thead input[name="select_all"]', $table).get(0);

            // If none of the checkboxes are checked
            if ($chkbox_checked.length === 0) {
                chkbox_select_all.checked = false;
                if (chkbox_select_all) {
                    chkbox_select_all = false;
                }
                // If all of the checkboxes are checked
            } else if ($chkbox_checked.length === $chkbox_all.length) {
                chkbox_select_all.checked = true;
                if (chkbox_select_all) {
                    chkbox_select_all.indeterminate = false;
                }
                // If some of the checkboxes are checked
            } else {
                chkbox_select_all.checked = false;
            }
        }

        function delete_publishers() {
            var pubData = [];
            var selected = $('#checkrow:checked');
            selected.each(function () {
                pubData.push($(this).attr('data-pubid'));
            });
            if (pubData.length <= 0) {
                alert("Please select publisher.");
            }
            console.log("aa", pubData);
            swal({
                title: `<?php echo $GLOBALS['want_delete_publisher']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {

                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: delete_url + pubData,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.msg = "Publisher has been deleted successfully!") {
                            window.scrollTo(0, 0);
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 2000);
                            setTimeout(function () {
                                location.reload();
                            }, 1200);
                        } else {
                            window.scrollTo(0, 0);
                            $("#alertfailed").show('medium');
                            setTimeout(function () {
                                $("#alertfailed").hide('medium');
                            }, 2000);
                        }
                    });
                }
            });
        }
    </script>

</body>

</html>