<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
	data-template="vertical-menu-template-free">

<head>
	<meta charset="utf-8" />
	<meta name="viewport"
		content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
	<title>
		<?php echo $projecttitle; ?> -
		<?php echo $GLOBALS['publishers']; ?>
	</title>
	<meta name="description" content="" />
	<?php include('head.php'); ?>
	<style>
		.cancel-style {
			color: red !important
		}

		input[type="button"]:hover {
			color: #fff !important;

		}

		.cancel-style:hover {
			color: #fff !important
		}

		.swal-footer {
			text-align: center;
		}

		.alert {
			display: none;
		}

		td {
			max-width: 200px;
			overflow: hidden;
			text-overflow: ellipsis;
			white-space: nowrap;
		}
	</style>
</head>

<body>
	<!-- Layout wrapper -->
	<div class="layout-wrapper layout-content-navbar">
		<div class="layout-container">
			<!-- Menu -->
			<?php include('sidebar.php'); ?>
			<!-- / Menu -->
			<!-- Layout container -->
			<div class="layout-page">
				<!-- Navbar -->
				<?php include('navbar.php'); ?>
				<!-- / Navbar -->
				<!-- Content wrapper <i class="menu-icon tf-icons bx bx-plus"></i> -->
				<div class="content-wrapper">
					<!-- Content -->
					<div class="container">
						<div class="card my-4">
							<div class="card-header">
								<div class="row mb-1">
								<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
									<p
										class="h2 text-secondary d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
										<?php echo $GLOBALS['import_publishers']; ?>
									</p>
								</div>
								<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
								<button class="btn btn-warning" type="button" id="publisher_add" onclick="window.location.href='../assets/templates/publisher_list_template.csv'"><i class="menu-icon tf-icons bx bx-file"></i><?php echo $GLOBALS['dowload_templete']; ?></button>
								</div>
								</div>
								<div class="row mb-1">
									<div class="col-12">
										<p class="alert bg-success alert-dismissible fade show text-white"
											id="alertsuccess"><i class="fa fa-check-circle"></i>
											<?php echo $GLOBALS['publisher_import_add']; ?>
										</p>
										<p class="alert bg-danger alert-dismissible fade show text-white"
											id="alertfailed"><i class="fa fa-times-circle"></i>
											<?php echo $GLOBALS['publisher_fail']; ?>
										</p>
										<p class="alert bg-warning alert-dismissible fade show text-white"
											id="alertwarning"><i class="fa fa-check-circle"></i>
											<?php echo $GLOBALS['user_exist']; ?>
										</p>
									</div>
								</div>
							</div>
							<div class="container">
								<div class="card-body">
									<div class="row">
									    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
											
										</div>
										<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-1">
											<label class="form-label" style="font-size: 1.4ch;">
												<?php echo $GLOBALS['import_publishers']; ?><span style="color: red;">*</span>
											</label>
											<input type="file" id="publisher_import" name="publisher_import" onchange = "csv_upload()" class="form-control text-dark"
												placeholder="<?php echo $GLOBALS['import_publishers']; ?>"/>
											<p id="publisher_import_error" class="h6 mt-1 text-danger"></p>
										</div>
										<div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
											
										</div>
									</div>

									<div class="row mb-2">

									</div>
									<div class="row mb-4">
										<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6"></div>
										<div
											class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
											<button class="btn btn-outline-danger cancel-style" type="button"
												style="margin-right: 2%;" id="cancel"
												onclick="window.location.href='publishers_list.php'">
												<?php echo $GLOBALS['strCancel']; ?>
											</button>
											<button class="btn btn-warning" type="button" id="save_changes"
												onclick="add_publisher()">
												<?php echo $GLOBALS['strSubmit']; ?>
											</button>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php include('footer.php'); ?>
			</div>
		</div>
	</div>
	<script>
		const live_URL = '<?php echo $apiinvenpath; ?>';
		const revivePath = '<?php echo $revivePath.'temp/'; ?>';
		const token = 'Bearer ' + document.getElementById('token').value;
		let userID = '<?php echo $_SESSION['user_id'] ?>';

		let agencyid = '<?php echo $_SESSION['agencyid'] ?>';

		let addpublisher_api = live_URL + '/publisher_import/';
		
		function csv_upload() {
		 let form_Data = new FormData();
		 form_Data.append("internal_file", publisher_import.files[0]);
		$.ajax({
			type: "POST",
			url: live_URL + '/csv_upload',
			beforeSend: function(xhr) {
				xhr.setRequestHeader('Authorization', token);
			},
			data: form_Data,
			dataType: "json",
			contentType: false,
			processData: false,
			// encode: true,
		}).done(function(data) {
        console.log('datas'+data.filename)
			// image_id = data.filename;
			$(".loader").hide();
			uploadFile =  data.filename ;

		});
		}

		add_publisher = () => {
			let publisher_import = document.getElementById('publisher_import').value;
			
			if (publisher_import == "") {
				document.getElementById('publisher_import_error').innerHTML = `<?php echo $GLOBALS['publisher_import']; ?>`;
			}  else {
			    
				upload_path = revivePath+uploadFile;
			
				let payload = {
					"internal_file": upload_path,
				};

				document.getElementById('publisher_import_error').innerHTML = "";
				$('#save_changes').prop('disabled', true);
				console.log("data", payload);
				$.ajax({
					type: "POST",
					url: addpublisher_api + agencyid,
					beforeSend: function (xhr) {
						xhr.setRequestHeader('Authorization', token);
					},
					data: payload,
					dataType: "json",
					encode: true,
				}).done(function (data) {
					if (data.msg == 'Publishers imported successfully..') {
						$("#alertsuccess").show('medium');
						setTimeout(function () {
							$("#alertsuccess").hide('medium');
							$('#save_changes').prop('disabled', false);
						}, 2000);
						setTimeout(function () {
							window.location.href = "publishers_list.php";
						}, 1700);
					} else if (data.msg == "Please upload csv file." && data.response == "error") {
						$("#alertwarning").show('medium');
						setTimeout(function () {
							$("#alertwarning").hide('medium');
							$('#save_changes').prop('disabled', false);
						}, 2000);
					} else {
						// location.reload();
						$("#alertfailed").show('medium');
						setTimeout(function () {
							$("#alertfailed").hide('medium');
							$('#save_changes').prop('disabled', false);
						}, 2000);
					}
				});
			}
		};
	</script>

</body>

</html>