<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - <?php echo $GLOBALS['linked_zones']; ?></title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

</head>
<style>
    .alert {
        display: none;
    }

    .text-hide {
        display: flex;
        width: 130px !important;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
    }

    .text-hide:hover {
        overflow: hidden;
    }

    .card-body {
        padding: 0 !important;
    }

    .dataTables_scrollBody {
        height: auto !important;
    }

    .table-striped {
        width: 1200px !important;
    }

    .text_convert {
        text-transform: capitalize;
    }

    .btn:disabled {
        pointer-events: none;
        opacity: 0.95;
        background-color: #9E9E9E;
        border-color: #9E9E9E;
    }

    .loader {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    .align_size {
        width: 800px;
    }

    td {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    td:hover {
        text-overflow: clip;
        white-space: normal;
        word-break: break-all;
    }
</style>

<body onload="zonelist();">
    <div class="loader"></div>
    <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->
                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top my-4 mx-3">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link text-dark" href="banner_edit.php?bannerid=<?php echo $_GET['bannerid']; ?>"><?php echo $GLOBALS['strBanner_Edit_Head']; ?></a>
                                </li>
                                <li class="nav-item" id="delivery_options">
                                    <a class="nav-link text-dark" href="delivery_options.php?bannerid=<?php echo $_GET['bannerid']; ?>"><?php echo $GLOBALS['delivery_options']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active text-warning" href="#">
                                        <?php echo $GLOBALS['linked_zones']; ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link text-dark" href="banner_advanced.php?bannerid=<?php echo $_GET['bannerid']; ?>"><?php echo $GLOBALS['advanced']; ?></a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="delivery_options_banner" role="tabpanel">
                                    <div class="row mt-2">
                                        <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                            <select id="publisher_list" name="publisher_list" class="form-select text-dark" onchange="get_websites();">
                                            </select>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                            <select id="website_list" name="website_list" class="form-select text-dark" onchange="get_website_zone();">

                                            </select>
                                        </div>
                                    </div>
                                    <br>
                                    <p class="alert bg-success alert-dismissible fade show text-white" id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['zone_success_alert']; ?>
                                    </p>
                                    <!-- <div class="row">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <p class="h3 mt-2">
                                                <?php echo $GLOBALS['link_banner_by_zone']; ?>
                                            </p>
                                        </div>
                                        <hr class="solid">
                                    </div> -->



                                    <div class="row mt-2 mb-4">
                                        <div class="table-responsive text-nowrap">
                                            <div class="row mt-2 mb-2">
                                                <div class="col col-12 col-sm-12 col-md-9 col-lg-9 col-xl-9 col-xxl-9">
                                                    <div class="" style="padding-left:20px;padding-top:10px;">
                                                        <input type="checkbox" class="form-check-input check-zone" id="select_all" value="Select_All">&nbsp;&nbsp;<b class="h6">
                                                            <?php echo $GLOBALS['sel_unsel_all']; ?>
                                                        </b>
                                                    </div>
                                                </div>
                                                <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 d-flex justify-content-start justify-content-sm-start justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                    <!-- <label class="form-label" for="inputName"><?php echo $GLOBALS['search']; ?></label> -->
                                                    <input type="text" id="searchInput" class="form-control" placeholder="Search Zone" />
                                                </div>
                                            </div>
                                            <table id="Zonelist" class="table table-responsive ">
                                                <thead>
                                                    <tr class="text-nowrap">
                                                        <th class="thauth-login-basic.html-color text-center">
                                                            <?php echo $GLOBALS['strName']; ?>
                                                        </th>
                                                        <th class="thauth-login-basic.html-color th-color text-center">
                                                            <?php echo $GLOBALS['link_banner_id']; ?>
                                                        </th>
                                                        <th class="thauth-login-basic.html-color th-color text-center">
                                                            <?php echo $GLOBALS['strInventory_Description']; ?>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody id="Zonelist_body">
                                                    <tr id="no_data">
                                                        <td class="text-center" colspan="3">
                                                            <?php echo $GLOBALS['strNo_Data_Meassages']; ?>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="justify-content-end">
                                            <div class="col" style="padding-left:10px">
                                                <button class="btn btn-warning text-white" id="save" onclick="savechanges();">
                                                    <?php echo $GLOBALS['save_changes']; ?>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->
                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <div class="content-backdrop fade"></div>
                    <!-- Content wrapper -->
                </div>
                <!-- / Layout page -->
            </div>

            <!-- Overlay -->
            <div class="layout-overlay layout-menu-toggle"></div>
        </div>
        <script>
            var live_URL = '<?php echo $apiinvenpath; ?>';
            var token = 'Bearer ' + document.getElementById('token').value;
            var test1 = [],
                test2 = [];
            var zone_data;

            var bannerid = '<?php echo $_REQUEST['bannerid']; ?>';
            var userid = '<?php echo $_SESSION['user_id']; ?>';
            var permissions = [];

            function zonelist() {
                $.ajax({
                    type: "GET",
                    url: live_URL + '/get_permissions/' + userid,
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    dataType: "json",
                    encode: true,
                }).done(function(data) {
                    let get_data = data.data;
                    if (get_data) {
                        for (var i = 0; i < get_data.length; i++) {
                            permissions[i] = get_data[i];
                        }
                    } else {
                        permissions = '';
                    }
                    if (!permissions.includes('37')) {
                        $('#delivery_options').hide();
                    }
                });

                $.ajax({
                    url: live_URL + '/get_bannersizewise_zone/' + bannerid,
                    type: 'GET',
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    dataType: 'json',
                    encode: true,
                    success: function(data) {
                        if (!data.data) {
                            $('#publisher_list').hide();
                            $('#website_list').hide();
                            $('#no_data').show();
                            $('#save').hide();
                            $('#searchInput').hide();
                            console.log('hello');
                        } else {
                            $('#publisher_list').show();
                            $('#website_list').show();
                            $('#no_data').hide();
                            $('#save').show();
                            $('#searchInput').show();

                            zone_data = data.data;
                            console.log('zone_data', zone_data);
                            var publisher_name = [];
                            let pub_id, pub_id1;

                            data.data.map((data, index) => {
                                if (index == 0) {
                                    pub_id = data.publisher_id;
                                    publisher_name += `<option value=${data.publisher_id}>${data.publisher_name}</option>`;
                                }
                                if (index > 0) {
                                    pub_id1 = data.publisher_id;
                                    if (pub_id != pub_id1) {
                                        publisher_name += `<option value=${data.publisher_id}>${data.publisher_name}</option>`;
                                        pubid = pub_id1
                                    }
                                }
                                document.getElementById('publisher_list').innerHTML = publisher_name;
                            });
                            get_websites();
                        }
                    },
                    error: function() {},
                });
            }

            function get_websites() {
                var publisher_id = $('#publisher_list').val();
                let web_data = zone_data;
                var website_name = [];
                web_data.map((data) => {
                    if (publisher_id == data.publisher_id) {
                        website_name += `<option value=${data.websiteid}>${data.websitename}</option>`;
                    }
                    document.getElementById('website_list').innerHTML = website_name;
                });
                get_website_zone();
            }

            function get_website_zone() {
                $("#Zonelist_body tr:gt(0)").empty();
                var website_id = $('#website_list').val();
                let zones;
                zone_data.map((data) => {
                    if (website_id == data.websiteid) {
                        zones = data.zones;
                    }
                });
                for (let i = 0; i < zones.length; i++) {
                    test1.push(zones[i].zonecount);
                    test2.push(zones[i].zoneid);
                    var row = $('<tr id="tr' + zones[i].zoneid + '"><td><input type="checkbox" class="child form-check-input select-checkbox" name="checkrow" id="checkrow' + zones[i].zoneid + '" value="' + zones[i].zoneid + '" data-zone-id="' + zones[i].zoneid + '" onclick="childChanged()">&nbsp;&nbsp;&nbsp;<i class="fa fa-image" aria-hidden="true"></i>&nbsp;<a href ="zone_edit.php?zoneid=' + zones[i].zoneid + '">' + zones[i].zonename + '</a></td><td class="text-center">' + zones[i].zoneid + '</td><td class="text-center">' + zones[i].zonedescription + '</td></tr>');
                    $('#Zonelist').append(row);
                    if (zones[i].zonecount == 1) {
                        $('#checkrow' + zones[i].zoneid).prop('checked', true);
                    }
                }
                if ($('.child:checked').length == $('.child').length) {
                    $('#select_all').prop('checked', true);
                } else {
                    $('#select_all').prop('checked', false);
                }
                console.log('zones', zones);
            }

            //search_table_start
            $("#searchInput").keyup(function() {
                var value = $(this).val().toLowerCase()
                if (value != '') {
                    // select all items
                    var allItems = $("#Zonelist_body tr")
                    // get list of matched items, (do not toggle them)
                    var matchedItems = $("#Zonelist_body tr:gt(0)").filter(function() {
                        return $(this).text().toLowerCase().indexOf(value) > -1
                    });
                    // hide all items first
                    allItems.toggle(false)
                    // then show matched items
                    matchedItems.toggle(true)
                    // if no item matched then show notFound row, otherwise hide it
                    if (matchedItems.length == 0) {
                        $('#no_data').show();
                    } else {
                        $('#no_data').hide();
                    }
                } else {
                    location.reload();
                }
            });

            function link_banner(linked_zones, unlinked_zones) {
                var zoneData = [];
                var linkzone;
                if (linked_zones != '') {
                    linkzone = linked_zones.split(',');
                    zoneData = linkzone.slice(0, -1);
                }
                console.log(zoneData);
                var link_url = live_URL + '/zonebyad_link/' + bannerid;
                var zoneData1 = {
                    "zoneid": "" + zoneData + "",
                }
                console.log(zoneData1);
                $.ajax({
                    type: "POST",
                    url: link_url,
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: zoneData1,
                    dataType: "json",
                    encode: true,
                }).done(function(data) {
                    if (unlinked_zones == '') {
                        window.scrollTo(0, 0);
                        $("#alertsuccess").show('medium');
                        setTimeout(function() {
                            $("#alertsuccess").hide('medium');
                        }, 1700);
                        setTimeout(function() {
                            location.reload();
                        }, 2000);
                    } else {
                        unlink_banner(unlinked_zones);
                    }
                });
            }

            function unlink_banner(unlinked_zones) {
                var zoneData1 = [];
                var unlinkzone;
                unlinkzone = unlinked_zones.split(',');
                zoneData1 = unlinkzone.slice(0, -1);

                console.log(zoneData1);
                var link_url = live_URL + '/zonebyad_unlink/' + bannerid;
                var zoneData2 = {
                    "zoneid": "" + zoneData1 + "",
                }
                $.ajax({
                    type: "POST",
                    url: link_url,
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: zoneData2,
                    dataType: "json",
                    encode: true,
                }).done(function(data) {
                    window.scrollTo(0, 0);
                    $("#alertsuccess").show('medium');
                    setTimeout(function() {
                        $("#alertsuccess").hide('medium');
                    }, 1700);
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                });

            }

            $(document).on('click', '#select_all', function() {
                console.log('hai');
                if (this.checked == true) {
                    $('.child').prop("checked", true);
                } else {
                    $('.child').prop("checked", false);
                }
            });

            function childChanged() {
                console.log('childChanged');
                if ($(".child:checked").length == $('.child').length) {
                    $('#select_all').prop('checked', true);
                } else {
                    $('#select_all').prop('checked', false);
                }
            }

            function savechanges() {
                var linked_zones = [];
                var unlinked_zones = [];
                $('.child:checked').each(function() {
                    linked_zones += this.value + ',';
                });
                $('.child:not(:checked)').each(function() {
                    unlinked_zones += this.value + ',';
                });
                link_banner(linked_zones, unlinked_zones);
                //unlink_banner(unlinked_zones);
            }
        </script>
</body>

</html>