<?php 
	include('session.php');
    include('../config.php');
    include('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - GEO Report </title>

    <meta name="description" content="" />
    <style>
        /* Loader */
        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        /* .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        } */

        .tableName {
			max-width: 200px;
			overflow: hidden;
			text-overflow: ellipsis;
			white-space: nowrap;
		}

		.tableName:hover {
            text-overflow: clip;
            white-space: normal;
            /* word-break: break-all; */
        }

        h5 {
            position: relative;
            left: 250%;
        }

        /* Geo Map Styles */
        #container1 {
            /* height: 500px;
            width: 800px; */
            height: auto;
            width: 100%;
            margin: 0 auto;
		}
			
		.highcharts-tooltip>span {
            padding: 10px;
            white-space: normal !important;
            width: 200px;
		}
			
		.loading {
            margin-top: 10em;
            text-align: center;
            color: gray;
		}
		
		.f32 .flag {
            vertical-align: middle !important;
		}

        /* .highcharts-legend-item{
		    display:none;
		} */
		
        /* .highcharts-exporting-group{
		display:none;
		 } */

         /* Close Button */
	   .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
		
		button.close 
		{
		padding: 0;
		background-color: transparent;
		border: 0;
		-webkit-appearance: none;
		-moz-appearance: none;
		appearance: none;
		}
		.close {
		float: right;
		font-size: 1.5rem;
		font-weight: 700;
		line-height: 1;
		color: #000;
		text-shadow: 0 1px 0 #fff;
		opacity: .5;
	}
    </style>

    <!-- <style>
        .svgMap-map-wrapper {
            background: #fff !important;
        }
        .svgMap-country {
            stroke: #8592a3 !important;
            /* stroke: #ADD8E6 !important; */
            stroke-width: 1 !important;
        }
    </style> -->

    <?php include('head.php'); ?>

    <link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">

    <!-- Geo Map -->
    <script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
	<script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
	<link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">
</head>


<body onload="onChangeDetails()">
<div class="loader"></div>
    <!-- Geo Map -->
    <script src="https://code.highcharts.com/maps/highmaps.js"></script>
	<script src="https://code.highcharts.com/maps/modules/data.js"></script>
	<script src="https://code.highcharts.com/maps/modules/exporting.js"></script>
	<script src="https://code.highcharts.com/maps/modules/offline-exporting.js"></script>
	<script src="https://code.highcharts.com/maps/modules/accessibility.js"></script>
    <link rel="stylesheet" type="text/css" href="https://github.com/downloads/lafeber/world-flags-sprite/flags32.css">

    
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container mb-3">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class='row'>
                                    <div class='col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start'>
                                        <h4 class="mb-4"><?php echo $GLOBALS['strReport_Geo_Report_Head']; ?></h4>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 h-75 mt-3 mt-sm-3 mt-md-1 mt-lg-1 mt-xl-1 mt-xxl-1 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id='getZone' class="form-select text-dark w-75" aria-label="Default select example"
                                            onchange="onChangeDetails()">
                                            <option value="country" selected><?php echo $GLOBALS['strGeo_Report_Country']; ?></option>
                                            <option value="region"><?php echo $GLOBALS['strGeo_Report_Region']; ?></option>
                                            <option value="city"><?php echo $GLOBALS['strGeo_Report_City']; ?></option>
                                        </select>
                                    </div>
                                    <div class='col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 h-75 mt-3 mt-sm-3 mt-md-1 mt-lg-1 mt-xl-1 mt-xxl-1 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start'>
                                        <select id='getDuration' name="allfilter" class="form-select text-dark w-75"
                                            aria-label="Default select example" onchange="onChangeDetails()">
                                            <option value="Today" selected><?php echo $GLOBALS['strToday']; ?></option>
                                            <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                            <option value="Last 7 days"><?php echo $GLOBALS['strLast_7_days']; ?></option>
                                            <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                            <option value="This Month"><?php echo $GLOBALS['strLast Month']; ?></option>
                                            <option value="Last Month"><?php echo $GLOBALS['strThis Month']; ?></option>
                                            <option value='All Statistics'><?php echo $GLOBALS['strAll Statistics']; ?></option>
                                            <option value="custom"><?php echo $GLOBALS['strCustom']; ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <input style="display: none; margin-left:3%; margin-right:10%;" id="daterange" name="daterange" class='mt-1'/>
                                </div>

                                <div id="container1"></div>

                                <!-- <div class="row mt-5"> -->
                                    <!-- <div class="mt-1 mb-3 container"> -->
                                        <div class="table-responsive text-nowrap">
                                            <table id="georep" class="table table-hover table-striped table-responsive">
                                                <thead id='geo_head'>
                                                    <tr class="text-nowrap text-dark">
                                                        <th class="th-color"><?php echo $GLOBALS['strGeo_Report_Country']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['campaign']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strImpression']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strClicks']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strCTR']; ?> %</th>
                                                        <th class="th-color"><?php echo $GLOBALS['strECPM']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strSpend']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody id='geo_table'></tbody>
                                            </table>
                                            <table id='region_table' class="table table-hover table-striped table-responsive">
                                                <thead id="region_head">
                                                    <tr>
                                                        <th class="th-color"><?php echo $GLOBALS['strGeo_Report_Country']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strGeo_Report_Region']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['campaign']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strImpression']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strClicks']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strCTR']; ?> %</th>
                                                        <th class="th-color"><?php echo $GLOBALS['strECPM']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strSpend']; ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                            <table id='city_table' class="table table-hover table-striped table-responsive">
                                                <thead id="city_head">
                                                    <tr>
                                                        <th class="th-color"><?php echo $GLOBALS['strGeo_Report_Country']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strGeo_Report_City']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['campaign']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strImpression']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strClicks']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strCTR']; ?> %</th>
                                                        <th class="th-color"><?php echo $GLOBALS['strECPM']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strSpend']; ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    <!-- </div> -->
                                <!-- </div> -->
                            </div>
                        </div>
                    </div>
                    <?php include('footer.php'); ?>
                </div>
                <!-- / Content -->
				<script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
                <script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
				
                <script>
                    const live_URL = '<?php echo $apistatpath; ?>';
                    const token = 'Bearer '+ document.getElementById('token').value;
                    let agency_id = document.getElementById('agencyid').value;
                    let getTodayDate;

                    //API's
                    let domain_url = live_URL+'/get_agency_georeport_statistics/';
                    let map_url = live_URL + '/get_agency_georeport_map_statistics/';
                
                    function onChangeDetails() {
                        $(".loader").show();
                        let date = new Date();
                        let filtervalue = document.getElementById('getDuration').value;

                        document.getElementById('daterange').style.display = filtervalue == 'custom'?"block":"none";
                        
                        switch(filtervalue) {
                            case 'Today':
                                let v3 = JSON.stringify(date).slice(1, 11);
                                getTodayDate = v3;
                                getGeoDetails(v3, v3);
                            break;
                            case 'Yesterday' :
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                                getGeoDetails(yesterday_date, yesterday_date);
                            break;
                            case 'Last 7 days':
                                let calculate_7dyas = date.setDate(date.getDate() - 7);
                                let start_7Days = new Date(calculate_7dyas);
                                let first_day = JSON.stringify(start_7Days).slice(1, 11);

                                let todayDate = new Date();
                                let current_7Dyas = todayDate.setDate(todayDate.getDate() - 1);
                                let last_7Days = new Date(todayDate);
                                let date_end = JSON.stringify(last_7Days).slice(1, 11);
                                getGeoDetails(first_day, date_end);
                            break;
                            case 'Last 30 days':
                                let calculate_30dyas = date.setDate(date.getDate() - 30);
                                let start_30Days = new Date(calculate_30dyas);
                                var first_30Days = JSON.stringify(start_30Days).slice(1, 11);

                                let today_Date = new Date();
                                let current_30Dyas = today_Date.setDate(today_Date.getDate() - 1);
                                let last_30Days = new Date(today_Date);
                                let final_30Days = JSON.stringify(last_30Days).slice(1, 11);
                                getGeoDetails(first_30Days, final_30Days);
                            break;
                            case 'Last Month': 
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function (date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                getGeoDetails(formatDate(prevMonthFirstDate), formatDate(prevMonthLastDate));
                            break;
                            case 'This Month':
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cYear = firstDay.getFullYear(), cMonth = firstDay.getMonth() + 1, cDate = firstDay.getDate();
                                let start_thisMonth = cYear + "-" + cMonth + "-" + cDate;

                                let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                                let end_thisMonth = year + "-" + month + "-" + day;
                                getGeoDetails(start_thisMonth, end_thisMonth);
                            break;
                            case 'All Statistics':
                                getGeoDetails(start_date=0, end_date=0);
                            break;
                            case 'custom':
                                $(".loader").hide();
                                getGeoDetails(getTodayDate, getTodayDate);
                                $(function () {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MM/YYYY'
                                        },
                                    }, function (start, end, label) {
                                        localStorage.setItem('custom_startDate', start.format('YYYY-MM-DD'));
                                        localStorage.setItem('custom_endDate', end.format('YYYY-MM-DD'));
                                        getGeoDetails(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                    })
                                })
                            break;                         
                        };
                    };

                    function getGeoDetails(start_date,end_date) {
                        let countryValue = document.getElementById('getZone').value;
                        let getSelectDay = document.getElementById('getDuration').value;
                        let getCustom_startDate = localStorage.getItem("custom_startDate");
                        let getCustom_endDate = localStorage.getItem("custom_endDate");

                        if(getSelectDay == 'custom'){
                            start_date = getCustom_startDate; end_date = getCustom_endDate;
                        }
                        else {
                            start_date = start_date; end_date = end_date;
                            localStorage.setItem('custom_startDate', getTodayDate);
                            localStorage.setItem('custom_endDate', getTodayDate);
                        }

                        let payload = (start_date ==0&& end_date==0)?{"action": 'all'}:
                        {"action": '',"start_date": start_date + ' 00:00:00,',"end_date": end_date + ' 23:59:59,'};
                        
                        // Geo Map
                        $.ajax({
                            url: map_url+agency_id,
                            type: 'POST',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
							},
                            data: payload,
                            success: function (data) {
                                if (data.msg == 'No Stats Available') {
                                    $(".loader").hide();
                                    (async () => {
										const topology = await fetch(
										    'https://code.highcharts.com/mapdata/custom/world.topo.json'
										).then(response => response.json());
										     
										// Initialize the chart
										Highcharts.mapChart('container1', {
										            
                                            chart: { map: topology },
										    title: { text: 'Geo Map' },
										    mapNavigation: {
										        enabled: true,
										        buttonOptions: {
										            algin:'left',
										            verticalAlign: 'top',
                                                    y:0,
                                                    x:0
										        }
										    },
										    tooltip: {
										        backgroundColor: 'none',
										        borderWidth: 0,
										        shadow: false,
										        useHTML: true,
										        padding: 0,
										        pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										        '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										        '<span style="font-size:18px; color:blue"><?php echo $GLOBALS['strImpression']; ?>: {point.impressions}</span><br>'+
										        '<span style="font-size:18px; color:blue"><?php echo $GLOBALS['strClicks']; ?>: {point.clicks}</span>',
										        positioner: function () {
										            return { x: 0, y: 250 };
										        }
										    },
										    colorAxis: {
										        min: 1,
										        max: 1000,
										        type: 'logarithmic'
										    },
										    series: [{
										        data: [],
										        joinBy: ['iso-a2', 'countrycode'],
										        name: `<?php echo $GLOBALS['geo_map']; ?>`,
										        states: {
										            hover: {
										                color: '#a4edba'
										            }
										        }
										    }],
											credits: false
										});
									})();
                                }
                                else {
                                    $(".loader").hide();
                                    (async () => {
										const topology = await fetch(
										    'https://code.highcharts.com/mapdata/custom/world.topo.json'
										).then(response => response.json());
										     
										// Initialize the chart
										Highcharts.mapChart('container1', {
                                            chart: { map: topology },
										    title: { text: 'Geo Map', margin: 20 },
										    mapNavigation: {
										        enabled: true,
										        buttonOptions: {
                                                    algin:'left',
										            verticalAlign: 'top',
                                                    y:0,
                                                    x:0,
										        }
										    },
										    tooltip: {
										        backgroundColor: 'none',
										        borderWidth: 0,
										        shadow: false,
										        useHTML: true,
										        padding: 0,
										        pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										        '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										        '<span style="font-size:18px; color:blue"><?php echo $GLOBALS['strImpression']; ?>: {point.impressions}</span><br>'+
										        '<span style="font-size:18px; color:blue"><?php echo $GLOBALS['strClicks']; ?>: {point.clicks}</span>',
										        positioner: function () {
										            return { x: 0, y: 280 };
										        }
										    },
										    colorAxis: {
										        min: 1,
										        max: 1000,
										        type: 'logarithmic'
										    },
										    series: [{
										        data: data,
										        joinBy: ['iso-a2', 'countrycode'],
										        name:`<?php echo $GLOBALS['geo_map']; ?>`,
										        states: {
										            hover: {
										                color: '#a4edba'
										            }
										        }
										    }],
											credits: false,
                                            responsive: {  
                                                rules: [{  
                                                    condition: {  
                                                      maxWidth: 500  
                                                    },  
                                                    chartOptions: {  
                                                      legend: {  
                                                        enabled: false  
                                                      }  
                                                    }  
                                                }]  
                                            }
										});
									})();
                                }
							},error: function () { },
						});

                        //Geo Table
                        $.ajax({
                            url: domain_url + agency_id,
                            type: 'POST',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: payload,
                            success: function (data) {                 
                                if (data.msg == 'No Stats Available') {
                                    $(".loader").hide();
                                    
                                    if(countryValue == 'country') {
                                        $('#region_table').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').parents('div.dataTables_wrapper').first().hide();
                                        document.getElementById('region_table').style.display = "none";
                                        document.getElementById('city_table').style.display = "none";
                                        $('#georep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:`<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                            }
                                        });
                                        document.getElementById('getZone').disabled = true;
                                    }
                                    else if (countryValue == 'region') {
                                        document.getElementById('georep').style.display = "none";
                                        document.getElementById('city_table').style.display = "none";
                                        $('#georep').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').parents('div.dataTables_wrapper').first().hide();
                                        $('#region_table').DataTable({
                                        ordering: false,
                                        destroy: true,
                                        responsive: true,
                                        bPaginate: false,
                                        bInfo: false,
                                        data:[],
                                        searching: false,
                                        oLanguage: {
                                            sEmptyTable:`<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                        }
                                        });
                                        document.getElementById('getZone').disabled = true;
                                    }
                                    else if (countryValue == 'city') {
                                        document.getElementById('region_table').style.display = "none";
                                        document.getElementById('georep').style.display = "none";
                                        $('#georep').parents('div.dataTables_wrapper').first().hide();
                                        $('#region_table').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:`<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                            }
                                        });
                                        document.getElementById('getZone').disabled = true;
                                    }
                                }
                                else {
                                    $(".loader").hide();
                                    document.getElementById('getZone').disabled = false;
                                    if (countryValue == 'country') {
                                        document.getElementById('georep').style.display = "table";
                                        document.getElementById('region_table').style.display = "none";
                                        document.getElementById('city_table').style.display = "none";
                                        $('#region_table').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').parents('div.dataTables_wrapper').first().hide();

										$('#georep').DataTable({
                                            ordering: true,
										    destroy: true,
											data: data,
											columns: [
												{ data: 'country'},
												{ data: 'campaignname', className:'tableName' },
												{ data: 'impressions', className: "text-center" },
												{ data: 'clicks', className: "text-center" },
												{ data: 'ctr', className: "text-start" },
                                                { data: 'ecpm', className: "text-start"},
												{ data: 'total_revenue', className: "text-start" }
											],
                                            initComplete: function(settings) {
											    $('#'+settings.nTable.id+'_filter input')
                                                .wrap(`<div class="d-inline-flex position-relative"></div>`)
                                                .after(`<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
												        	  <span aria-hidden="true">&times;</span>
												        </button>`)
                                                .attr('required','required')
                                                .attr('title','Search');
                                              
											    // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												    $('#'+settings.nTable.id).DataTable({"retrieve": true})
                                                    .search('').draw(); // reDraw table
											    });
										    }
										});
                                                
                                    }
                                    else if (countryValue == 'region') {
                                        document.getElementById('region_table').style.display = "table";
                                        document.getElementById('georep').style.display = "none";
                                        document.getElementById('city_table').style.display = "none";
                                        $('#georep').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').parents('div.dataTables_wrapper').first().hide();
                                                
										$('#region_table').DataTable({
                                            ordering: true,
										    destroy: true,
											data: data,
											columns: [
												{ data: 'country' },
												{ data: 'region', className:'tableName' },
												{ data: 'campaignname', className:'tableName' },
												{ data: 'impressions', className: "text-center"},
												{ data: 'clicks', className: "text-center"},
												{ data: 'ctr' },
                                                { data: 'ecpm' },
												{ data: 'total_revenue' }
											],
                                            initComplete: function(settings){
											    $('#'+settings.nTable.id+'_filter input')
                                                .wrap(`<div class="d-inline-flex position-relative"></div>`)
                                                .after(`<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													        <span aria-hidden="true">&times;</span>
													    </button>`)
                                                .attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw();
											    });
											}
										});
                                    }
                                    else if (countryValue == 'city') {
                                        document.getElementById('city_table').style.display = "table";
                                        document.getElementById('region_table').style.display = "none";
                                        document.getElementById('georep').style.display = "none";
                                        $('#georep').parents('div.dataTables_wrapper').first().hide();
                                        $('#region_table').parents('div.dataTables_wrapper').first().hide();

										$('#city_table').DataTable({
                                            ordering: true,
										    destroy: true,
											data: data,
											columns: [
												{ data: 'country' },
												{ data: 'city' },
												{ data: 'campaignname', className:'tableName' },
												{ data: 'impressions', className: "text-center" },
												{ data: 'clicks', className: "text-center" },
												{ data: 'ctr' },
                                                { data: 'ecpm' },
												{ data: 'total_revenue' }
											],
                                            initComplete: function(settings){
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input')
                                                .wrap(`<div class="d-inline-flex position-relative"></div>`)
                                                .after(`<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
											    	        <span aria-hidden="true">&times;</span>
											    	    </button>`)
                                                .attr('required','required').attr('title','Search');
                                        
											    // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
											     $('#'+settings.nTable.id).DataTable({
											       "retrieve": true,
											      }).search('').draw(); // reDraw table
											    });
											}
										});
                                    }
                                    else {
                                        console.log("geo is Not working");
                                    }
                                }                                
                                    
                            }
                        });
                    };

                </script>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>
</html>