<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['banner']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<style>
    td {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    td:hover {
        text-overflow: clip;
        white-space: normal;
        word-break: break-all;
    }

    .swal-button--danger {
        background-color: #2523b3;
        width: 100px;
    }

    .swal-button--cancel {
        color: white;
        width: 100px;
        background-color: #ff3e1d;
    }

    .swal-button--cancel:not([disabled]):hover {
        background-color: red;
    }

    .swal-button--danger:not([disabled]):hover {
        background-color: #2523b3;
    }

    .swal-footer {
        text-align: center;
    }

    .dataTables_scrollBody {
        height: auto !important;
    }

    .table-striped {
        width: 1200px !important;
    }

    .text_convert {
        text-transform: capitalize;
    }

    .loader {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    .align_size {
        width: 800px;
    }

    #image_preview,
    #html5_preview:hover {
        cursor: pointer;
        text-align: center;
        width: max-content;
    }

    /* #htmlTag_preview:hover {
        width: 100%;
    } */

    #htmlTag_preview:hover {
        color: blue;
        text-decoration: underline;
    }

    .alert {
        display: none;
    }

    /* img {
        max-width: 100%;
        height: auto;
    } */

    /* .h4 {
        color: #0e107c;
    } */
</style>

<!-- <body onload="bannerList();"> -->

<body onload="get_advertisers();">
    <div class="loader"></div>
    <input type="hidden" name="clientid" id="clientid" value="<?php echo $_GET['clientid']; ?>" />
    <input type="hidden" name="client_id" id="client_id" value="<?php echo $_GET['client_id']; ?>" />
    <input type="hidden" name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
    <input type="hidden" name="campaign_id" id="campaign_id" value="<?php echo $_GET['campaign_id']; ?>" />

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card my-4">
                            <div class="card-body">
                                <div class="row">
                                    <div
                                        class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3">
                                            <?php echo $GLOBALS['banner']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                        <select id="advertiser_list" name="advertiser_list"
                                            class="form-select text-dark" onchange="get_campaigns('changed');">

                                        </select>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                        <select id="campaign_list" name="campaign_list" class="form-select text-dark"
                                            onchange="get_banners('changed');">

                                        </select>
                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-warning" id="backTo_campaignList"
                                            onclick="back_button()">
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>&nbsp;
                                        <button type="button" class="btn btn-warning" id="deleteBannerButton"
                                            style="display:none;">
                                            <i class="bx bx-trash bg-label-white" aria-hidden="true" title="Delete"></i>
                                            <?php echo $GLOBALS['strInventory_DeleteCampaign']; ?>
                                        </button>&nbsp;
                                        <button id="addBannerButton" class="btn btn-warning" onclick="bannerAdd()"
                                            style="display:none;">
                                            <i class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['strInventory_AddBanner']; ?>
                                        </button>
                                    </div>
                                </div>
                                <hr class="solid">

                                <div class="row">
                                    <div class="col-12">
                                        <p id="warning" class="h6 alert text-black"
                                            style="background: #ffffb3; display:none;"><strong>
                                                <?php echo $GLOBALS['warning']; ?>
                                            </strong>&nbsp;<span id="warning_msg"></span></p>
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['banner_deleted_successfully']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div
                                    class="row justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                        <select id="bannerlist_type" name="bannerlist_type"
                                            class="form-select text-dark" onchange="get_banners();">
                                            <option selected value="1">
                                                <?php echo $GLOBALS['all_banners']; ?>
                                            </option>
                                            <option value="0">
                                                <?php echo $GLOBALS['active_banners']; ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="table-responsive text-nowrap">
                                        <table id="Bannerlist" class="table table-striped table-hover">
                                            <thead>
                                                <tr class="text-nowrap">
                                                    <th class="th-color text-center">
                                                        <input class="form-check-input" type="checkbox"
                                                            name="select_all">
                                                    </th>
                                                    <th class="thauth-login-basic.html-color th-color text-start">
                                                        <?php echo $GLOBALS['strName']; ?>
                                                    </th>
                                                    <th class="thauth-login-basic.html-color th-color text-center">
                                                        <?php echo $GLOBALS['types']; ?>
                                                    </th>
                                                    <th class="thauth-login-basic.html-color th-color text-center">
                                                        <?php echo $GLOBALS['strSize']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['strURL']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['updated']; ?>
                                                    </th>
                                                    <th class="thauth-login-basic.html-color th-color text-center"
                                                        style="width:100px">
                                                        <?php echo $GLOBALS['strInventory_Campaign_List_Status']; ?>
                                                    </th>
                                                    <th class="thauth-login-basic.html-color th-color text-center">
                                                        <?php echo $GLOBALS['strInventory_Campaign_List_Action']; ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Modal -->
                    <div class="modal fade " id="modalpreview" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-scrollable modal-xl" role="document">
                            <div class="modal-content" id="modal_preview">
                                <div class="modal-header">
                                    <h5 class="modal-title text-warning" id="exampleModalLabel1">
                                        <?php echo $GLOBALS['bannerpreview']; ?>
                                    </h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body image">
                                    <div class="row">
                                        <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                            <p id="prepend_data" class="text-center">
                                            </p>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                            <center><a href="" id="banner_preview" target="_blank">
                                                    <img src="" alt="Preview Not Available" class="center"
                                                        id="image_preview" />
                                                    <div id="html5_id">
                                                        <iframe src="" class="border-secondary"
                                                            id="html5_preview" style="width:500px;height:500px;display:none;"></iframe>
                                                        <p id="htmlText_preview" style="display:none;"></p>
                                                    </div>
                                                    <div id="htmlTag_preview" style="display:none;"></div>
                                                </a></center>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                            <p id="append_data" class="text-center"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <!-- <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                        Close
                                    </button> -->
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <?php include('footer.php'); ?>

                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper ,className: " text-hide"-->
    <script>
        const live_URL = '<?php echo $apiinvenpath; ?>';
        const token = 'Bearer ' + document.getElementById('token').value;
        let getClient_Id = document.getElementById('client_id').value;
        let getClientId = document.getElementById('clientid').value;
        let getCampaign_Id = document.getElementById('campaign_id').value;
        let getCampaignId = document.getElementById('campaignid').value;
        var agencyid = document.getElementById('agencyid').value;
        let userid = '<?php echo $_SESSION['user_id']; ?>';
        let activeDeactive = live_URL + '/banner_status_update/';
        let delete_url = live_URL + '/delete_banner/';
        let CampaignWiseBanner_URL = live_URL + '/get_campaignwise_banner/';
        var permissions = [];

        var advValue = localStorage.getItem("advValue");
        var camValue = localStorage.getItem("camValue");

        document.getElementById("deleteBannerButton").disabled = true;
        document.getElementById('append_data').style.display = "none";
        document.getElementById('prepend_data').style.display = "none";
        document.getElementById('backTo_campaignList').style.display = (getCampaign_Id == "") ? "none" : "block";

        function get_advertisers() {
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_advertiser/' + agencyid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                var client_name = [];
                if (!data.data) {
                    $('#advertiser_list').hide();
                    $('#campaign_list').hide();
                    $('#bannerlist_type').hide();
                    $('#addBannerButton').attr("disabled", true);
                    $('#warning').show();
                    $('#warning_msg').html("<?php echo $GLOBALS['orders_warning']; ?>");
                    get_banners();
                } else {
                    $('#advertiser_list').show();
                    $('#campaign_list').show();
                    $('#bannerlist_type').show();
                    $('#addBannerButton').attr("disabled", false);
                    $('#warning').hide();
                    data.data.map((data) => {
                        getclientnameLength = (data.clientname.length > 30) ? (data.clientname.slice(0, 30) + '...') : data.clientname;
                        // $str=data.clientname;
                        // getclientnameLength=wordwrap($str,20,"<br>\n",TRUE);
                        client_name += `<option value=${data.clientid} title="${data.clientname}">${getclientnameLength}</option>`;
                        document.getElementById('advertiser_list').innerHTML = client_name;
                    });
                    if (getClientId != '') {
                        $('#advertiser_list').val(getClientId);
                       $('#advertiser_list').attr("disabled", true);
                    } else if (getClient_Id != '') {
                        $('#advertiser_list').val(getClient_Id);
                        $('#advertiser_list').attr("disabled", true);
                    } else if (advValue != '' && advValue != null && advValue != 'undefined') {
                        $('#advertiser_list option').each(function () {
                            if (this.value == advValue) {
                                $("#advertiser_list").val(advValue);
                            }
                        });
                    }
                    get_campaigns();
                }
            });
        }

        function get_campaigns(changed) {
            var advertiser_id = $("#advertiser_list option:selected").val();
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_campaigns/' + advertiser_id,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                var campaign_name = [];
                if (!data.data) {
                    $('#campaign_list').hide();
                    $('#addBannerButton').attr("disabled", true);
                    $('#campaign_list').val('');
                    $('#warning').show();
                    $('#warning_msg').html("<?php echo $GLOBALS['campaigns_warning']; ?>");
                    get_banners();
                } else {
                    $('#campaign_list').show();
                    $('#addBannerButton').attr("disabled", false);
                    $('#warning').hide();
                    data.data.map((data) => {
                        getcampaignLength = (data.campaignname.length > 30) ? (data.campaignname.slice(0, 30) + '...') : data.campaignname;
                        campaign_name += `<option value=${data.campaignid} title="${data.campaignname}">${getcampaignLength}</option>`;
                        document.getElementById('campaign_list').innerHTML = campaign_name;
                    });
                    if (changed) {
                        camValue = '';
                        localStorage.removeItem('camValue');
                        location.reload();
                    }
                    if (getCampaignId != '') {
                        $('#campaign_list').val(getCampaignId);
                    } else if (getCampaign_Id != '') {
                        $('#campaign_list').val(getCampaign_Id);
                        $('#campaign_list').attr("disabled", true);
                    } else if (camValue != '' && camValue != null && camValue != 'undefined') {
                        $('#campaign_list option').each(function () {
                            if (this.value == camValue) {
                                $("#campaign_list").val(camValue);
                            }
                        });
                    }
                    get_banners();
                }

            });
        }

        function get_banners(changed) {
            var advertiser_id = $("#advertiser_list option:selected").val();
            var campaign_id = $("#campaign_list option:selected").val();
            var bannerlist_type = $("#bannerlist_type option:selected").val();
            $.ajax({
                url: CampaignWiseBanner_URL + campaign_id + ',' + bannerlist_type,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                success: function (data) {
                    $(".loader").hide();
                    if (data.msg == 'No Data' && data.statuscode == 200) {
                        $('#Bannerlist').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bAutoWidth: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } else if (data.msg == 'Requested banner not available' && data.statuscode == 200) {
                        $('#Bannerlist').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bAutoWidth: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } else {
                        let rows_selected = [],
                            getValue, getValue2;
                        let table = $('#Bannerlist').DataTable({
                            destroy: true,
                            targets: 0,
                            searchable: false,
                            orderable: false,
                            // ordering: false,
                            stateSave: true,
                            data: data.data,
                            columns: [{
                                data: 'bannerid',
                                className: " text-center",
                                render: function (data, type, row, meta) {
                                    return '<input class="data-checked form-check-input" type="checkbox" name="checkrow" id="checkrow" value="' + row.bannerid + '" data-banner-id="' + row.bannerid + '">';
                                }
                            },
                            {
                                data: 'description',
                                className: "text-start",
                                render: function (data, type, row, meta) {
                                    if (getCampaign_Id != "") {
                                        getValue = '<a class="test " style="width: 14rem;" href="banner_edit.php?bannerid=' + row.bannerid + '&campaign_id=' + getCampaign_Id + '">' + row.description + '</a>';
                                    } else {
                                        getValue = '<a class="test " style="width: 14rem;" href="banner_edit.php?bannerid=' + row.bannerid + '">' + row.description + '</a>';
                                    }
                                    return getValue;
                                }
                            },
                            {
                                data: 'storagetype',
                                className: "text-center",
                                render: function (data, type, row, meta) {
                                    // return '<div style="width:5rem"><p>'+row.storagetype+'</p></div>';
                                    var storagetype;
                                    if (row.ext_bannertype == "web") {
                                        storagetype = `<?php echo $GLOBALS['strWeb']; ?>`;
                                    } else if (row.ext_bannertype == "sql") {
                                        storagetype = `<?php echo $GLOBALS['strSQL']; ?>`;
                                    } else if (row.ext_bannertype == "url") {
                                        storagetype = `<?php echo $GLOBALS['strURL']; ?>`;
                                    } else if (row.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml") {
                                        storagetype = `<?php echo $GLOBALS['strHTML']; ?>`;
                                    } else if (row.ext_bannertype == "bannerTypeHtml:oxHtml:html5") {
                                        storagetype = `<?php echo $GLOBALS['strHTML_5']; ?>`;
                                    } else if (row.ext_bannertype == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml") {
                                        storagetype = `<?php echo $GLOBALS['inline']; ?>`;
                                    } else if (row.ext_bannertype == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml") {
                                        storagetype = `<?php echo $GLOBALS['overlay']; ?>`;
                                    } else if (row.ext_bannertype == "bannerTypeText:oxText:genericText") {
                                        storagetype = `<?php echo $GLOBALS['strText']; ?>`;
                                    } else {
                                        storagetype = "";
                                    }
                                    return storagetype;
                                }
                            },
                            {
                                data: 'width',
                                className: "text-center",
                                render: function (data, type, row, meta) {
                                    if (row.width > 0 || row.height > 0) {
                                        // return '<div style="width:7rem"><p>'+row.width + ' * ' + row.height+'</p></div>';
                                        return row.width + ' * ' + row.height;
                                    } else {
                                        // return '<div style="width:5rem"><p> - </p></div>';
                                        return "-"
                                    }
                                }
                            },
                            {
                                data: 'url',
                                className: 'text-start'
                            },
                            {
                                data: 'updated',
                                className: 'text-center'
                            },
                            {
                                data: 'status',
                                // width: '68%',
                                render: function (data, type, row, meta) {
                                    if (row.status == 0) {
                                        var status = '<div><span class="badge bg-success fw-bold p-2 text_convert text-center" style="width:80px">&nbsp;  <?php echo $GLOBALS['strInventory_Campaign_List_Active']; ?> &nbsp;</span>&nbsp;<a href="#"> <i class="fa fa-toggle-on text-danger" id="Deactivate" aria-hidden="true" title=<?php echo $GLOBALS['deactivate']; ?> style="font-size:20px"  onclick="activeDeactivate(' + row.bannerid + ');"></i></a></div>';
                                    } else {
                                        var status = '<div><span class="badge bg-danger fw-bold p-2 text_convert" style="width:80px">&nbsp;<?php echo $GLOBALS['strInventory_Campaign_List_Inactive']; ?>&nbsp;</span>&nbsp; <a href="#"> <i class="fa fa-toggle-on text-success" id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['activate']; ?> style="font-size:20px;"  onclick="activeDeactivate(' + row.bannerid + ');"></i></a></div>';
                                    }
                                    return status;
                                },
                                className: 'urltext text-center',
                            },
                            {
                                data: 'bannerid',
                                className: 'text-center',
                                render: function (data, type, row, meta) {
                                    let actionButtons;
                                    if (row.ext_bannertype == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml") {
                                        actionButtons = '<a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-warning atag" id="atag" href="banner_edit.php?bannerid=' + row.bannerid + '"><i class="bx bx-edit mt-0 label-warning"></i></a>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-warning delivery_btn" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a><span class="delivery_btn">&nbsp;&nbsp;</span><a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-warning" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>';
                                    } else if (row.ext_bannertype == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml") {
                                        actionButtons = '<a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-warning atag" id="atag" href="banner_edit.php?bannerid=' + row.bannerid + '"><i class="bx bx-edit mt-0 label-warning"></i></a>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-warning delivery_btn" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a><span class="delivery_btn">&nbsp;&nbsp;</span><a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-warning" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>';
                                    } else {
                                        if (getCampaign_Id != "") {
                                            actionButtons = '<a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-warning atag" id="atag" href="banner_edit.php?bannerid=' + row.bannerid + '&campaignid=' + getCampaign_Id + '"><i class="bx bx-edit mt-0 label-warning"></i></a>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-warning delivery_btn" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a><span class="delivery_btn">&nbsp;&nbsp;</span><button type="button" title=<?php echo $GLOBALS['bannerpreview_list']; ?> id="preview_button" onclick="previewBanner(' + row.bannerid + ')" class="btn btn-icon btn-xs btn-warning" data-bs-toggle="modal" data-bs-target="#modalpreview"><i class="bx bx-show"></i></button>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-warning" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>';
                                        } else {
                                            actionButtons = '<a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-warning atag" id="atag" href="banner_edit.php?bannerid=' + row.bannerid + '"><i class="bx bx-edit mt-0 label-warning"></i></a>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-warning delivery_btn" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a><span class="delivery_btn">&nbsp;&nbsp;</span><button type="button" title=<?php echo $GLOBALS['bannerpreview_list']; ?> id="preview_button" onclick="previewBanner(' + row.bannerid + ')" class="btn btn-icon btn-xs btn-warning" data-bs-toggle="modal" data-bs-target="#modalpreview"><i class="bx bx-show"></i></button>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-warning" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>';
                                        }
                                    }
                                    return actionButtons;
                                }
                            },
                            ],
                            // 'columnDefs': [{
                            //     'targets': [0, 7], // column index (start from 0)
                            //     'orderable': false, // set orderable false for selected columns
                            // }]
                        });

                        // Handle click on checkbox
                        $('#Bannerlist tbody').on('click', 'input[type="checkbox"]', function (e) {
                            let $row = $(this).closest('tr');
                            let data = table.row($row).data();
                            let rowId = table.row(this).data[0];
                            let index = $.inArray(rowId, rows_selected);

                            if (this.checked && index === -1) {
                                rows_selected.push(rowId);
                            } else if (!this.checked && index !== -1) {
                                rows_selected.splice(index, 1);
                            }

                            if (this.checked) {
                                $row.addClass('selected');
                                document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            } else {
                                $row.removeClass('selected');
                                document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            }
                            updateDataTableSelectAllCtrl(table);
                            e.stopPropagation();
                        });

                        // Handle click on "Select all" control
                        $('thead input[name="select_all"]', table.table().container()).on('click', function (e) {
                            if (this.checked) {
                                $('#Bannerlist tbody input[type="checkbox"]:not(:checked)').trigger('click');
                                document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            } else {
                                $('#Bannerlist tbody input[type="checkbox"]:checked').trigger('click');
                                document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            }
                            e.stopPropagation();
                        });

                        // Handle table draw event
                        table.on('draw', function () {
                            updateDataTableSelectAllCtrl(table);
                        });
                    }
                },
                error: function (xhr, status, errorThrown) {
                    console.log("error");
                },
            });
            $.ajax({
                type: "GET",
                url: live_URL + '/get_permissions/' + userid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: "json",
                encode: true,
            }).done(function (data) {
                let get_data = data.data;
                if (get_data) {
                    for (var i = 0; i < get_data.length; i++) {
                        permissions[i] = get_data[i];
                    }
                } else {
                    permissions = '';
                }
                if (!permissions.includes('35')) {
                    $('#addBannerButton').hide();
                } else {
                    $('#addBannerButton').show();
                }
                if (!permissions.includes('36') || !permissions.includes('12')) {
                    $('#Bannerlist').DataTable().column(0).visible(false);
                    $('#deleteBannerButton').hide();
                } else {
                    $('#Bannerlist').DataTable().column(0).visible(true);
                    $('#deleteBannerButton').show();
                }
                if (!permissions.includes('37')) {
                    $('.delivery_btn').hide();
                } else {
                    $('.delivery_btn').show();
                }
            });
            if (changed) {
                localStorage.setItem("camValue", campaign_id);
                location.reload();
            }
            localStorage.setItem("advValue", advertiser_id);

        };

        bannerAdd = () => {
            let advertiser_id = $("#advertiser_list option:selected").val();
            let campaign_id = $("#campaign_list option:selected").val();
            window.location.href = (getCampaign_Id == '') ? 'banner_add.php?clientid=' + advertiser_id + '&campaignid=' + campaign_id : (getCampaign_Id != '' && getClientId != "") ? 'banner_add.php?clientid=' + getClientId + '&campaign_id=' + campaign_id :
                'banner_add.php?client_id=' + advertiser_id + '&campaign_id=' + getCampaign_Id;
        };

        previewBanner = (bannerId) => {
            $('#image_preview, #html5_preview').attr("src", '');
            $.ajax({
                url: live_URL + '/get_banner/' + bannerId,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                success: function (data) {
                    document.getElementById('append_data').style.display = data.data.append == "" ? "none" : "block";
                    document.getElementById('prepend_data').style.display = data.data.prepend == "" ? "none" : "block";
                    document.getElementById('append_data').innerHTML = data.data.append;
                    document.getElementById('prepend_data').innerHTML = data.data.prepend;
                    //$('#html5_preview, #image_preview, #htmlText_preview, #htmlTag_preview').hide();
                    $('#banner_preview').attr("href", data.data.url);
                    var banner_type = data.data.ext_bannertype;
                    if (banner_type == 'web' || banner_type == 'sql' || banner_type == 'url') {
                        $('#image_preview').show();
                        $('#html5_preview, #htmlText_preview, #htmlTag_preview').hide();
                        $('#image_preview').attr("src", data.data.imageurl);
                    } else if (banner_type == 'bannerTypeHtml:oxHtml:html5') {
                        $('#html5_preview').show();
                        $('#image_preview, #htmlText_preview, #htmlTag_preview').hide();
                        $('#html5_preview').attr("src", data.data.imageurl);
                    } else if (banner_type == 'bannerTypeText:oxText:genericText') {
                        $('#htmlText_preview').show();
                        $('#html5_preview, #image_preview, #htmlTag_preview').hide();
                        $('#htmlText_preview').html(data.data.bannertext);
                    } else if (banner_type == 'bannerTypeHtml:oxHtml:genericHtml') {
                        $('#htmlTag_preview').show();
                        $('#html5_preview, #image_preview, #htmlText_preview').hide();
                        $('#htmlTag_preview').html(data.data.htmltemplate);
                    }
                    // document.getElementById('html5_preview').style.display = data.data.ext_bannertype == 'bannerTypeHtml:oxHtml:html5' ? "block" : "none";
                    // document.getElementById('image_preview').style.display = data.data.ext_bannertype == 'web' ? 'inline' :
                    //     data.data.ext_bannertype == 'sql' ? 'inline' : data.data.ext_bannertype == 'url' ? 'inline' :
                    //     data.data.ext_bannertype == "bannerTypeText:oxText:genericText" ? "none" : "none";
                    // document.getElementById('image_preview').src = data.data.imageurl;
                    // document.getElementById('html5_preview').src = data.data.imageurl;

                    // document.getElementById('append_data').style.display = data.data.append == "" ? "none" : "block";
                    // document.getElementById('prepend_data').style.display = data.data.prepend == "" ? "none" : "block";
                    // document.getElementById('append_data').innerHTML = data.data.append;
                    // document.getElementById('prepend_data').innerHTML = data.data.prepend;
                    // document.getElementById('banner_preview').href = data.data.url !== "" ? data.data.url : "";
                    // document.getElementById('banner_preview').target = data.data.url !== "" ? "_blank" : "";

                    // document.getElementById('htmlText_preview').style.display = data.data.ext_bannertype == "bannerTypeText:oxText:genericText" ? "block" : "none";
                    // document.getElementById('htmlText_preview').innerHTML = (data.data.ext_bannertype == "bannerTypeText:oxText:genericText" && data.data.bannertext == "") ? `<?php echo $GLOBALS['no_text']; ?>` : data.data.bannertext;
                    // document.getElementById('htmlText_preview').style.color = (data.data.ext_bannertype == "bannerTypeText:oxText:genericText" && data.data.url == "") ? "black" : "blue";
                    // document.getElementById('htmlText_preview').style.cursor = (data.data.ext_bannertype == "bannerTypeText:oxText:genericText" && data.data.url == "") ? "context-menu" : "pointer";

                    // document.getElementById('htmlTag_preview').innerHTML = data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" ? `${data.data.htmltemplate}` : "";
                    // document.getElementById('htmlTag_preview').style.display = data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" ? "block" : "none";
                    // document.getElementById('htmlTag_preview').style.color = (data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" && data.data.url == "") ? "black" : "blue";
                    // document.getElementById('htmlTag_preview').style.cursor = (data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" && data.data.url == "") ? "context-menu" : "pointer";
                    // document.getElementById('htmlTag_preview').style.textDecoration = (data.data.ext_bannertype == "bannerTypeHtml:oxHtml:genericHtml" && data.data.url == "") ? "" : "underline";
                }
            });
        };

        function activeDeactivate(bannerid) {
            swal({
                title: `<?php echo $GLOBALS['update_status']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        type: "POST",
                        url: activeDeactive + bannerid,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.msg == "Banner Activated successfully!") {
                            location.reload();
                            // $("#activestatus").css("color", "#696cff");
                        } else {
                            location.reload();
                            // $("#activestatus").css("color", "#777");  
                        }
                    });
                } else {

                }
            });
        };

        function deleteBanner(bannerid) {
            swal({
                title: `<?php echo $GLOBALS['want_delete_banner']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {
                $(".loader").show();
                if (isConfirm) {
                    $.ajax({
                        url: delete_url + bannerid,
                        type: "DELETE",
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.msg = "Banner deleted successfully!" && data.statuscode == 200) {
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 1700);
                            setTimeout(function () {
                                location.reload();
                            }, 1700);
                        }
                    })
                    $(".loader").hide();
                } else {
                    // swal("Banner is Not Delete");
                    $(".loader").hide();
                }
            });
        };

        $('#deleteBannerButton').on('click', function (e) {
            let employee = [];
            $(".data-checked:checked").each(function () {
                employee.push($(this).attr('data-banner-id'));
            });
            if (employee.length <= 0) {
                alert("Please select records.");
            }
            swal({
                title: `<?php echo $GLOBALS['want_delete_banner']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {
                $(".loader").show();
                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: delete_url + employee,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.msg = "Banner deleted successfully!" && data.statuscode == 200) {
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 1700);
                            setTimeout(function () {
                                location.reload();
                            }, 1700);
                        }
                    });
                    $(".loader").hide();
                } else {
                    // swal("Banner Not Deleted");
                    $(".loader").hide();
                }

            });
        });

        $(document).on('click', '.data-checked', function () {
            document.getElementById('deleteBannerButton').disabled = $('.data-checked:checked').length > 0 ? false : true;
            document.getElementById('select-all').checked = ($('.data-checked:checked').length == $('.data-checked').length) ? true : false;
        });

        function updateDataTableSelectAllCtrl(table) {
            var $table = table.table().node();
            var $chkbox_all = $('tbody input[type="checkbox"]', $table);
            var $chkbox_checked = $('tbody input[type="checkbox"]:checked', $table);
            var chkbox_select_all = $('thead input[name="select_all"]', $table).get(0);

            // If none of the checkboxes are checked
            if ($chkbox_checked.length === 0) {
                chkbox_select_all.checked = false;
                if (chkbox_select_all) {
                    chkbox_select_all = false;
                }
                // If all of the checkboxes are checked
            } else if ($chkbox_checked.length === $chkbox_all.length) {
                chkbox_select_all.checked = true;
                if (chkbox_select_all) {
                    chkbox_select_all.indeterminate = false;
                }
                // If some of the checkboxes are checked
            } else {
                chkbox_select_all.checked = false;
            }
        }

        back_button = () => {

            window.location.href = getClientId == '' ? 'advertiser_campaigns.php?client_id=' + getClient_Id + '' :
                'advertiser_campaigns.php?clientid=' + getClientId + '';
        }
    </script>
    </script>
</body>

</html>