#!/bin/sh

# Environment variables with default values
DB_NAME=${CLICKHOUSE_DB:-dspclick}
DB_USER=${CLICKHOUSE_USER:-developer}
DB_PASSWORD=${CLICKHOUSE_PASSWORD:-password}
ROLE_NAME=${CLICKHOUSE_ROLE:-my_role}

# Wait for ClickHouse server to start
until curl -s http://localhost:8123/ping | grep -q 'Ok'; do
  echo "Waiting for ClickHouse server to be ready..."
  sleep 1
done

# Create database, user, and role using environment variables
clickhouse-client --query="CREATE DATABASE IF NOT EXISTS ${DB_NAME};"
clickhouse-client --query="CREATE USER IF NOT EXISTS ${DB_USER} IDENTIFIED WITH plaintext_password BY '${DB_PASSWORD}';"
clickhouse-client --query="GRANT ALL ON ${DB_NAME}.* TO ${DB_USER};"
clickhouse-client --query="CREATE ROLE IF NOT EXISTS ${ROLE_NAME};"
clickhouse-client --query="GRANT ALL ON ${DB_NAME}.* TO ${ROLE_NAME};"
clickhouse-client --query="GRANT ${ROLE_NAME} TO ${DB_USER};"

echo "Database, user, and role created."

