//
//  MPRewardedVideo.h
//
//  Copyright 2018-2021 Twitter, Inc.
//  Licensed under the MoPub SDK License Agreement
//  http://www.mopub.com/legal/sdk-license-agreement/
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <SDK_Lib/MPImpressionData.h>

@class MPReward;
@class MPRewardedVideoReward;
@class CLLocation;
@protocol MPRewardedVideoDelegate;

/**
 Notice:
 @c MPRewardedVideo is deprecated and will be removed in a future version. Use
 @c MPRewardedAds instead.

 @c MPRewardedVideo allows you to load and play rewarded video ads. All ad events are
 reported, with an ad unit ID, to the delegate allowing the application to respond to the events
 for the corresponding ad.
 */
DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo is deprecated. Please use MPRewardedAds instead.")
@interface MPRewardedVideo : NSObject

/**
 Sets the delegate that will be the receiver of rewarded video events for the given
 ad unit ID.
 @remark A weak reference to the delegate will be held.
 @deprecated This API is deprecated and will be removed in a future version.
 @param delegate Delegate that will recieve rewarded video events for the ad unit ID.
 @param adZoneId Ad unit ID
 */
+ (void)setDelegate:(id<MPRewardedVideoDelegate>)delegate forAdZoneId:(NSString *)adZoneId DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.setDelegate:forAdZoneId: is deprecated and will be removed in a future version. Use MPRewardedAds.setDelegate:forAdZoneId: instead.");

/**
 Removes the delegate as a receiver of rewarded video events for all available ad unit IDs.
 @deprecated This API is deprecated and will be removed in a future version.
 @param delegate Reference to the delegate to remove as a listener.
 */
+ (void)removeDelegate:(id<MPRewardedVideoDelegate>)delegate DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.removeDelegate: is deprecated and will be removed in a future version. Use MPRewardedAds.removeDelegate: instead.");

/**
 Removes the rewarded video delegate that is associated with the ad unit ID.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneId Ad unit ID of the delegate to remove.
 */
+ (void)removeDelegateForAdZoneID:(NSString *)adZoneId DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.removeDelegateForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAds.removeDelegateForAdZoneID: instead.");

/**
 Loads a rewarded video ad for the given ad unit ID.
 The mediation settings array should contain ad network specific objects for networks that may be loaded for the given ad unit ID.
 You should set the properties on these objects to determine how the underlying ad network should behave. You only need to supply
 objects for the networks you wish to configure. If you do not want your network to behave differently from its default behavior, do
 not pass in an mediation settings object for that network.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID that ads should be loaded from.
 @param mediationSettings An array of mediation settings objects that map to networks that may show ads for the ad unit ID. This array
 should only contain objects for networks you wish to configure. This can be nil.
 */
+ (void)loadRewardedVideoAdWithAdZoneID:(NSString *)adZoneID withMediationSettings:(NSArray *)mediationSettings DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.loadRewardedVideoAdWithAdZoneID:withMediationSettings: is deprecated and will be removed in a future version. Use MPRewardedAds.loadRewardedAdWithAdZoneID:withMediationSettings: instead.");

/**
 Loads a rewarded video ad for the given ad unit ID.
 The mediation settings array should contain ad network specific objects for networks that may be loaded for the given ad unit ID.
 You should set the properties on these objects to determine how the underlying ad network should behave. You only need to supply
 objects for the networks you wish to configure. If you do not want your network to behave differently from its default behavior, do
 not pass in an mediation settings object for that network.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID that ads should be loaded from.
 @param keywords A string representing a set of non-personally identifiable keywords that should be passed to the MoPub ad server to receive more relevant advertising.
 @param userDataKeywords A string representing a set of personally identifiable keywords that should be passed to the MoPub ad server to receive
 more relevant advertising.
 @param mediationSettings An array of mediation settings objects that map to networks that may show ads for the ad unit ID. This array
 should only contain objects for networks you wish to configure. This can be nil.
 Note: If a user is in General Data Protection Regulation (GDPR) region and MoPub doesn't obtain consent from the user, "keywords" will be sent to the server but "userDataKeywords" will be excluded.
 */
+ (void)loadRewardedVideoAdWithAdZoneID:(NSString *)adZoneID keywords:(NSString *)keywords userDataKeywords:(NSString *)userDataKeywords mediationSettings:(NSArray *)mediationSettings DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.loadRewardedVideoAdWithAdZoneID:keywords:userDataKeywords:mediationSettings: is deprecated and will be removed in a future version. Use MPRewardedAds.loadRewardedAdWithAdZoneID:keywords:userDataKeywords:mediationSettings: instead.");

/**
 Loads a rewarded video ad for the given ad unit ID.
 The mediation settings array should contain ad network specific objects for networks that may be loaded for the given ad unit ID.
 You should set the properties on these objects to determine how the underlying ad network should behave. You only need to supply
 objects for the networks you wish to configure. If you do not want your network to behave differently from its default behavior, do
 not pass in an mediation settings object for that network.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID that ads should be loaded from.
 @param keywords A string representing a set of non-personally identifiable keywords that should be passed to the MoPub ad server to receive more relevant advertising.
 @param userDataKeywords A string representing a set of personally identifiable keywords that should be passed to the MoPub ad server to receive
 more relevant advertising.
 @param location Latitude/Longitude that are passed to the MoPub ad server
 @param mediationSettings An array of mediation settings objects that map to networks that may show ads for the ad unit ID. This array
 should only contain objects for networks you wish to configure. This can be nil.
 Note: If a user is in General Data Protection Regulation (GDPR) region and MoPub doesn't obtain consent from the user, "keywords" will be sent to the server but "userDataKeywords" will be excluded.
 */
+ (void)loadRewardedVideoAdWithAdZoneID:(NSString *)adZoneID keywords:(NSString *)keywords userDataKeywords:(NSString *)userDataKeywords location:(CLLocation *)location mediationSettings:(NSArray *)mediationSettings DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.loadRewardedVideoAdWithAdZoneID:keywords:userDataKeywords:location:mediationSettings: is deprecated and will be removed in a future version. Use MPRewardedAds.loadRewardedAdWithAdZoneID:keywords:userDataKeywords:mediationSettings: instead.");

/**
 Loads a rewarded video ad for the given ad unit ID.
 The mediation settings array should contain ad network specific objects for networks that may be loaded for the given ad unit ID.
 You should set the properties on these objects to determine how the underlying ad network should behave. You only need to supply
 objects for the networks you wish to configure. If you do not want your network to behave differently from its default behavior, do
 not pass in an mediation settings object for that network.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID that ads should be loaded from.
 @param keywords A string representing a set of non-personally identifiable keywords that should be passed to the MoPub ad server to receive more relevant advertising.
 @param userDataKeywords A string representing a set of personally identifiable keywords that should be passed to the MoPub ad server to receive
 more relevant advertising.
 @param customerId This is the ID given to the user by the publisher to identify them in their app
 @param mediationSettings An array of mediation settings objects that map to networks that may show ads for the ad unit ID. This array
 should only contain objects for networks you wish to configure. This can be nil.
 Note: If a user is in General Data Protection Regulation (GDPR) region and MoPub doesn't obtain consent from the user, "keywords" will be sent to the server but "userDataKeywords" will be excluded.
 */
+ (void)loadRewardedVideoAdWithAdZoneID:(NSString *)adZoneID keywords:(NSString *)keywords userDataKeywords:(NSString *)userDataKeywords customerId:(NSString *)customerId mediationSettings:(NSArray *)mediationSettings DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.loadRewardedVideoAdWithAdZoneID:keywords:userDataKeywords:customerId:mediationSettings: is deprecated and will be removed in a future version. Use MPRewardedAds.loadRewardedAdWithAdZoneID:keywords:userDataKeywords:customerId:mediationSettings: instead.");

/**
 Loads a rewarded video ad for the given ad unit ID.
 The mediation settings array should contain ad network specific objects for networks that may be loaded for the given ad unit ID.
 You should set the properties on these objects to determine how the underlying ad network should behave. You only need to supply
 objects for the networks you wish to configure. If you do not want your network to behave differently from its default behavior, do
 not pass in an mediation settings object for that network.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID that ads should be loaded from.
 @param keywords A string representing a set of non-personally identifiable keywords that should be passed to the MoPub ad server to receive more relevant advertising.
 @param userDataKeywords A string representing a set of personally identifiable keywords that should be passed to the MoPub ad server to receive
 more relevant advertising.
 @param location Latitude/Longitude that are passed to the MoPub ad server
 @param customerId This is the ID given to the user by the publisher to identify them in their app
 @param mediationSettings An array of mediation settings objects that map to networks that may show ads for the ad unit ID. This array
 should only contain objects for networks you wish to configure. This can be nil.
 Note: If a user is in General Data Protection Regulation (GDPR) region and MoPub doesn't obtain consent from the user, "keywords" will be sent to the server but "userDataKeywords" will be excluded.
 */
+ (void)loadRewardedVideoAdWithAdZoneID:(NSString *)adZoneID keywords:(NSString *)keywords userDataKeywords:(NSString *)userDataKeywords location:(CLLocation *)location customerId:(NSString *)customerId mediationSettings:(NSArray *)mediationSettings DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.loadRewardedVideoAdWithAdZoneID:keywords:userDataKeywords:location:customerId:mediationSettings: is deprecated and will be removed in a future version. Use MPRewardedAds.loadRewardedAdWithAdZoneID:keywords:userDataKeywords:customerId:mediationSettings: instead.");

/**
 Loads a rewarded video ad for the given ad unit ID.
 The mediation settings array should contain ad network specific objects for networks that may be loaded for the given ad unit ID.
 You should set the properties on these objects to determine how the underlying ad network should behave. You only need to supply
 objects for the networks you wish to configure. If you do not want your network to behave differently from its default behavior, do
 not pass in an mediation settings object for that network.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID that ads should be loaded from.
 @param keywords A string representing a set of non-personally identifiable keywords that should be passed to the MoPub ad server to receive more relevant advertising.
 @param userDataKeywords A string representing a set of personally identifiable keywords that should be passed to the MoPub ad server to receive
 more relevant advertising.
 @param customerId This is the ID given to the user by the publisher to identify them in their app
 @param mediationSettings An array of mediation settings objects that map to networks that may show ads for the ad unit ID. This array
 should only contain objects for networks you wish to configure. This can be nil.
 @param localExtras An optional dictionary containing extra local data.
 Note: If a user is in General Data Protection Regulation (GDPR) region and MoPub doesn't obtain consent from the user, "keywords" will be sent to the server but "userDataKeywords" will be excluded.
 */
+ (void)loadRewardedVideoAdWithAdZoneID:(NSString *)adZoneID keywords:(NSString *)keywords userDataKeywords:(NSString *)userDataKeywords customerId:(NSString *)customerId mediationSettings:(NSArray *)mediationSettings localExtras:(NSDictionary *)localExtras DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.loadRewardedVideoAdWithAdZoneID:keywords:userDataKeywords:customerId:mediationSettings:localExtras: is deprecated and will be removed in a future version. Use MPRewardedAds.loadRewardedAdWithAdZoneID:keywords:userDataKeywords:customerId:mediationSettings:localExtras: instead.");

/**
 Loads a rewarded video ad for the given ad unit ID.
 The mediation settings array should contain ad network specific objects for networks that may be loaded for the given ad unit ID.
 You should set the properties on these objects to determine how the underlying ad network should behave. You only need to supply
 objects for the networks you wish to configure. If you do not want your network to behave differently from its default behavior, do
 not pass in an mediation settings object for that network.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID that ads should be loaded from.
 @param keywords A string representing a set of non-personally identifiable keywords that should be passed to the MoPub ad server to receive more relevant advertising.
 @param userDataKeywords A string representing a set of personally identifiable keywords that should be passed to the MoPub ad server to receive
 more relevant advertising.
 @param location Latitude/Longitude that are passed to the MoPub ad server
 @param customerId This is the ID given to the user by the publisher to identify them in their app
 @param mediationSettings An array of mediation settings objects that map to networks that may show ads for the ad unit ID. This array
 should only contain objects for networks you wish to configure. This can be nil.
 @param localExtras An optional dictionary containing extra local data.
 Note: If a user is in General Data Protection Regulation (GDPR) region and MoPub doesn't obtain consent from the user, "keywords" will be sent to the server but "userDataKeywords" will be excluded.
 */
+ (void)loadRewardedVideoAdWithAdZoneID:(NSString *)adZoneID keywords:(NSString *)keywords userDataKeywords:(NSString *)userDataKeywords location:(CLLocation *)location customerId:(NSString *)customerId mediationSettings:(NSArray *)mediationSettings localExtras:(NSDictionary *)localExtras DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.loadRewardedVideoAdWithAdZoneID:keywords:userDataKeywords:location:customerId:mediationSettings:localExtras: is deprecated and will be removed in a future version. Use MPRewardedAds.loadRewardedAdWithAdZoneID:keywords:userDataKeywords:customerId:mediationSettings:localExtras: instead.");

/**
 Returns whether or not an ad is available for the given ad unit ID.
 @param adZoneID The ad unit ID associated with the ad you want to retrieve the availability for.
 @deprecated This API is deprecated and will be removed in a future version.
 */
+ (BOOL)hasAdAvailableForAdZoneId:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.hasAdAvailableForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAds.hasAdAvailableForAdZoneID: instead.");

/**
 Returns an array of @c MPRewardedVideoReward that are available for the given ad unit ID.
 @deprecated This API is deprecated and will be removed in a future version.
 */
+ (NSArray *)availableRewardsForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.availableRewardsForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAds.availableRewardsForAdZoneID: instead.");

/**
 The currently selected reward that will be awarded to the user upon completion of the ad. By default,
 this corresponds to the first reward in `availableRewardsForAdUnitID:`.
 @deprecated This API is deprecated and will be removed in a future version.
 */
+ (MPRewardedVideoReward *)selectedRewardForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.selectedRewardForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAds.selectedRewardForAdZoneID: instead.");

/**
 Plays a rewarded video ad.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID associated with the video ad you wish to play.
 @param viewController The view controller that will present the rewarded video ad.
 @param reward A reward selected from `availableRewardsForAdUnitID:` to award the user upon successful completion of the ad.
 This value should not be `nil`.
 @warning **Important**: You should not attempt to play the rewarded video unless `+hasAdAvailableForAdUnitID:` indicates that an
 ad is available for playing or you have received the `[-rewardedVideoAdDidLoadForAdUnitID:]([MPRewardedVideoDelegate rewardedVideoAdDidLoadForAdUnitID:])`
 message.
 */
+ (void)presentRewardedVideoAdForAdZoneID:(NSString *)adZoneID fromViewController:(UIViewController *)viewController withReward:(MPRewardedVideoReward *)reward DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.presentRewardedVideoAdForAdZoneID:fromViewController:withReward: is deprecated and will be removed in a future version. Use MPRewardedAds.presentRewardedAdForAdZoneID:fromViewController:withReward: instead.");

/**
 Plays a rewarded video ad.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID associated with the video ad you wish to play.
 @param viewController The view controller that will present the rewarded video ad.
 @param reward A reward selected from `availableRewardsForAdUnitID:` to award the user upon successful completion of the ad.
 This value should not be `nil`.
 @param customData Optional custom data string to include in the server-to-server callback. If a server-to-server callback
 is not used, or if the ad unit is configured for local rewarding, this value will not be persisted.
 @warning **Important**: You should not attempt to play the rewarded video unless `+hasAdAvailableForAdUnitID:` indicates that an
 ad is available for playing or you have received the `[-rewardedVideoAdDidLoadForAdUnitID:]([MPRewardedVideoDelegate rewardedVideoAdDidLoadForAdUnitID:])`
 message.
 */
+ (void)presentRewardedVideoAdForAdZoneID:(NSString *)adZoneID fromViewController:(UIViewController *)viewController withReward:(MPRewardedVideoReward *)reward customData:(NSString *)customData DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideo.presentRewardedVideoAdForAdZoneID:fromViewController:withReward:customData: is deprecated and will be removed in a future version. Use MPRewardedAds.presentRewardedAdForAdZoneID:fromViewController:withReward:customData: instead.");

@end

@protocol MPRewardedVideoDelegate <NSObject>

@optional

/**
 This method is called after an ad loads successfully.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 */
- (void)rewardedVideoAdDidLoadForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdDidLoadForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdDidLoadForAdZoneID: instead.");

/**
 This method is called after an ad fails to load.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 @param error An error indicating why the ad failed to load.
 */
- (void)rewardedVideoAdDidFailToLoadForAdZoneID:(NSString *)adZoneID error:(NSError *)error DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdDidFailToLoadForAdZoneID:error: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdDidFailToLoadForAdZoneID:error: instead.");

/**
 This method is called when a previously loaded rewarded video is no longer eligible for presentation.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 */
- (void)rewardedVideoAdDidExpireForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdDidExpireForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdDidExpireForAdZoneID: instead.");

/**
 This method is called when an attempt to play a rewarded video fails.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 @param error An error describing why the video couldn't play.
 */
- (void)rewardedVideoAdDidFailToPlayForAdZoneID:(NSString *)adZoneID error:(NSError *)error DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdDidFailToPlayForAdZoneID:error: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdDidFailToShowForAdZoneID:error: instead.");

/**
 This method is called when a rewarded video ad is about to appear.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 */
- (void)rewardedVideoAdWillAppearForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdWillAppearForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdWillPresentForAdZoneID: instead.");

/**
 This method is called when a rewarded video ad has appeared.
 Your implementation of this method should pause any application activity that requires user
 interaction.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 */
- (void)rewardedVideoAdDidAppearForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdDidAppearForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdDidPresentForAdZoneID: instead.");

/**
 This method is called when a rewarded video ad will be dismissed.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 */
- (void)rewardedVideoAdWillDisappearForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdWillDisappearForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdWillDismissForAdZoneID: instead.");

/**
 This method is called when a rewarded video ad has been dismissed.
 Your implementation of this method should resume any application activity that was paused
 prior to the interstitial being presented on-screen.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 */
- (void)rewardedVideoAdDidDisappearForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdDidDisappearForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdDidDismissForAdZoneID: instead.");

/**
 This method is called when the user taps on the ad.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 */
- (void)rewardedVideoAdDidReceiveTapEventForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdDidReceiveTapEventForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdDidReceiveTapEventForAdZoneID: instead.");

/**
 This method is called when a rewarded video ad will cause the user to leave the application.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 */
- (void)rewardedVideoAdWillLeaveApplicationForAdZoneID:(NSString *)adZoneID DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdWillLeaveApplicationForAdZoneID: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdWillLeaveApplicationForAdZoneID: instead.");

/**
 This method is called when the user should be rewarded for watching a rewarded video ad.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the ad associated with the event.
 @param reward The object that contains all the information regarding how much you should reward the user.
 */
- (void)rewardedVideoAdShouldRewardForAdZoneID:(NSString *)adZoneID reward:(MPRewardedVideoReward *)reward DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.rewardedVideoAdShouldRewardForAdZoneID:reward: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.rewardedAdShouldRewardForAdZoneID:reward: instead.");

/**
 Called when an impression is fired on a Rewarded Video. Includes information about the impression if applicable.
 @deprecated This API is deprecated and will be removed in a future version.
 @param adZoneID The ad unit ID of the rewarded video that fired the impression.
 @param impressionData Information about the impression, or @c nil if the server didn't return any information.
 */
- (void)didTrackImpressionWithAdZoneID:(NSString *)adZoneID impressionData:(MPImpressionData *)impressionData DEPRECATED_MSG_ATTRIBUTE("MPRewardedVideoDelegate.didTrackImpressionWithAdZoneID:impressionData: is deprecated and will be removed in a future version. Use MPRewardedAdsDelegate.didTrackImpressionWithAdZoneID:impressionData: instead.");

@end
