#import "MPGoogleAdMobRewardedVideoCustomEvent.h"
#import <GoogleMobileAds/GoogleMobileAds.h>
#import <SDK_Lib/MPReward.h>

@interface MPGoogleAdMobRewardedVideoCustomEvent () <GADFullScreenContentDelegate>
@property(nonatomic, copy) NSString *admobAdUnitId;
@property(nonatomic, strong) GADRewardedAd *rewardedAd;
@end

@implementation MPGoogleAdMobRewardedVideoCustomEvent
@dynamic delegate;
@dynamic localExtras;

- (void)initializeSdkWithParameters:(NSDictionary *)parameters {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
      [[GADMobileAds sharedInstance] startWithCompletionHandler:^(GADInitializationStatus *status){
        NSLog(@"Google Mobile Ads SDK initialized succesfully.");
      }];
    });
}

#pragma mark - MPFullscreenAdAdapter

- (BOOL)isRewardExpected {
    return YES;
}

- (BOOL)hasAdAvailable {
    return self.rewardedAd != nil;
}

-(void)requestRewardedVideoWithCustomEventInfo:(NSDictionary *)info {

    [self initializeSdkWithParameters:info];
    // Cache the network initialization parameters
   
    
    self.admobAdUnitId = [info objectForKey:@"Adunit"];
    if (self.admobAdUnitId == nil) {
       
        NSError *error = [NSError errorWithDomain:@"Admon banner" code:101 userInfo:[NSDictionary dictionaryWithObject:@"Ad Unit ID cannot be nil." forKey:NSLocalizedDescriptionKey]];
        [self.delegate rewardedVideoDidFailToPlayForCustomEvent:self error:error];

        
        return;
    }
    
    GADRequest *request = [GADRequest request];
    

    request.requestAgent = @"Mookomedia";

   

    
    [GADRewardedAd loadWithAdUnitID:self.admobAdUnitId
                            request:request
                  completionHandler:^(GADRewardedAd *ad, NSError *error) {
      if (error) {
         
          [self.delegate rewardedVideoDidFailToPlayForCustomEvent:self error:error];

        
          return;
      }
        
      self.rewardedAd = ad;
      self.rewardedAd.fullScreenContentDelegate = self;
        
     
        [self.delegate rewardedVideoDidLoadAdForCustomEvent:self];
        UIViewController *yourCurrentViewController = [UIApplication sharedApplication].keyWindow.rootViewController;
        [self presentAdFromViewController:yourCurrentViewController];
    }];
}

- (void)presentAdFromViewController:(UIViewController *)viewController {
   
    
    
    
    if (self.rewardedAd) {
        [self.rewardedAd presentFromRootViewController:viewController
                              userDidEarnRewardHandler:^ {
            GADAdReward *reward = self.rewardedAd.adReward;
            
            MPReward *moPubReward =
            [[MPReward alloc] initWithCurrencyType:reward.type amount:reward.amount];
            [self.delegate rewardedVideoShouldRewardUserForCustomEvent:self reward:moPubReward];
        }];
    } else {
        
        NSError *error = [NSError errorWithDomain:@"Admon banner" code:101 userInfo:[NSDictionary dictionaryWithObject:@"Rewarded ad is not ready to be presented." forKey:NSLocalizedDescriptionKey]];
        [self.delegate rewardedVideoDidFailToPlayForCustomEvent:self error:error];

    }
}

- (BOOL)enableAutomaticImpressionAndClickTracking {
    return NO;
}

// MoPub's API includes this method because it's technically possible for two MoPub adapters or
// adapters to wrap the same SDK and therefore both claim ownership of the same cached ad. The
// method will be called if 1) this adapter has already invoked
// fullscreenAdAdapter:self handleAdEvent:MPFullscreenAdEventDidLoad on the delegate, and 2) some other adapter plays a
// rewarded video ad. It's a way of forcing this adapter to double-check that its ad is
// definitely still available and is not the one that just played. If the ad is still available, no
// action is necessary. If it's not, this adapter should call
// fullscreenAdAdapter:self handleAdEvent:MPFullscreenAdEventDidExpire to let the MoPub SDK know that it's no longer ready to play
// and needs to load another ad. That event will be passed on to the publisher app, which can then
// trigger another load.
- (void)handleDidPlayAd {
    if (!self.rewardedAd) {
        [self.delegate rewardedVideoDidExpireForCustomEvent:self];

    }
}

#pragma mark - GADRewardedAdDelegate methods
- (void)adDidRecordImpression:(nonnull id<GADFullScreenPresentingAd>)ad {
    
}

- (void)adDidPresentFullScreenContent:(nonnull id<GADFullScreenPresentingAd>)ad {
    [self.delegate rewardedVideoWillAppearForCustomEvent:self];
    [self.delegate rewardedVideoDidAppearForCustomEvent:self];
}

- (void)ad:(nonnull id<GADFullScreenPresentingAd>)ad didFailToPresentFullScreenContentWithError:(NSError *)error {
    self.rewardedAd = nil;
    [self.delegate rewardedVideoDidFailToPlayForCustomEvent:self error:error];
   
}

- (void)adDidDismissFullScreenContent:(nonnull id<GADFullScreenPresentingAd>)ad {
    self.rewardedAd = nil;

    
    [self.delegate rewardedVideoWillDisappearForCustomEvent:self];
    [self.delegate rewardedVideoDidDisappearForCustomEvent:self];
}

- (NSString *) getAdNetworkId {
    return self.admobAdUnitId;
}


@end
