#import "MPGoogleAdMobNativeRenderer.h"

#if __has_include("MoPub.h")
#import "MPLogging.h"

#import "MPNativeAdError.h"

#import "MPNativeView.h"
#endif

#import <SDK_Lib/MPStaticNativeAdRendererSettings.h>
#import <SDK_Lib/MPNativeAdAdapter.h>
#import <SDK_Lib/MPNativeAdConstants.h>
#import <SDK_Lib/MPNativeAdRendererConfiguration.h>
#import <SDK_Lib/MPNativeAdRendererImageHandler.h>
#import <SDK_Lib/MPNativeAdRendering.h>
#import <SDK_Lib/MPNativeAdRenderingImageLoader.h>
#import "MPGoogleAdMobNativeAdAdapter.h"
#import "UIView+MPGoogleAdMobAdditions.h"

@interface MPGoogleAdMobNativeRenderer () <MPNativeAdRendererImageHandlerDelegate>

/// Publisher adView which is rendering.
@property(nonatomic, strong) UIView *adView;

/// MPGoogleAdMobNativeAdAdapter instance.
@property(nonatomic, strong) MPGoogleAdMobNativeAdAdapter *adapter;

/// YES if adView is in view hierarchy.
@property(nonatomic, assign) BOOL adViewInViewHierarchy;

/// MPNativeAdRendererImageHandler instance.
@property(nonatomic, strong) MPNativeAdRendererImageHandler *rendererImageHandler;

/// Class of renderingViewClass.
@property(nonatomic, strong) Class renderingViewClass;

/// GADUnifiedNativeAdView instance.
@property(nonatomic, strong) GADNativeAdView *unifiedNativeAdView;

@end

@implementation MPGoogleAdMobNativeRenderer

@synthesize viewSizeHandler;

/// Construct and return an MPNativeAdRendererConfiguration object, you must set all the properties
/// on the configuration object.
+ (NativeAdRendererConfiguration *)rendererConfigurationWithRendererSettings:
(id<MPNativeAdRendererSettings>)rendererSettings {
  MPNativeAdRendererConfiguration *config = [[MPNativeAdRendererConfiguration alloc] init];
  config.rendererClass = [self class];
  config.rendererSettings = rendererSettings;
  config.supportedCustomEvents = @[ @"MPGoogleAdMobNativeCustomEvent" ];
  return config;
}

/// Renderer settings are objects that allow you to expose configurable properties to the
/// application. MPGoogleAdMobNativeRenderer renderer will be initialized with these settings.
- (instancetype)initWithRendererSettings:(id<MPNativeAdRendererSettings>)rendererSettings {
  if (self = [super init]) {
//    StaticNativeAdRendererSettings *settings =
//        (StaticNativeAdRendererSettings *)rendererSettings;
      _rendererImageHandler = [MPNativeAdRendererImageHandler new];
    _rendererImageHandler.delegate = self;
  }

  return self;
}

/// Returns an ad view rendered using provided |adapter|. Sets an |error| if any error is
/// encountered.
- (UIView *)retrieveViewWithAdapter:(id<MPNativeAdAdapter>)adapter error:(NSError **)error {
  if (!adapter || ![adapter isKindOfClass:[MPGoogleAdMobNativeAdAdapter class]]) {
    if (error) {
    }

    return nil;
  }

  self.adapter = (MPGoogleAdMobNativeAdAdapter *)adapter;
  self.unifiedNativeAdView = self.adapter.adMobUnifiedNativeAdView;
  self.unifiedNativeAdView.autoresizingMask = UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleWidth;

  [self renderUnifiedAdViewWithAdapter:self.adapter];
  return self.unifiedNativeAdView;
}

/// Creates Unified Native AdView with adapter. We added GADUnifiedNativeAdView assets on
/// top of MoPub's adView, to track impressions & clicks.
- (void)renderUnifiedAdViewWithAdapter:(id<MPNativeAdAdapter>)adapter {
  // We only load text here. We're creating the GADUnifiedNativeAdView and preparing text
  // assets.
  if ([self.renderingViewClass respondsToSelector:@selector(nibForAd)]) {
      self.adView = (UIView<MPNativeAdRendering> *)[[[self.renderingViewClass nibForAd]
        instantiateWithOwner:nil
                     options:nil] firstObject];
  } else {
    self.adView = [[self.renderingViewClass alloc] init];
  }

  self.adView.autoresizingMask = UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleWidth;

  [self.unifiedNativeAdView addSubview:self.adView];
  [self.adView gad_fillSuperview];

}

/// Checks whether the ad view contains media.
- (BOOL)shouldLoadMediaView {
  return [self.adapter respondsToSelector:@selector(mainMediaView)] &&
         [self.adapter mainMediaView] &&
         [self.adView respondsToSelector:@selector(nativeVideoView)];
}

/// Check the ad view is superView or not, if not adView will move to superView.
- (void)adViewWillMoveToSuperview:(UIView *)superview {
  self.adViewInViewHierarchy = (superview != nil);

  if (superview) {
    // We'll start asychronously loading the native ad images now.
    if (self.adapter.properties[kAdIconImageKey] &&
        [self.adView respondsToSelector:@selector(nativeIconImageView)]) {

    }

    // Lay out custom assets here as the custom assets may contain images that need to be loaded.
    if ([self.adView respondsToSelector:@selector(layoutCustomAssetsWithProperties:imageLoader:)]) {
      // Create a simplified image loader for the ad view to use.
//        MPNativeAdRenderingImageLoader *imageLoader =
//        [[MPNativeAdRenderingImageLoader alloc] initWithImageHandler:self.rendererImageHandler];
//        NSString *get = imageLoader.description;
//        NSLog(@"%@",get);
    }
  }
}

#pragma mark - MPNativeAdRendererImageHandlerDelegate

- (BOOL)nativeAdViewInViewHierarchy {
  return self.adViewInViewHierarchy;
}

@end

