#if __has_include(<MoPub/MoPub.h>)
#import <MoPub/MoPub.h>
#elif __has_include(<MoPubSDKFramework/MoPub.h>)
#import <MoPubSDKFramework/MoPub.h>
#else
#import <SDK_Lib/MPNativeAdRenderer.h>
#import <SDK_Lib/MPNativeAdRendererSettings.h>
#endif

@class NativeAdRendererConfiguration;
@class StaticNativeAdRendererSettings;

@interface MPGoogleAdMobNativeRenderer : NSObject <MPNativeAdRendererSettings>

/// The viewSizeHandler is used to allow the app to configure its native ad view size.
@property(nonatomic, readwrite, copy) MPNativeViewSizeHandler viewSizeHandler;

/// Constructs and returns an MPNativeAdRendererConfiguration object specific for the
/// MPGoogleAdMobNativeRenderer. You must set all the properties on the configuration object.
/// @param rendererSettings Application defined settings.
/// @return A configuration object for MPGoogleAdMobNativeRenderer.
+ (NativeAdRendererConfiguration *)rendererConfigurationWithRendererSettings:
(id<MPNativeAdRendererSettings>)rendererSettings;

@end
