#import "MPGoogleAdMobNativeCustomEvent.h"
#import "MPGoogleAdMobNativeAdAdapter.h"
#if __has_include("MoPub.h")
#import "MPLogging.h"
//#import "lpNativeAd.h"
#import "MPNativeAdConstants.h"
#import "MPNativeAdError.h"
#import "MPNativeAdUtils.h"
#endif
#import <SDK_Lib/MPNativeAd.h>
#import <SDK_Lib/MPNativeAdConstants.h>
#import "AppDelegate.h"

/// Holds the preferred location of the AdChoices icon.
static GADAdChoicesPosition adChoicesPosition;

@interface MPGoogleAdMobNativeCustomEvent () <GADAdLoaderDelegate, GADNativeAdLoaderDelegate>

/// GADAdLoader instance.
@property(nonatomic, strong) GADAdLoader *adLoader;
@property(nonatomic, copy) NSString *admobAdUnitId;

@end

@implementation MPGoogleAdMobNativeCustomEvent

+ (void)setAdChoicesPosition:(GADAdChoicesPosition)position {
  // Since this adapter only supports one position for all instances of native ads, publishers might
  // access this class method in multiple threads and try to set the position for various native
  // ads, so its better to use synchronized block to make "adChoicesPosition" variable thread safe.
  @synchronized([self class]) {
    adChoicesPosition = position;
  }
}

- (void)requestAdWithCustomEventInfo:(NSDictionary *)info {
  static dispatch_once_t onceToken;
  dispatch_once(&onceToken, ^{
    [[GADMobileAds sharedInstance] startWithCompletionHandler:^(GADInitializationStatus *status){
    }];
  });
  
  self.admobAdUnitId = info[@"Adunit"];
    
    self.admobAdUnitId = [info objectForKey:@"Adunit"];
//      self.admobAdUnitId = @"ca-app-pub-3940256099942544/2934735716";
    
  if (self.admobAdUnitId == nil) {

    return;
  }

//    UIWindow *window = [UIApplication sharedApplication].keyWindow;
//    UIViewController *rootViewController = window.rootViewController;
//    while (rootViewController.presentedViewController) {
//      rootViewController = rootViewController.presentedViewController;
//    }
    
  GADRequest *request = [GADRequest request];
  request.requestAgent = @"Digiads";
    
//  request.testDevices = @[kGADSimulatorID];

  GADNativeAdImageAdLoaderOptions *nativeAdImageLoaderOptions =
      [[GADNativeAdImageAdLoaderOptions alloc] init];
  nativeAdImageLoaderOptions.shouldRequestMultipleImages = NO;
//  nativeAdImageLoaderOptions.preferredImageOrientation =
//      GADNativeAdImageAdLoaderOptionsOrientationAny;
    
//    GADNativeAdImageAdLoaderOptionsOrientationAny;
    
  // In GADNativeAdViewAdOptions, the default preferredAdChoicesPosition is
  // GADAdChoicesPositionTopRightCorner.
  GADNativeAdViewAdOptions *nativeAdViewAdOptions = [[GADNativeAdViewAdOptions alloc] init];
  nativeAdViewAdOptions.preferredAdChoicesPosition = adChoicesPosition;
    
    UIWindow* window = nil;
      if (@available(iOS 13.0, *))
      {
          for (UIWindowScene* wScene in [UIApplication sharedApplication].connectedScenes)
          {
              if (wScene.activationState == UISceneActivationStateForegroundActive)
              {
                  window = wScene.windows.firstObject;
                  UIViewController *yourCurrentViewController = [UIApplication sharedApplication].windows.firstObject.rootViewController;

                  self.adLoader =
                      [[GADAdLoader alloc] initWithAdUnitID:self.admobAdUnitId
                                         rootViewController:yourCurrentViewController
                                                    adTypes:@[ kGADAdLoaderAdTypeNative ]
                                                    options:@[ nativeAdImageLoaderOptions, nativeAdViewAdOptions ]];
                  break;
              }
          }
      }
 
  self.adLoader.delegate = self;

  // Consent collected from the MoPub’s consent dialogue should not be used to set up
  // Google's personalization preference. Publishers should work with Google to be GDPR-compliant.

    NSString *npaValue = @"1";

    if (npaValue.length > 0) {
    GADExtras *extras = [[GADExtras alloc] init];
    extras.additionalParameters = @{@"npa": npaValue};
    [request registerAdNetworkExtras:extras];
  }
    
  [self.adLoader loadRequest:request];
}

#pragma mark GADAdLoaderDelegate implementation
-(void)adLoader:(GADAdLoader *)adLoader didFailToReceiveAdWithError:(NSError *)error
//- (void)adLoader:(GADAdLoader *)adLoader didFailToReceiveAdWithError:(GADRequestError *)error
    {
  [self.delegate nativeCustomEvent:self didFailToLoadAdWithError:error];
}

#pragma mark GADUnifiedNativeAdLoaderDelegate implementation

- (void)adLoader:(nonnull GADAdLoader *)adLoader
    didReceiveUnifiedNativeAd:(nonnull GADNativeAd *)nativeAd {
  if (![self isValidUnifiedNativeAd:nativeAd]) {
    return;
  }

  GADNativeAdView *gadUnifiedNativeAdView = [[GADNativeAdView alloc] init];

  GADAdChoicesView *adChoicesView = [[GADAdChoicesView alloc] initWithFrame:CGRectZero];
  adChoicesView.userInteractionEnabled = NO;
  [gadUnifiedNativeAdView addSubview:adChoicesView];
  gadUnifiedNativeAdView.adChoicesView = adChoicesView;

  GADMediaView *mediaView = [[GADMediaView alloc] initWithFrame:CGRectZero];
  [gadUnifiedNativeAdView addSubview:mediaView];
  gadUnifiedNativeAdView.mediaView = mediaView;

  gadUnifiedNativeAdView.nativeAd = nativeAd;

  UILabel *headlineView = [[UILabel alloc] initWithFrame:CGRectZero];
  headlineView.text = nativeAd.headline;
  headlineView.textColor = [UIColor clearColor];
  [gadUnifiedNativeAdView addSubview:headlineView];
  gadUnifiedNativeAdView.headlineView = headlineView;

  UILabel *bodyView = [[UILabel alloc] initWithFrame:CGRectZero];
  bodyView.text = nativeAd.body;
  bodyView.textColor = [UIColor clearColor];
  [gadUnifiedNativeAdView addSubview:bodyView];
  gadUnifiedNativeAdView.bodyView = bodyView;

  UILabel *callToActionView = [[UILabel alloc] initWithFrame:CGRectZero];
  callToActionView.text = nativeAd.callToAction;
  callToActionView.textColor = [UIColor clearColor];
  [gadUnifiedNativeAdView addSubview:callToActionView];
  gadUnifiedNativeAdView.callToActionView = callToActionView;

  UIImageView *mainMediaImageView = [[UIImageView alloc] initWithFrame:CGRectZero];
  mainMediaImageView.image = nativeAd.images.firstObject.image;

  [gadUnifiedNativeAdView addSubview:mainMediaImageView];
  gadUnifiedNativeAdView.imageView = mainMediaImageView;

  UIImageView *iconView = [[UIImageView alloc] initWithFrame:CGRectZero];
  iconView.image = nativeAd.icon.image;
  [gadUnifiedNativeAdView addSubview:iconView];
  gadUnifiedNativeAdView.iconView = iconView;

  MPGoogleAdMobNativeAdAdapter *adapter =
      [[MPGoogleAdMobNativeAdAdapter alloc] initWithAdMobUnifiedNativeAd:nativeAd
                                                     unifiedNativeAdView:gadUnifiedNativeAdView];
    MPNativeAd *moPubNativeAd = [[MPNativeAd alloc] initWithAdAdapter:adapter];

  NSMutableArray *imageURLs = [NSMutableArray array];

  [super precacheImagesWithURLs:imageURLs
                completionBlock:^(NSArray *errors) {
                  if (errors) {

                  } else {
                    [self.delegate nativeCustomEvent:self didLoadAd:moPubNativeAd];
                  }
                }];
}

#pragma mark - Private Methods

/// Checks the unified native ad has required assets or not.
- (BOOL)isValidUnifiedNativeAd:(GADNativeAd *)unifiedNativeAd {
  return (unifiedNativeAd.headline && unifiedNativeAd.body && unifiedNativeAd.icon &&
          unifiedNativeAd.images.count && unifiedNativeAd.callToAction);
}

- (void)adLoader:(nonnull GADAdLoader *)adLoader didReceiveNativeAd:(nonnull GADNativeAd *)nativeAd {
    NSLog(@"%@",nativeAd);
    if (![self isValidUnifiedNativeAd:nativeAd]) {
          return;
        }
    
        GADNativeAdView *gadUnifiedNativeAdView = [[GADNativeAdView alloc] init];
    
        GADAdChoicesView *adChoicesView = [[GADAdChoicesView alloc] initWithFrame:CGRectZero];
        adChoicesView.userInteractionEnabled = NO;
        [gadUnifiedNativeAdView addSubview:adChoicesView];
        gadUnifiedNativeAdView.adChoicesView = adChoicesView;
    
        GADMediaView *mediaView = [[GADMediaView alloc] initWithFrame:CGRectZero];
        [gadUnifiedNativeAdView addSubview:mediaView];
        gadUnifiedNativeAdView.mediaView = mediaView;
    
        gadUnifiedNativeAdView.nativeAd = nativeAd;
    
        UILabel *headlineView = [[UILabel alloc] initWithFrame:CGRectZero];
        headlineView.text = nativeAd.headline;
        headlineView.textColor = [UIColor clearColor];
        [gadUnifiedNativeAdView addSubview:headlineView];
        gadUnifiedNativeAdView.headlineView = headlineView;
    
        UILabel *bodyView = [[UILabel alloc] initWithFrame:CGRectZero];
        bodyView.text = nativeAd.body;
        bodyView.textColor = [UIColor clearColor];
        [gadUnifiedNativeAdView addSubview:bodyView];
        gadUnifiedNativeAdView.bodyView = bodyView;
    
        UILabel *callToActionView = [[UILabel alloc] initWithFrame:CGRectZero];
        callToActionView.text = nativeAd.callToAction;
        callToActionView.textColor = [UIColor clearColor];
        [gadUnifiedNativeAdView addSubview:callToActionView];
        gadUnifiedNativeAdView.callToActionView = callToActionView;
    
        UIImageView *mainMediaImageView = [[UIImageView alloc] initWithFrame:CGRectZero];
        mainMediaImageView.image = nativeAd.images.firstObject.image;
    
        [gadUnifiedNativeAdView addSubview:mainMediaImageView];
        gadUnifiedNativeAdView.imageView = mainMediaImageView;
    
        UIImageView *iconView = [[UIImageView alloc] initWithFrame:CGRectZero];
        iconView.image = nativeAd.icon.image;
        [gadUnifiedNativeAdView addSubview:iconView];
        gadUnifiedNativeAdView.iconView = iconView;
    
        MPGoogleAdMobNativeAdAdapter *adapter =
            [[MPGoogleAdMobNativeAdAdapter alloc] initWithAdMobUnifiedNativeAd:nativeAd
                                                           unifiedNativeAdView:gadUnifiedNativeAdView];
          MPNativeAd *moPubNativeAd = [[MPNativeAd alloc] initWithAdAdapter:adapter];
    
        NSMutableArray *imageURLs = [NSMutableArray array];
    
        [super precacheImagesWithURLs:imageURLs
                      completionBlock:^(NSArray *errors) {
                        if (errors) {
    
                        } else {
                          [self.delegate nativeCustomEvent:self didLoadAd:moPubNativeAd];
                        }
                      }];
}

@end

