#import "MPGoogleAdMobNativeAdAdapter.h"

#if __has_include("MoPub.h")
#import "MPLogging.h"
#import "MPNativeAdConstants.h"
#import "MPNativeAdError.h"
#endif
#import <SDK_Lib/MPNativeAdConstants.h>

static NSString *const kGADMAdvertiserKey = @"advertiser";
static NSString *const kGADMPriceKey = @"price";
static NSString *const kGADMStoreKey = @"store";

@implementation MPGoogleAdMobNativeAdAdapter

@synthesize properties = _properties;

//- (instancetype)initWithAdMobUnifiedNativeAd:(GADUnifiedNativeAd *)adMobUnifiedNativeAd
//                         unifiedNativeAdView:(GADUnifiedNativeAdView *)adMobUnifiedNativeAdView {
    - (instancetype)initWithAdMobUnifiedNativeAd:(GADNativeAd *)adMobUnifiedNativeAd
                             unifiedNativeAdView:(GADNativeAdView *)adMobUnifiedNativeAdView {
  if (self = [super init]) {
    self.adMobUnifiedNativeAd = adMobUnifiedNativeAd;
    self.adMobUnifiedNativeAd.delegate = self;
    self.adMobUnifiedNativeAdView = adMobUnifiedNativeAdView;

    NSMutableDictionary *properties = [NSMutableDictionary dictionary];
    if (adMobUnifiedNativeAd.headline) {
      properties[kAdTitleKey] = adMobUnifiedNativeAd.headline;
    }

    if ([adMobUnifiedNativeAd.icon.imageURL absoluteString]) {
      properties[kAdIconImageKey] = adMobUnifiedNativeAd.icon.imageURL.absoluteString;
    }

    if (adMobUnifiedNativeAd.body) {
      properties[kAdTextKey] = adMobUnifiedNativeAd.body;
    }

    if (adMobUnifiedNativeAd.starRating) {
      properties[kAdStarRatingKey] = adMobUnifiedNativeAd.starRating;
    }

    if (adMobUnifiedNativeAd.callToAction) {
      properties[kAdCTATextKey] = adMobUnifiedNativeAd.callToAction;
    }

    if (adMobUnifiedNativeAd.price) {
      properties[kGADMPriceKey] = adMobUnifiedNativeAd.price;
    }

    if (adMobUnifiedNativeAd.store) {
      properties[kGADMStoreKey] = adMobUnifiedNativeAd.store;
    }

    _properties = properties;
  }

  return self;
}

#pragma mark - <GADUnifiedNativeAdDelegate>

//- (void)nativeAdDidRecordImpression:(GADUnifiedNativeAd *)nativeAd {
    - (void)nativeAdDidRecordImpression:(GADNativeAd *)nativeAd {

  [self.delegate nativeAdWillLogImpression:self];
}

//- (void)nativeAdDidRecordClick:(GADUnifiedNativeAd *)nativeAd {
    - (void)nativeAdDidRecordClick:(GADNativeAd *)nativeAd {
  // Sending click to MoPub SDK.
  [self.delegate nativeAdDidClick:self];
}

#pragma mark - <MPNativxeAdAdapter>

- (UIView *)privacyInformationIconView {
  return self.adMobUnifiedNativeAdView.adChoicesView;
}

- (UIView *)mainMediaView {
  return self.adMobUnifiedNativeAdView.mediaView;
}

- (NSURL *)defaultActionURL {
  return nil;
}

- (BOOL)enableThirdPartyClickTracking {
  return YES;
}

@end

