//
//  MPGoogleAdMobInterstitialCustomEvent.m
//  MoPub
//
//  Copyright (c) 2012 MoPub, Inc. All rights reserved.
//

#import "MPGoogleAdMobInterstitialCustomEvent.h"
#import <GoogleMobileAds/GoogleMobileAds.h>

#import <CoreLocation/CoreLocation.h>

@interface MPGoogleAdMobInterstitialCustomEvent () <GADFullScreenContentDelegate>

@property(nonatomic, strong) GADInterstitialAd *interstitial;
@property(nonatomic, copy) NSString *admobAdUnitId;

@end

@implementation MPGoogleAdMobInterstitialCustomEvent
@dynamic delegate;
@dynamic localExtras;

@synthesize interstitial = _interstitial;

- (void)dealloc {
    self.interstitial.fullScreenContentDelegate = nil;
}

#pragma mark - MPFullscreenAdAdapter Override

- (BOOL)isRewardExpected {
    return NO;
}

- (BOOL)hasAdAvailable {
    return self.interstitial != nil;
}

- (void)requestInterstitialWithCustomEventInfo:(NSDictionary *)info {
    self.admobAdUnitId = [info objectForKey:@"Adunit"];
    GADRequest *request = [GADRequest request];
    request.requestAgent = @"Mookomedia";
    
    [GADInterstitialAd loadWithAdUnitID:self.admobAdUnitId
                                request:request
                      completionHandler:^(GADInterstitialAd *ad, NSError *error) {
      if (error) {
      
          [self.delegate interstitialCustomEvent:self didFailToLoadAdWithError:error];


        return;
      }

      self.interstitial = ad;
      self.interstitial.fullScreenContentDelegate = self;
        [self.delegate interstitialCustomEvent:self didLoadAd:self.interstitial];
        if (self.interstitial) {
           
            
            UIViewController *yourCurrentViewController = [UIApplication sharedApplication].keyWindow.rootViewController;
            
            [self.interstitial presentFromRootViewController:yourCurrentViewController];
            
        } else {
          
            NSError *error = [NSError errorWithDomain:@"Admon banner" code:101 userInfo:[NSDictionary dictionaryWithObject:@"Failed to show Google interstitial. An ad wasn't ready" forKey:NSLocalizedDescriptionKey]];
            [self.delegate interstitialCustomEvent:self didFailToLoadAdWithError:error];

        }
     // [self.delegate fullscreenAdAdapterDidLoadAd:self];
    }];
}

- (void)showInterstitialFromRootViewController:(UIViewController *)viewController {
    if (self.interstitial) {
        [self.interstitial presentFromRootViewController:viewController];
        
        UIViewController *yourCurrentViewController = [UIApplication sharedApplication].keyWindow.rootViewController;
        
        [self.interstitial presentFromRootViewController:yourCurrentViewController];
        
    } else {
      
        NSError *error = [NSError errorWithDomain:@"Admon banner" code:101 userInfo:[NSDictionary dictionaryWithObject:@"Failed to show Google interstitial. An ad wasn't ready" forKey:NSLocalizedDescriptionKey]];
        [self.delegate interstitialCustomEvent:self didFailToLoadAdWithError:error];

    }
}

- (BOOL)enableAutomaticImpressionAndClickTracking {
    return NO;
}

#pragma mark - GADFullScreenContentDelegate
- (void)adDidRecordImpression:(nonnull id<GADFullScreenPresentingAd>)ad {
    [self.delegate interstitialCustomEventWillAppear:self];

}

- (void)adDidPresentFullScreenContent:(nonnull id<GADFullScreenPresentingAd>)ad {
    [self.delegate interstitialCustomEventDidAppear:self];
}

- (void)ad:(nonnull id<GADFullScreenPresentingAd>)ad didFailToPresentFullScreenContentWithError:(NSError *)error {
    self.interstitial = nil;

    NSString *failureReason = [NSString stringWithFormat: @"Google interstitial failed to show with error: %@", error.localizedDescription];
    NSError *errorfull = [NSError errorWithDomain:@"Admon banner" code:101 userInfo:[NSDictionary dictionaryWithObject:failureReason forKey:NSLocalizedDescriptionKey]];
    [self.delegate interstitialCustomEvent:self didFailToLoadAdWithError:errorfull];
}

- (void)adDidDismissFullScreenContent:(nonnull id<GADFullScreenPresentingAd>)ad {
    self.interstitial = nil;
   
}

- (NSString *) getAdNetworkId {
    return self.admobAdUnitId;
}


@end
