//
//  MPGoogleAdMobBannerCustomEvent.m
//  MoPub
//
//  Copyright (c) 2013 MoPub. All rights reserved.
//

#import "MPGoogleAdMobBannerCustomEvent.h"
#import <CoreLocation/CoreLocation.h>
#import <GoogleMobileAds/GoogleMobileAds.h>

@interface MPGoogleAdMobBannerCustomEvent () <GADBannerViewDelegate>

@property(nonatomic, strong) GADBannerView *adBannerView;
@property(nonatomic) CGSize adSize;

@end

@implementation MPGoogleAdMobBannerCustomEvent

@dynamic delegate;
@dynamic localExtras;

- (id)init {
  self = [super init];
  if (self) {
    self.adBannerView = [[GADBannerView alloc] initWithFrame:CGRectZero];
    self.adBannerView.delegate = self;
  }
  return self;
}

- (BOOL)enableAutomaticImpressionAndClickTracking {
    return NO;
}

- (void)dealloc {
  self.adBannerView.delegate = nil;
}

- (void)requestAdWithSize:(CGSize)size customEventInfo:(NSDictionary *)info {
    [self requestAdWithSize:size customEventInfo:info adMarkup:nil];
}
- (void)requestAdWithSize:(CGSize)size customEventInfo:(NSDictionary *)info adMarkup:(NSString *)adMarkup {
  self.adSize = size;
    
  if (self.adSize.width <= 0.0 || self.adSize.height <= 0.0) {
    NSString *failureReason = @"Google AdMob banner failed to load due to invalid ad width and/or height.";
      NSError *error = [NSError errorWithDomain:@"Admon banner" code:101 userInfo:[NSDictionary dictionaryWithObject:failureReason forKey:NSLocalizedDescriptionKey]];
      [self.delegate bannerCustomEvent:self didFailToLoadAdWithError:error];
    return;
  }
    
  self.adBannerView.frame = (CGRect){CGPointZero, self.adSize};
    self.adBannerView.adUnitID = [info objectForKey:@"Adunit"];
    NSLog(@"adunit id %@",[info objectForKey:@"Adunit"]);
    self.adBannerView.rootViewController = (id)self;
  GADRequest *request = [GADRequest request];
  request.requestAgent = @"Mookomedia";    
  // Cache the network initialization parameters
 
  [self.adBannerView loadRequest:request];
}

#pragma mark GADBannerViewDelegate methods

- (void)bannerViewDidReceiveAd:(GADBannerView *)bannerView {
  CGFloat receivedWidth = bannerView.adSize.size.width;
  CGFloat receivedHeight = bannerView.adSize.size.height;
    
  if (receivedWidth > self.adSize.width || receivedHeight > self.adSize.height) {
    NSString *failureReason = [NSString stringWithFormat:@"Google served an ad but it was invalidated because its size of %.0f x %.0f exceeds the publisher-specified size of %.0f x %.0f", receivedWidth, receivedHeight, self.adSize.width, self.adSize.height];
      NSError *error = [NSError errorWithDomain:@"Admon banner" code:101 userInfo:[NSDictionary dictionaryWithObject:failureReason forKey:NSLocalizedDescriptionKey]];

  
    [self.delegate bannerCustomEvent:self didFailToLoadAdWithError:error];
  } else {
   
          
    [self.delegate bannerCustomEvent:self didLoadAd:self.adBannerView];
  }
}

- (void)bannerViewDidRecordImpression:(GADBannerView *)bannerView {
   

}

- (void)bannerView:(GADBannerView *)bannerView didFailToReceiveAdWithError:(NSError *)error {

  NSString *failureReason = [NSString stringWithFormat: @"Google AdMob Banner failed to load with error: %@", [error localizedDescription]];
    NSError *error1 = [NSError errorWithDomain:@"Admon banner" code:101 userInfo:[NSDictionary dictionaryWithObject:failureReason forKey:NSLocalizedDescriptionKey]];

    [self.delegate bannerCustomEvent:self didFailToLoadAdWithError:error1];
}

- (void)bannerViewWillPresentScreen:(GADBannerView *)bannerView {
    [self.delegate bannerCustomEventWillBeginAction:self];
}

- (void)bannerViewDidDismissScreen:(GADBannerView *)bannerView {
    [self.delegate bannerCustomEventDidFinishAction:self];
}
- (void)bannerViewWillDismissScreen:(GADBannerView *)bannerView {
    [self.delegate bannerCustomEventWillLeaveApplication:self];

}

- (NSString *) getAdNetworkId {
    return (self.adBannerView) ? self.adBannerView.adUnitID : @"";
}

@end
