//
//  MPNativeAdPlacerTableViewController.m
//
//  Copyright 2018 Twitter, Inc.
//  Licensed under the  SDK License Agreement


#import "MPNativeAdPlacerTableViewController.h"
#import "YourNativeAdView.h"
#import <SDK_Lib/MPNativeAdRequestTargeting.h>
#import <SDK_Lib/MPTableViewAdPlacer.h>
#import <SDK_Lib/MPClientAdPositioning.h>
#import <SDK_Lib/MPNativeAdConstants.h>
#import <SDK_Lib/MPStaticNativeAdRendererSettings.h>
#import <SDK_Lib/MPStaticNativeAdRenderer.h>
#import <SDK_Lib/MPNativeAdRendererConfiguration.h>
#import <SDK_Lib/sdk_lib_new.h>

static NSString *kDefaultCellIdentifier = @"MPSampleAppTableViewAdPlacerCell";

@interface MPNativeAdPlacerTableViewController () <MPTableViewAdPlacerDelegate>

@property (nonatomic, strong) NSMutableArray *contentItems;
@property (nonatomic) MPTableViewAdPlacer *placer;

@end

@implementation MPNativeAdPlacerTableViewController

NSString *globalzonee;

-(id)init:(NSString *)zonevalue{
    globalzonee=zonevalue;
    if(self){
        
    }
    return self;
}

#pragma mark - Object Lifecycle

- (id)initWithAdInfo:(MPAdInfo *)info
{
    self = [super initWithStyle:UITableViewStylePlain];
    if (self) {
        self.title = @"Table View Ad Placer";
        //self.adInfo = info;
        self.contentItems = [NSMutableArray array];

        if ([self respondsToSelector:@selector(setEdgesForExtendedLayout:)]) {
            self.edgesForExtendedLayout = UIRectEdgeNone;
        }
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];

    if ([self.tableView respondsToSelector:@selector(registerClass:forCellReuseIdentifier:)]) {
        [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:kDefaultCellIdentifier];
    }

    [self setupContent];
    [self.tableView reloadData];
    [self initializeSDK];
}

- (void)setupContent
{
    self.contentItems = [NSMutableArray array];

    for (NSString *fontFamilyName in [UIFont familyNames]) {
        for (NSString *fontName in [UIFont fontNamesForFamilyName:fontFamilyName]) {
            [self.contentItems addObject:fontName];
        }
    }

    [self.contentItems sortUsingSelector:@selector(compare:)];
}
-(void)initializeSDK{
//    MPMoPubConfiguration *sdkConfig = [[MPMoPubConfiguration alloc] initWithAdZoneIdForAppInitialization:globalzonee];
//
//    sdkConfig.globalMediationSettings = @[];
//    sdkConfig.loggingLevel = MPBLogLevelInfo;
////    sdkConfig.allowLegitimateInterest = BOOL;
////    sdkConfig.additionalNetworks = @[NetworkAdapterConfiguration.class];
////    sdkConfig.mediatedNetworkConfigurations = NSMutableDictionary<NSString, NSDictionary<NSString, id>> of data to be passed to mediation adapters for initialization;
//
//    [[MoPub sharedInstance] initializeSdkWithConfiguration:sdkConfig completion:^{
//            NSLog(@"SDK initialization complete");
            // SDK initialization complete. Ready to make ad requests.
        [self setupad];

//    }];

}
-(void)setupad{
    dispatch_async(dispatch_get_main_queue(), ^{
        MPNativeAdRequestTargeting *targeting = [MPNativeAdRequestTargeting targeting];
        targeting.desiredAssets = [NSSet setWithObjects:kAdIconImageKey, kAdMainImageKey, kAdCTATextKey, kAdTextKey, kAdTitleKey, nil];
        
        MPStaticNativeAdRendererSettings *settings = [[MPStaticNativeAdRendererSettings alloc] init];
        settings.renderingViewClass = [YourNativeAdView class];
        settings.viewSizeHandler = ^(CGFloat maximumWidth) {
            return CGSizeMake(maximumWidth, 312.0f);
        };
        MPNativeAdRendererConfiguration *nativeAdConfig = [MPStaticNativeAdRenderer rendererConfigurationWithRendererSettings:settings];
        nativeAdConfig.supportedCustomEvents = @[@"MPMPNativeCustomEvent", @"FlurryNativeCustomEvent",@"MPGoogleAdMobNativeCustomEvent"];

        MPClientAdPositioning *positioning = [MPClientAdPositioning positioning];
        [positioning addFixedIndexPath:[NSIndexPath indexPathForRow:1 inSection:0]];
        [positioning enableRepeatingPositionsWithInterval:5];
//        MPNativeAdRendererConfiguration *config = [MPStaticNativeAdRenderer rendererConfigurationWithRendererSettings:settings];
        
        self.placer = [MPTableViewAdPlacer placerWithTableView:self.tableView
                                                viewController:self
                                                 adPositioning:positioning
                                        rendererConfigurations:@[nativeAdConfig]];
        
        self.placer.delegate = self;
        [self.placer loadAdsForAdZoneID:globalzonee];
    });
    [self.tableView reloadData];

}
//#pragma mark - Table view data source
//
//- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
//#warning Incomplete implementation, return the number of sections
//    return 0;
//}
//
//- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
//#warning Incomplete implementation, return the number of rows
//    return 0;
//}

/*
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:<#@"reuseIdentifier"#> forIndexPath:indexPath];
    
    // Configure the cell...
    
    return cell;
}
*/

/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/

/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
    } else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }
}
*/

/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}
*/

/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
#pragma mark - UITableViewDataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.contentItems count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    /*
     * IMPORTANT: add the mp_ prefix to dequeueReusableCellWithReuseIdentifier:forIndexPath:.
     */
//    UITableViewCell *cell = [tableView mp_dequeueReusableCellWithIdentifier:kDefaultCellIdentifier forIndexPath:indexPath];
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kDefaultCellIdentifier];
    
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:kDefaultCellIdentifier];
    }

    NSString *fontName = self.contentItems[indexPath.row];
    cell.textLabel.font = [UIFont fontWithName:fontName size:20.0];
    cell.textLabel.text = fontName;
    return cell;
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    /*
     * IMPORTANT: add the mp_ prefix to deselectRowAtIndexPath:animated:.
     */
    [tableView mp_deselectRowAtIndexPath:indexPath animated:YES];
}

- (void)nativeAdWillPresentModalForTableViewAdPlacer:(MPTableViewAdPlacer *)placer{
    NSLog(@"app nativeAdWillPresentModalForTableViewAdPlacer");

}

/*
 This method is called when a native ad, placed by the table view ad placer, did dismiss its modal view controller.

 @param placer The table view ad placer that contains the ad that dismissed the modal.
 */
- (void)nativeAdDidDismissModalForTableViewAdPlacer:(MPTableViewAdPlacer *)placer{
    NSLog(@"app nativeAdDidDismissModalForTableViewAdPlacer");

}

/*
 This method is called when a native ad, placed by the table view ad placer, will cause the app to background due to user interaction with the ad.

 @param placer The table view ad placer that contains the ad causing the app to background.
 */
- (void)nativeAdWillLeaveApplicationFromTableViewAdPlacer:(MPTableViewAdPlacer *)placer{
    NSLog(@"app nativeAdWillLeaveApplicationFromTableViewAdPlacer");
}
@end
