<?php
namespace MauticPlugin\MauticMyupcharSmsBundle\Model;

use Mautic\CoreBundle\Model\FormModel;
use MauticPlugin\MauticMyupcharSmsBundle\Model\MyupcharModel;
use MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupcharsms;
use MauticPlugin\MauticMyupcharSmsBundle\Entity\MyupcharsmsRepository;
use MauticPlugin\MauticMyupcharSmsBundle\MyupcharsmsEvents;
use MauticPlugin\MauticMupcharSmsBundle\Event\CallEvent;
use Symfony\Component\EventDispatcher\Event;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;
use Mautic\LeadBundle\Entity\Lead;
use Mautic\LeadBundle\Model\LeadModel;
use Mautic\LeadBundle\Entity\DoNotContact;
use Mautic\LeadBundle\Entity\DoNotContactRepository;

use Mautic\PluginBundle\Helper\IntegrationHelper;
use Mautic\CoreBundle\Helper\Chart\LineChart;
use Mautic\CoreBundle\Helper\Chart\ChartQuery;

/**
 * Class PinnaclesmsModel
 * {@inheritdoc}
 */
class MyupcharsmsModel extends FormModel
{

    /**
     * @var LeadModel
     */
    protected $LeadModel;
    protected $appid;
    protected $userid;
    protected $api_url;
    protected $sendername;
    protected $soundfile;

    /**
     * {@inheritdoc}
     *
     * @param       $entity
     * @param       $formFactory
     * @param null  $action
     * @param array $options
     *
     * @return mixed
     *
     * @throws \Symfony\Component\HttpKernel\Exception\NotFoundHttpException
     */

    public function __construct(LeadModel $leadModel, IntegrationHelper $integrationHelper)
    {
        $this->leadModel = $leadModel;

        $integration = $integrationHelper->getIntegrationObject('Myupcharsms');

        if ($integration && $integration->getIntegrationSettings()
            ->getIsPublished())
        {

            $keys = $integration->getDecryptedApiKeys();

            if (isset($keys['appid']))
            {
                $this->appid = $keys['appid'];
                $this->userid = $keys['userid'];
                $this->api_url = $keys['api_url'];
                $this->sendername = $keys['sender'];
                $this->password = $keys['password'];

            }
        }
    }

    public function createForm($entity, $formFactory, $action = null, $params = [])
    {
        if (!$entity instanceof Myupcharsms)
        {
            throw new MethodNotAllowedHttpException(['Myupcharsms']);
        }

        if (!empty($action))
        {
            $params['action'] = $action;
        }

        return $formFactory->create('myupcharsms', $entity, $params);
    }

    public function getEntity($id = null)
    {
        if ($id === null)
        {
            $entity = new Myupcharsms();
        }
        else
        {
            $entity = parent::getEntity($id);
        }

        return $entity;
    }

    public function sendMyupcharSms(Myupcharsms $myupchar, Lead $sendTo, $options = [])
    {
        if ($sendTo instanceof Lead)
        {
            $sendTo = [$sendTo];
        }
        elseif (!is_array($sendTo))
        {
            $sendTo = [$sendTo];
        }

        $sentCount = 0;
        $results = [];
        $contacts = [];
        $fetchContacts = [];
        foreach ($sendTo as $lead)
        {
            if (!$lead instanceof Lead)
            {
                $fetchContacts[] = $lead;
            }
            else
            {
                $contacts[$lead->getId() ] = $lead;
            }
        }

        if ($fetchContacts)
        {
            $foundContacts = $this
                ->leadModel
                ->getEntities(['ids' => $fetchContacts, ]);

            foreach ($foundContacts as $contact)
            {
                $contacts[$contact->getId() ] = $contact;
            }
        }
        $contactIds = array_keys($contacts);

        /** @var DoNotContactRepository $dncRepo */

        $dncRepo = $this
            ->em
            ->getRepository('MauticLeadBundle:DoNotContact');
        $dnc = $dncRepo->getChannelList('myupcharsms', $contactIds);
        if (!empty($dnc))
        {
            foreach ($dnc as $removeMeId => $removeMeReason)
            {
                $results[$removeMeId] = ['sent' => false, 'status' => 'mautic.myupchar.campaign.failed.not_contactable', ];

                unset($contacts[$removeMeId], $contactIds[$removeMeId]);
            }
        }

        if (!empty($contacts))
        {

            $stats = [];
            if (count($contacts))
            {
                /** @var Lead $lead */
                foreach ($contacts as $lead)
                {
                    $leadId = $lead->getId();
                    $leadPhoneNumber = $lead->getLeadPhoneNumber();
                    $leadCountry = $lead->getCountry();
                    $leadName = $lead->getName();

                    if (empty($leadPhoneNumber))
                    {
                        $result['error'] = ['sent' => false, 'status' => 'mautic.myupchar.campaign.failed.missing_number', ];

                        continue;
                    }
                    else if (!empty($leadPhoneNumber))
                    {
                        $status = "valid";
                        if ($status == "valid")
                        {
							$contenttype = 3;
							
							if($contenttype == 3)
								$message=urlencode($options['message_data']);
							else
								$message=$options['message_data'];
							
                            if ((substr($leadPhoneNumber, 0, 3) === "+91") || (substr($leadPhoneNumber, 0, 2) === "91"))
                            {
                                $leadPhoneNumber = $leadPhoneNumber;
                            }
                            else
                            {
                                $leadPhoneNumber = "+91" . $leadPhoneNumber;
                            }
                            $ch = curl_init();

							 //~ curl_setopt($ch, CURLOPT_URL,"https://dmz.aclgateway.com/servlet/com.aclwireless.pushconnectivity.listeners.TextListener?appid=myupcalt&userId=myupcalt&pass=myupcalt14&from=MYUPCR&to=7810051760&contenttype=3&alert=1&selfid=true&dlrreq=true&intflag=false&text=".$message);
							 curl_setopt($ch, CURLOPT_URL,"https://dmz.aclgateway.com/servlet/com.aclwireless.pushconnectivity.listeners.TextListener?appid=".$this->appid."&userId=".$this->userid."&pass=" . $this->password . "&from=" . $this->sendername . "&to=7810051760&contenttype=".$contenttype."&text=" . $message . "&alert=1&selfid=true&dlrreq=true&intflag=false");
							curl_setopt($ch, CURLOPT_POST, 1);
							// Receive server response ...
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

							$server_output = curl_exec($ch);
							$err = curl_error($ch);
							curl_close ($ch);

 
                            if ($err)
                            {
                                $result['error'] = $err;
                            }
                            else
                            {
								
								$rejection_status = array(-1 => "Enterprise Id Missing", -2 => "User Id Missing", -3 => "Password Missing", -4 => "Content type Missing",-5 => "Sender Missing", -6 => "MSISDN Missing", -7 => "Message Text Missing", -8 => "Message Id Missing", -9 => "WAP Push URL Missing", -10 => "Authentication Failed");
								// -11 = Service Blocked for User -12 = Repeated Message Id Received -13 = Invalid Content Type Received -14 = International Messages Not Allowed -15 = Incomplete or Invalid XML Packet Received -16 = Invalid DND Flag value -17 = Direct Pushing Not Allowed -18 = CLI not registered -19 = Operator Specific MSISDN Blocked -41= Acl_Error_Invalid_Shorten  -42 =   Acl_Error_Shortening_Not_Allowed -43 =   Acl_Error_Invalid_Domain -44 =   Acl_Error_Invalid_Alias -45 =   Acl_Error_Invalid_Forward -46 =   Acl_Error_Forward_Not_Allowed -75=Incomplete or Invalid JSON Packet Received  
								
								$strpo = strpos($server_output,"myupcalt");
								if($strpo != -1 || $strpo != null)
								{
									$senttime = date('Y-m-d H:i:s');
									$status = 'Sent';
									$myupcharRepo = $this
										->em
										->getRepository('MauticMyupcharSmsBundle:Myupcharsms');
										
									$idres = str_replace(' ', '', $server_output);
									$idres = rtrim($server_output," ");
									$myupchar->setLead($lead);
									$myupchar->setResponseId($idres);
									$myupchar->setMobileNo($leadPhoneNumber);
									$myupchar->setSentTime($senttime);
									$myupchar->setResponseStatus($status);
									$myupchar->setMessage($status);
									$myupchar->setCallStatus($status);
									$myupchar->setStatusTime($senttime);

									$myupchar->setResponseMessage("Message successfully sent");
									$myupchar->setCampid($options['campaignId']);
									
									$myupcharRepo->saveEntity($myupchar);
									$result['success'] = $server_output;
								}else{
									$result['error'] = "API call failed";
								}
                            }
                        }
                        else
                        {
                            $result['error'] = ['sent' => false, 'status' => 'mautic.myupchar.campaign.failed.invalid', ];
                        }
                    }

                }
            }
            return $result;
        }

    }

    public function getMyupcharsmsLists($limit = 10, $dateFrom = null, $dateTo = null, $filters = [])
    {
        $q = $this
            ->em
            ->getConnection()
            ->createQueryBuilder();
        $q->select('t.sentTime, t.callStatus, t.response_status ,t.lead_id,t.mobileNo')
            ->from(MAUTIC_TABLE_PREFIX . 'myupcharsms', 't')
            ->groupBy('t.id')
            ->orderBy('t.sentTime', 'DESC')
            ->setMaxResults($limit);

        $chartQuery = new ChartQuery($this
            ->em
            ->getConnection() , $dateFrom, $dateTo);
        $chartQuery->applyFilters($q, $filters);
        $chartQuery->applyDateFilters($q, 'sentTime');

        $results = $q->execute()
            ->fetchAll();
        return $results;
    }

    public function saveMyupcharSmsResponse(MyupcharSms $myupchar, $options = [], $response)
    {
        $myupcharRepo = $this->em->getRepository('MauticMyupcharSmsBundle:Myupcharsms');
        
        $opdata = $response['success'];
        $senttime = date('Y-m-d H:i:s');
        $status = 'sent';
        $responseStatus = 'success';
           
        $myupchar->setResponseId($opdata);
        $myupchar->setCampid($options['campaignId']);
        $myupchar->setResponseStatus($responseStatus);
        $myupchar->setCallStatus($status);
        $myupchar->setResponseMessage($opdata);
        $myupchar->setSentTime($senttime);
        $myupchar->setStatusTime($senttime);
        $myupcharRepo->saveEntity($myupchar);
          
    }

    public function getMyupcharSms()
    {
        $myupcharRepo = $this
            ->em
            ->getRepository('MauticMyupcharSmsBundle:Myupcharsms');
        return $myupcharRepo->getMyupcharResponse();

    }

    public function getMyupchar($id)
    {
        $myupcharRepo = $this
            ->em
            ->getRepository('MauticMyupcharSmsBundle:Myupcharsms');
        return $myupcharRepo->getMyupcharRow($id);

    }

    public function getMyupcharType()
    {
        $myupcharRepo = $this
            ->em
            ->getRepository('MauticMyupcharSmsBundle:Myupcharsms');
        return $myupcharRepo->getMyupcharType();

    }

    public function hitCall($entity, $request, $viaBrowser = false, $activeRequest = true)
    {

        if (!$entity instanceof Myupcharsms)
        {
            $entity = $this->getMyupchar($entity);
        }

        if (!$entity)
        {
            return;
        }

        $lead = $entity->getLead();

        if (strtoupper($entity->getCallStatus()) == "SUCCESS")
        {

            $firstTime = true;
            if ($this
                ->dispatcher
                ->hasListeners(MyupcharSmsEvents::MyupcharSMS_ON_DELIVERED))
            {

                $event = new CallEvent($entity, $request, $firstTime);
                $this
                    ->dispatcher
                    ->dispatch(MyupcharSmsEvents::MyupcharSMS_ON_DELIVERED, $event);
                return true;

            }
            return false;
        }
        elseif (strtoupper($entity->getCallStatus()) == "FAILED")
        {
            $firstTime = true;
            if ($this
                ->dispatcher
                ->hasListeners(MyupcharSmsEvents::MyupcharSMS_ON_UNDELIVERED))
            {
                $event = new CallEvent($entity, $request, $firstTime);
                $this
                    ->dispatcher
                    ->dispatch(MyupcharSmsEvents::MyupcharSMS_ON_UNDELIVERED, $event);
                return true;
            }
            return false;
        }

    }

}

