<?php

/*
 * @copyright   2016 Mautic, Inc. All rights reserved
 * @author      Mautic, Inc
 *
 * @link        https://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\MauticMyupcharSmsBundle\Model;
// namespace MauticPlugin\MauticMyupcharSmsBundle\Entity;

use Mautic\CoreBundle\Model\FormModel;
use MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupchar;
// use MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupcharsms;
use MauticPlugin\MauticSocialBundle\Entity\Monitoring;
use Symfony\Component\EventDispatcher\Event;
use MauticPlugin\MauticMyupcharSmsBundle\Form\Type\MyupcharyType;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;
use Mautic\CoreBundle\Model\AjaxLookupModelInterface;
use Mautic\CoreBundle\Model\BuilderModelTrait;
use Mautic\CoreBundle\Model\TranslationModelTrait;
use Mautic\CoreBundle\Model\VariantModelTrait;
/**
 * Class MonitoringModel
 * {@inheritdoc}
 */
class MyupcharModel extends FormModel implements AjaxLookupModelInterface
{
    /**
     * {@inheritdoc}
     *
     * @param       $entity
     * @param       $formFactory
     * @param null  $action
     * @param array $options
     *
     * @return mixed
     *
     * @throws \Symfony\Component\HttpKernel\Exception\NotFoundHttpException
     */
    public function createForm($entity, $formFactory, $action = null, $params = [])
    {
        if (!$entity instanceof Myupchar) {
            throw new MethodNotAllowedHttpException(['Myupchar']);
        }

        if (!empty($action)) {
            $params['action'] = $action;
        }

        return $formFactory->create(MyupcharyType::class, $entity, $params);
    }

    /**
     * Get a specific entity or generate a new one if id is empty.
     *
     * @param $id
     *
     * @return null|Monitoring
     */
    public function getEntity($id = null)
    {
        return $id ? parent::getEntity($id) : new Myupchar();
    }

   

    /**
     * {@inheritdoc}
     *
     * @var \MauticPlugin\MauticSocialBundle\Entity\Monitoring
     */
    public function saveEntity($monitoringEntity, $unlock = true)
    {
        parent::saveEntity($monitoringEntity, $unlock);
    }

    /**
     * {@inheritdoc}
     */
    public function getRepository()
    {
        return $this->em->getRepository('MauticMyupcharSmsBundle:Myupchar');
    }

    /**
     * @return string
     */
    public function getPermissionBase()
    {
        return 'plugin:mauticMyupcharSms:myupchar';
    }

    /**
     * @return array
     */
    public function getTypes()
    {
        $types = [
            '1' => 'mautic.plugin.obd.playtype.ivr_choice',
            '2'  => 'mautic.plugin.obd.playtype.sound_choice',
        ];

        return $types;
    }
    
    public function hitCall($myupcharsms, $request, $viaBrowser = false, $activeRequest = true)
    {
		if(!$myupcharsms instanceof Myupcharsms){
            $myupcharsms = $this->getVoice($myupcharsms->getId());
        }

		 if (!$myupcharsms) {
            return;
        }
        // $leadId = $myupcharsms['lead_id'];
        // $idd = $myupcharsms['id'];
        
        
        //$mobileRepo = $this->getMobRepository();
        //$mbl = $mobileRepo->find($idd);
     
       $lead = $myupcharsms->getLead();
      
     
		if(strtoupper($myupcharsms->getStatus()) == DELIVERED)
		{			
			$firstTime = true;
			if ($this->dispatcher->hasListeners(MyupcharSmsEvents::MyupcharSMS_ON_DELIVERED)) {
				$event = new CallEvent($myupcharsms, $request, $firstTime);
				$this->dispatcher->dispatch(MyupcharSmsEvents::MyupcharSMS_ON_DELIVERED, $event);
				return true;    
			}
			return false;
		}
		elseif(strtoupper($myupcharsms->getStatus() )== UNDELIVERED)
		{
			
			$firstTime = true;
			if ($this->dispatcher->hasListeners(MyupcharSmsEvents::MyupcharSMS_ON_UNDELIVERED)) {
				$event = new CallEvent($myupcharsms, $request, $firstTime);
				$this->dispatcher->dispatch(MyupcharSmsEvents::MyupcharSMS_ON_UNDELIVERED, $event);
				return true;    
			}
			return false;
		}
		
			
   
    }
    
    public function getLookupResults($type, $filter = '', $limit = 10, $start = 0, $options = [])
    {
        $results = [];
        switch ($type) {
            case 'myupchar':
                $myupcharRepo = $this->getRepository();
                $myupcharRepo->setCurrentUser($this->userHelper->getUser());
                $myupchars = $myupcharRepo->getMyupcharList(
                    $filter,
                    $limit,
                    $start,
                    $this->security->isGranted('myupchar:myupchars:viewothers'),
                    isset($options['top_level']) ? $options['top_level'] : false,
                    isset($options['email_type']) ? $options['email_type'] : null,
                    isset($options['ignore_ids']) ? $options['ignore_ids'] : [],
                    isset($options['variant_parent']) ? $options['variant_parent'] : null
                );

                foreach ($myupchars as $myupchar) {
                    $results[$myupchar['id']] = $myupchar['name'];
                }

                //sort by language
                ksort($results);

                break;
        }

        return $results;
    }
    

}
