<?php

/*
 * @copyright   2014 Mautic Contributors. All rights reserved
 * @author      Mautic
 *
 * @link        http://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\MauticMyupcharSmsBundle\Integration;

use Mautic\PluginBundle\Integration\AbstractIntegration;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
class MyupcharsmsIntegration extends AbstractIntegration
{
    public function getName()
    {
        return 'Myupcharsms';
    }
    
    public function getDisplayName()
    {
        return 'MyupcharSms';
    }

    /**
     * Return's authentication method such as oauth2, oauth1a, key, etc.
     *
     * @return string
     */
    public function getAuthenticationType()
    {
        // Just use none for now and I'll build in "basic" later
        return 'none';
    }

    /**
     * Return array of key => label elements that will be converted to inputs to
     * obtain from the user.
     *
     * @return array
     */

    public function getRequiredKeyFields()
    {
        return [
            'appid' => 'mautic.integration.myupcharsms.appid',
            'api_url' => 'mautic.integration.myupcharsms.apiurl',
            'userid' => 'mautic.integration.myupcharsms.userid',
            'password' => 'mautic.integration.myupcharsms.password',
            'sender' => 'mautic.integration.myupcharsms.sender',
        ];
    }
    
    
    public function getApiUrl()
    {
        $url = $this->router->generate('mautic_myupchar_public_index', [], UrlGeneratorInterface::ABSOLUTE_URL);
        return $url;
    }

    public function getFormNotes($section)
    {
        if ('custom' === $section) {
            return [
                'template'   => 'MauticMyupcharSmsBundle:Integration:form.html.php',
                'parameters' => [
                     'mauticUrl' => $this->router->generate(
                        'mautic_myupchar_public_index', [], UrlGeneratorInterface::ABSOLUTE_URL
                    ),
                ],
            ];
        }

        return parent::getFormNotes($section);
    }
 
}

