<?php

namespace MauticPlugin\MauticMyupcharSmsBundle\Events;
namespace MauticPlugin\MauticMyupcharSmsBundle\EventListener;

use Mautic\CampaignBundle\Event as Events;
use Mautic\CampaignBundle\CampaignEvents;
use Mautic\CampaignBundle\Event\CampaignBuilderEvent;
use Mautic\CampaignBundle\Event\CampaignExecutionEvent;
use Mautic\CampaignBundle\Executioner\RealTimeExecutioner;

use MauticPlugin\MauticMyupcharSmsBundle\Model\MyupcharsmsModel;
use MauticPlugin\MauticMyupcharSmsBundle\Model\MyupcharModel;
use MauticPlugin\MauticMyupcharSmsBundle\MyupcharSmsEvents;
use Mautic\CampaignBundle\Event\CampaignTriggerEvent;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Mautic\PluginBundle\Helper\IntegrationHelper;
use MauticPlugin\MauticMyupcharSmsBundle\Helper\CampaignEventHelper;
use MauticPlugin\MauticMyupcharSmsBundle\Form\Type\MyupcharsmsType;
use MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupcharsms;
use Mautic\CampaignBundle\Model\EventModel;
use MauticPlugin\MauticMyupcharSmsBundle\Event\CallEvent;
use Psr\Log\LoggerInterface;


class CampaignSubscriber implements EventSubscriberInterface
{

    protected $myupcharsmsModel;

    protected $campaignEventHelper;

    protected $campaignEventModel;

    protected $logggg;

    private $realTimeExecutioner;

    protected $myupcharModel;


    public function __construct(CampaignEventHelper $campaignEventHelper, MyupcharsmsModel $myupcharsmsModel, EventModel $eventModel, LoggerInterface $logggg, RealTimeExecutioner $realTimeExecutioner, MyupcharModel $myupcharModel)
    {
        $this->campaignEventHelper = $campaignEventHelper;
        $this->myupcharsmsModel = $myupcharsmsModel;
        $this->campaignEventModel = $eventModel;
        $this->logggg = $logggg;
        $this->realTimeExecutioner = $realTimeExecutioner;
        $this->myupcharModel    = $myupcharModel;


    }

    static public function getSubscribedEvents()
    {
        return [
            CampaignEvents::CAMPAIGN_ON_BUILD => ['onCampaignBuild', 0],
            MyupcharSmsEvents::ON_CAMPAIGN_TRIGGER_ACTION => ['onCampaignTriggerAction', 0],
            MyupcharSmsEvents::MyupcharSMS_ON_DELIVERED            => ['onMyupcharSMSDelivered', 0],
            MyupcharSmsEvents::MyupcharSMS_ON_UNDELIVERED          => ['onMyupcharSMSUndelivered', 0],
            MyupcharSmsEvents::ON_CAMPAIGN_TRIGGER_DECISION 	 => ['onCampaignTriggerDecision', 0],
        ];
    }

    /**
     * Add campaign decision and actions
     *
     * @param Events\CampaignBuilderEvent $event
     */
    public function onCampaignBuild(Events\CampaignBuilderEvent $event)
    {
        // Register custom action
        $event->addAction(
            'myupcharsms.sendacltext',
            array(
                'eventName'       => MyupcharSmsEvents::ON_CAMPAIGN_TRIGGER_ACTION,
                'label'           => 'mautic.campaign.myupcharsms.send_sms',
                'description'     => 'mautic.campaign.myupcharsms.send_sms.tooltip',
                'formType'        => MyupcharsmsType::class,
                'formTheme'       => 'MauticMyupcharSmsBundle:FormTheme\SubmitAction',
                'formTypeOptions' => []
            )
        );
        
        $event->addDecision(
            'myupcharsms.delivered',
            [
                'eventName'              => MyupcharSmsEvents::ON_CAMPAIGN_TRIGGER_DECISION,
                'label'                  => 'mautic.myupcharsms.campaign.event.delivered',
                'description'            => 'mautic.myupcharsms.campaign.event.delivered_descr',
                   'connectionRestrictions' => [
                        'source' => [
                            'action' => [
                                'myupcharsms.sendacltext',
                            ],
                        ],
                    ],
            ]
        );
         $event->addDecision(
            'myupcharsms.undelivered',
            [
                'eventName'              => MyupcharSmsEvents::ON_CAMPAIGN_TRIGGER_DECISION,
                'label'                  => 'mautic.myupcharsms.campaign.event.undelivered',
                'description'            => 'mautic.myupcharsms.campaign.event.undelivered_descr',
                   'connectionRestrictions' => [
                        'source' => [
                            'action' => [
                                'myupcharsms.sendacltext',
                            ],
                        ],
                    ],
            ]
        );

    }

    public function onCampaignTriggerAction(CampaignExecutionEvent $event)
    {
        $lead  = $event->getLead();
        $myupchar   = $this->myupcharsmsModel->getEntity();

        if (!$myupchar) {
            return $event->setFailed('mautic.myupchar.campaign.failed.missing_entity');
        }

        $result = $this->myupcharsmsModel->sendMyupcharSms($myupchar, $lead, ['message_data' => $event->getConfig()['sms_msg'],'smsid'=>$event->getConfig()['objectId'],'campaignId' => $event->getConfig()['campaignId']]); 
        

        if (!empty($result['error']) &&'Authenticate' === $result['error']) {
            // Don't fail the event but reschedule it for later
            return $event->setResult(false);
        }
        if (!empty($result['success'])) {
            if($result['success']){
                //$response_save = $this->myupcharsmsModel->saveMyupcharSmsResponse($myupchar,['message_data' => $event->getConfig()['sms_msg'],'campaignId' => $event->getConfig()['campaignId']],$result); 
            }
            $event->setChannel('myupcharsms', $myupchar->getId());
            $event->setResult($result);
        } else if(!empty($result['error'])) {
            $result['failed'] = true;
            $result['reason'] = $result['error'];
            $event->setResult($result);
        }else{
			$event->setResult($result);
		}       
    }
    
   public function onMyupcharSMSDelivered(CallEvent $event)
    {
        $myupcharsms  = $event->getMyupcharsms();
        try
        {
            //~ $test = $this->campaignEventModel->triggerEvent('myupcharsms.delivered',$textalert, '', '');
            $this->realTimeExecutioner->execute('myupcharsms.delivered', $myupcharsms, '', '');
        }
        catch(Exception $e){
           $this->logggg->error('campaignEventModelError=>'.$e->getErrorMessage());
        }
    }
    public function onMyupcharSMSUndelivered(CallEvent $event)
    {
        $myupcharsms  = $event->getMyupcharsms();
        try
        {
            $this->realTimeExecutioner->execute('myupcharsms.undelivered', $myupcharsms, '', '');
        }
        catch(Exception $e){
           $this->logggg->error('campaignEventModelError=>'.$e->getErrorMessage());
        }
    }

    public function onCampaignTriggerDecision(CampaignExecutionEvent $event)
    {

        $eventDetails = $event->getEventDetails();
        $eventParent  = $event->getEvent()['parent'];

        $eventConfig  = $event->getConfig();

        if ($eventDetails == null) {
            return $event->setResult(false);
        }
       //check to see if the parent event is a "myupcharsms message send" event and that it matches the current message is delivered/undelivered
     
        if (!empty($eventParent) && $eventParent['type'] === 'myupcharsms.sendacltext') {
            
            if ($event->checkContext('myupcharsms.delivered')) {
                return $event->setResult(true);
            } 
            elseif ($event->checkContext('myupcharsms.undelivered')) {
                return $event->setResult(true);
            } 
        }else{
			 return $event->setResult(false);
		}

    }
}
