<?php

/*
 * @copyright   2014 Mautic Contributors. All rights reserved
 * @author      Mautic
 *
 * @link        http://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace MauticPlugin\MauticMyupcharSmsBundle\Event;

use Mautic\CoreBundle\Event\CommonEvent;
use MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupchar;
use MauticPlugin\MauticMyupcharSmsBundle\Entity\Myupcharsms;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class EmailOpenEvent.
 */
class CallEvent extends CommonEvent
{
    /**
     * @var Request
     */
    private $request;

    /**
     * @var mobile
     */
    private $myupchar;

    /**
     * @var bool
     */
    private $firstTime;
    
    //~ private $id;

    /**
     * @param Email $email
     */
    public function __construct(Myupcharsms $myupchar, $request, $firstTime = false)
    {
        $this->text     = $myupchar;
        $this->request   = $request;
        $this->firstTime = $firstTime;
    }

    /**
     * Returns the Email entity.
     *
     * @return Email
     */
    public function getMyupcharsms()
    {
        return $this->text;
    }
    
    
    //~ public function getId()
    //~ {
        //~ return $this->id;
    //~ }

    /**
     * Get email request.
     *
     * @return string
     */
    public function getRequest()
    {
        return $this->request;
    }

   
    /**
     * Returns if this is first time the voice call is busy.
     *
     * @return bool
     */
    public function isFirstTime()
    {
        return $this->firstTime;
    }
}
