<?php
/*
+---------------------------------------------------------------------------+
| OpenX v2.8                                                                |
| ==========                                                                |
|                                                                           |
| Copyright (c) 2003-2009 OpenX Limited                                     |
| For contact details, see: http://www.openx.org/                           |
|                                                                           |
| This program is free software; you can redistribute it and/or modify      |
| it under the terms of the GNU General Public License as published by      |
| the Free Software Foundation; either version 2 of the License, or         |
| (at your option) any later version.                                       |
|                                                                           |
| This program is distributed in the hope that it will be useful,           |
| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
| GNU General Public License for more details.                              |
|                                                                           |
| You should have received a copy of the GNU General Public License         |
| along with this program; if not, write to the Free Software               |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
+---------------------------------------------------------------------------+
$Id: account-settings-database.php 34688 2009-04-01 16:18:28Z andrew.hill $
*/

// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';
require_once MAX_PATH . '/lib/OA/Creative/File.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/max/Admin_DA.php';


// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql') {
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql') {
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli') {
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

// Create a new option object for displaying the setting's page's HTML form
$oOptions = new OA_Admin_Option('user');

// Prepare an array for storing error messages
$aErrormessage = array();


if (isset($_POST['submitok']) && $_POST['submitok'] == 'true') 
{
	// echo "<pre>";print_r($_POST); exit;
	$name = $_POST['profile'];

	if($_POST['profileid']!= '')
	{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}profile set name = '".strtolower($name)."' where profileid='".$_POST['profileid']."'");
	}
	else
	{
		OA_Dal_Delivery_query("INSERT into {$table_prefix}profile (name) values('".strtolower($name)."')");
	}
	
	OX_Admin_Redirect::redirect("plugins/mobileAdsDelivery/account-settings-custom-profile.php?profileid=".$profileid);
}


//BUILD FORM

// Display the settings page's header and sections
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('custom-profile-index', $oHeaderModel);
$profileid = $_GET['profileid'];
$name = '';

if(!empty($_GET['profileid']))
{
	$query = OA_Dal_Delivery_query("SELECT * from {$table_prefix}profile where profileid =".$profileid);
	$row = OA_Dal_Delivery_fetchAssoc($query);
	$name = $row['name'];
}

echo '<style>
  
#profileid
{
  display: none;
}

</style>';


$aSettings = array (
    array (
        'text'  => "Add New Custom Client Profile",
        'items' => array (    

        array (
                'type'    => 'break'
            ),
            array (
                'type'    => 'text',
                'name'    => 'profile',
                'value'   => $name ,
                'text'    => 'Profile Name',
                'size'    => 50

            ),
			array (
					'type'    => 'text',
					'name'    => 'profileid',
					'value'   => $profileid,
	                'text'    => '',
	                'size'    => 1
			),

        )
    )
);
$oOptions->show($aSettings, $aErrormessage);

// Display the page footer
phpAds_PageFooter();

?>
