<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/
require_once '../../init.php';
require_once MAX_PATH . '/www/admin/config.php';


require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitationsCommaSeparatedData.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';


// Redirect to the appropriate "Settings" page



/**
 * A Client delivery limitation plugin, for filtering delivery of ads on the
 * basis of the viewer's operating system.
 *
 * Works with:
 * A comma separated string of operating system codes. See the Os.res.inc.php
 * resource file for details of the valid operating system codes.
 *
 * Valid comparison operators:
 * =~, !~
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */
class Plugins_DeliveryLimitations_Client_Mobileoswithversion extends Plugins_DeliveryLimitations_CommaSeparatedData
{
    function __construct()
    {
        parent::__construct();
        $this->nameEnglish = 'Mobile - Mobile-Os and Version';
    }

    function init($data)
    {
        parent::init($data);
        $this->setAValues(array_keys($this->res));
    }

    /**
     * Outputs the HTML to display the data for this limitation
     *
     * @return void
     */
    function displayArrayData()
    {
        $tabindex =& $GLOBALS['tabindex'];

echo "<table width='100%' cellpadding='0' cellspacing='0' border='0'>";

?>
<style>
	
	.level_2  , .level_3
	{
		margin-bottom: 10px;
	}
	
	.level_2>li
	{
	  display: inline-block;
    padding-right: 15px;
    vertical-align: top;
	}
	
	.tit_1
	{
	    font-size: 13px;
    margin-bottom: 5px;
    margin-top: 5px;	
	}
	.tit_2
	{
	    font-size: 11px;
    margin-bottom: 3px	
	}
	
</style>
<tr> 
	<td colspan="2">
		<div class="ec-selectors">
			<ul class="level_1">
				<li>	
						<h5 class="tit_1">Android OS Versions</h5>
						<ul class="level_2">
							<li><h5 class="tit_2">Kitkat</h5>
									<ul class="level_3">
										<li>4.4,</li>
										<li>4.4.1,</li>
										<li>4.4.3,</li>
										<li>4.4.4</li>
									</ul>
							</li>
							
							<li><h5 class="tit_2">Lollipop</h5>
									<ul class="level_3">
										<li>5.0,</li>
										<li>5.1</li>
										<li>5.1.1</li>
									</ul>
							</li>
							
							<li><h5 class="tit_2">Marshmallow</h5>
									<ul class="level_3">
										<li>6.0,</li>
										<li>6.0.1</li>
									</ul>
							</li>
							
							<li><h5 class="tit_2">Nougat</h5>
									<ul class="level_3">
										<li>7.0,</li>
										<li>7.1,</li>
										<li>7.1.1,</li>
										<li>7.1.2</li>
									</ul>
							</li>
							
							<li><h5 class="tit_2">Oreo</h5>
									<ul class="level_3">
										<li>8.0.0,</li>
										<li>8.1.0</li>
									</ul>
							</li>
							<li><h5 class="tit_2">Pie</h5>
									<ul class="level_3">
										<li>9</li>
									</ul>
							</li>
							<li><h5 class="tit_2">Q</h5>
									<ul class="level_3">
										<li>10</li>
									</ul>
							</li>
							
						</ul>
						
						
				</li>
				
				
				
				
				
				<li>	
						<h5 class="tit_1">iOS OS Versions</h5>
						<ul class="level_2">
							<li><h5 class="tit_2">4.3 : Durango </h5>	</li>
							<li><h5 class="tit_2">5.0 : Telluride </h5>	</li>
							<li><h5 class="tit_2">5.1 : Hoodoo </h5>	</li>
							<li><h5 class="tit_2">6.0 : Sundance </h5>	</li>
							
							<li><h5 class="tit_2">  6.1: Brighton </h5>	</li>
							<li><h5 class="tit_2">  7.0: Innsbruck </h5>	</li>
							<li><h5 class="tit_2">  7.1: Sochi </h5>	</li>
							<li><h5 class="tit_2">  8.0: Okemo </h5>	</li>
							<li><h5 class="tit_2">  8.1: OkemoTaos </h5>	</li>
							<li><h5 class="tit_2">  8.2: OkemoZurs </h5>	</li>
							<li><h5 class="tit_2">  8.3: Stowe </h5>	</li>
							<li><h5 class="tit_2">  8.4: Copper </h5>	</li>
							<li><h5 class="tit_2">  9.0: Monarch </h5>	</li>
							<li><h5 class="tit_2">  9.1: Boulder </h5>	</li>
							<li><h5 class="tit_2">  9.2: Castlerock </h5>	</li>
							<li><h5 class="tit_2">  9.3: Eagle </h5>	</li>
							<li><h5 class="tit_2">  10.0: Whitetail </h5>	</li>
							<li><h5 class="tit_2">  10.1: Butler </h5>	</li>
							<li><h5 class="tit_2">  10.2: Corry </h5>	</li>
							<li><h5 class="tit_2">  10.3: Erie </h5>	</li>
							<li><h5 class="tit_2">  11.0: Tigris</h5>	</li>
							<li><h5 class="tit_2">  11.1: Bursa </h5>	</li>
							<li><h5 class="tit_2">  11.2: Cinar </h5>	</li>
							<li><h5 class="tit_2">  11.3: Emet </h5>	</li>
							<li><h5 class="tit_2">  11.1: Bursa </h5>	</li>
							<li><h5 class="tit_2">  11.2: Cinar </h5>	</li>
							<li><h5 class="tit_2">  11.3: Emet </h5>	</li>
                            <li><h5 class="tit_2">  11.4: Fatsa </h5>	</li>
							<li><h5 class="tit_2">  12.0: Hope </h5>	</li>
							<li><h5 class="tit_2">  13.0: Yukon </h5>	</li>
														
							
					
						</ul>
						
						
				</li>
				
			
			</ul>
		</div>

	</td>
</tr>



		<tr>
        <td align="left" width="50"><strong><?php echo $this->translate("Mobile-OS");?>:</strong></td>
        <td><select name="acl[<?php echo $this->executionorder;
        ?>][data][]" value="<?php echo((!empty($this->data[0])) ? htmlspecialchars($this->data[0]) : '');
        ?>" tabindex="<?php echo $tabindex;
        ?>"> <?php foreach ($this->res as $key => $value) {
            echo "<option value='{$key}'".($key == $this->data[0] ? ' selected="selected"' : '').">{$value}</option>";
        }
        ?></select></td><?php
        
        echo "<tr id='acl-".$this->executionorder."'>";
	    echo "    <th align='center'>".$this->translate('Mobile-OsVersion')."</th>";
		echo "    <td align='center'><input type='text'  name='acl[{$this->executionorder}][data][]' value='" . ((!empty($this->data[1])) ? htmlspecialchars($this->data[1], ENT_QUOTES) : '') . "' tabindex='".($tabindex++)."'></td></br>";
		echo "</tr>";
		echo "</table>";
    }
    
    
		function _flattenData($data = null)
    {
        $result = parent::_flattenData($data);
        
        if (is_array($result)) {

            return implode($this->delimiter, $result);
        }
        return $result;
    }

}
?>
