<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitationsCommaSeparatedData.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once '../../init.php';

use Sinergi\BrowserDetector\Os;

/**
 * A Client delivery limitation plugin, for filtering delivery of ads on the
 * basis of the viewer's operating system.
 *
 * Works with:
 * A comma separated string of operating system codes. See the Os.res.inc.php
 * resource file for details of the valid operating system codes.
 *
 * Valid comparison operators:
 * =~, !~
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */
class Plugins_DeliveryLimitations_Client_Mobilebrandwithmodel extends Plugins_DeliveryLimitations_CommaSeparatedData
{
    function __construct()
    {
        parent::__construct();
        $this->nameEnglish = 'Mobile - Mobile Brand and Model';
    }

    function init($data)
    {
        parent::init($data);
        $this->setAValues(array_keys($this->res));
    }

    /**
     * Outputs the HTML to display the data for this limitation
     *
     * @return void
     */
     function displayArrayData()
    {
        $this->data = $this->_expandData($this->data);
        $tabindex =& $GLOBALS['tabindex'];

        // The region plugin is slightly different since we need to allow for multiple regions in different countries
        echo "
            <table border='0' cellpadding='2'>
                <tr>
                    <th>" . $this->translate('Mobile-brand') . "</th>
                    <td>
                        <select name='acl[{$this->executionorder}][data][]' {$disabled}>";
                        foreach ($this->res as $brand => $brandn) {
                            $selected = ($this->data[0] == $brandn) ? 'selected="selected"' : '';
                            echo "<option value='{$brandn}' {$selected}>{$brandn}</option>";
                        }
                        echo "
                        </select>
                    &nbsp;<input type='image' name='action[none]' src='" . OX::assetPath() . "/images/{$GLOBALS['phpAds_TextDirection']}/go_blue.gif' border='0' align='absmiddle' alt='{$GLOBALS['strSave']}'></td>
                </tr>";
                // print_r($GLOBALS['_MAX']['_GEOCACHE']['model']);
                // print_r($this->data[0]);
               if (!empty($this->data[0])) 
               {
                 //echo $this->data[0];
                $index = $this->res[$this ->data[0]];
                    // A country has been selected, show city list for this country...
                    // Note: Since a disabled field does not pass it's value through, we need to pass the selected country in...
                    echo "<tr><th>" . $this->translate('Mobile-model') . "</th><td><div class='box'>";
                    //$aRegions = $this->$this->data[0];
                    //unset($aRegions[0]);

                    //$aSelectedRegions = $this->data;
                    //unset ($aSelectedRegions[0]);

                    foreach ($GLOBALS['_MAX']['_GEOCACHE']['model'][$this->data[0]] as $model => $mName) {
                        echo "<div class='boxrow'>";
                        echo "<input tabindex='".($tabindex++)."' ";
                        echo "type='checkbox' id='m_{$this->executionorder}_{$model}' name='acl[{$this->executionorder}][data][]' value='{$mName}'".(in_array($mName, $this->data) ? 'CHECKED' : '').">{$mName}</div>";
                        
                        
               
                }
            echo "</div></td></tr>";
        }
        echo "
            </table>
        ";
        $this->data = $this->_flattenData($this->data);
    }
  
  /**
     * A private method to "flatten" a delivery limitation into the string format that is
     * saved to the database (either in the acls, acls_channel or banners table, when part
     * of a compiled limitation string).
     *
     * Flattens the country and region array into string format.
     *
     * @access private
     * @param mixed $data An optional, expanded form delivery limitation.
     * @return string The delivery limitation in flattened format.
     */
    function _flattenData($data = null)
    {
        if (is_null($data)) {
            $data = $this->data;
        }
        if (is_array($data)) {
            $brand = $data[0];
            unset($data[0]);
            return $brand . '|' . implode(',', $data);

        }
        return $data;
    }

    /**
     * A private method to "expand" a delivery limitation from the string format that
     * is saved in the database (ie. in the acls or acls_channel table) into its
     * "expanded" form.
     *
     * Expands the string format into an array with the country code in the first
     * element, and the region codes in the remaining elements.
     *
     * @access private
     * @param string $data An optional, flat form delivery limitation data string.
     * @return mixed The delivery limitation data in expanded format.
     */
    function _expandData($data = null)
    {
        if (is_null($data)) {
            $data = $this->data;
        }
        if (!is_array($data)) {
            $aData = strlen($data) ? explode('|', $data) : array();
            $aRegions = MAX_limitationsGetAFromS($aData[1]);
            return array_merge(array($aData[0]), $aRegions);
        }
        return $data;
    }

    /*function compile()
    {
        return $this->compileData($this->_preCompile($this->data));
    }

    function _preCompile($sData)
    {
        $aData = $this->_expandData($sData);
        $aData = MAX_limitationsGetPreprocessedArray($aData);
        return $this->_flattenData($aData);
    }*/
}

?>

