<?php
// ~ ini_set("display_errors", "1");
// ~ error_reporting(E_ALL);
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */

require_once MAX_PATH . '/lib/max/Delivery/limitations.delivery.php';

/**
 * Check to see if this impression contains the valid domain.
 *
 * @param string $limitation The domain limitation.
 * @param string $op The string operator.
 * @param array $aParams An array of additional parameters to be checked.
 * @return boolean Whether this impression's domain passes this limitation's test.
 */


function MAX_checkClient_Devicetype($limitation, $op, $aParams = array())
{


	//~DETECT MOBILE TABLET AND DESTOP START

    if ($limitation == '') {
        return true;
    }

	$tablet_browser = 0;
	$mobile_browser = 0;
	 
	if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
	    $tablet_browser++;
	}
	 
	
    if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
    	$mobile_browser++;
	}
	 
	if ((strpos(strtolower($_SERVER['HTTP_ACCEPT']),'application/vnd.wap.xhtml+xml') > 0) or ((isset($_SERVER['HTTP_X_WAP_PROFILE']) or isset($_SERVER['HTTP_PROFILE'])))) {
	    $mobile_browser++;
	}

	 
	$mobile_ua = strtolower(substr($_SERVER['HTTP_USER_AGENT'], 0, 4));
	$mobile_agents = array(
	    'w3c ','acs-','alav','alca','amoi','audi','avan','benq','bird','blac',
	    'blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno',
	    'ipaq','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-',
	    'maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-',
	    'newt','noki','palm','pana','pant','phil','play','port','prox',
	    'qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar',
	    'sie-','siem','smal','smar','sony','sph-','symb','t-mo','teli','tim-',
	    'tosh','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp',
	    'wapr','webc','winw','winw','xda ','xda-');
	 
	if (in_array($mobile_ua,$mobile_agents)) {
	    $mobile_browser++;
	}
	 
	if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'opera mini') > 0) {
	    $mobile_browser++;
	    //Check for tablets on opera mini alternative headers
	    $stock_ua = strtolower(isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])?$_SERVER['HTTP_X_OPERAMINI_PHONE_UA']:(isset($_SERVER['HTTP_DEVICE_STOCK_UA'])?$_SERVER['HTTP_DEVICE_STOCK_UA']:''));
	    if (preg_match('/(tablet|ipad|playbook)|(android(?!.*mobile))/i', $stock_ua)) {
	      $tablet_browser++;
	    }
	}

	//~ DETECT MOBILE TABLET DESKTOP END

	$return_val = 0;

	if($op == '!~')
	{
		
		if ($tablet_browser == 0 && $mobile_browser == 0 && strpos($limitation, 'Computer') !== false) 
		{
		    return false;
		}
		
		if ($tablet_browser > 0 && strpos($limitation, 'Tablet') !== false) 
		{
		    return false;
		}

		if ($mobile_browser > 0 && strpos($limitation, 'Mobile') !== false) 
		{
		    return false;
		}  
	}  

	if($op == '=~')
	{
		
		if ($tablet_browser == 0 && $mobile_browser == 0 && strpos($limitation, 'Computer') !== false) 
		{
		    return true;
		}
		
		if ($tablet_browser > 0 && strpos($limitation, 'Tablet') !== false) 
		{
		    return true;
		}

		if ($mobile_browser > 0 && strpos($limitation, 'Mobile') !== false) 
		{
		    return true;
		}
		else
		{
			return false;
		}  
	}


	$aParams['displaytype'] = ($_REQUEST[ 'displaytype']) ? $_REQUEST[ 'displaytype'] :$GLOBALS['_MAX']['device']['displaytype'];       

	//print_r(MAX_limitationsMatchArraydevices('displaytype', $limitation, $op,$aParams));exit;
    return MAX_limitationsMatchArraydevices('displaytype', $limitation, $op,$aParams);
}












