//
//  UserInputVc.swift
//  Demo_App
//
//  Created by Djax on 26/07/22.
//

import UIKit
import SDK_Lib

class UserInputVc: UIViewController
{
    @IBOutlet weak var zoneIdTf: UITextField!
    @IBOutlet weak var adLoadBtn: UIButton!
    
    var adResponse = AdResponse()

    override func viewDidLoad()
    {
        super.viewDidLoad()
    }
    override func viewWillAppear(_ animated: Bool)
    {
        navigationItem.title = UserDefaults.standard.object(forKey: "selectedItem") as? String
        navigationController?.navigationBar.backgroundColor = UIColor(red: 0.0 / 255.0, green: 116.0 / 255.0, blue: 183.0 / 255.0, alpha: 1.0)
        if let font = UIFont(name: "Times New Roman", size: 20) {
            navigationController?.navigationBar.titleTextAttributes = [
                NSAttributedString.Key.font: font,
                NSAttributedString.Key.foregroundColor: UIColor.white
            ]
        }
        navigationController?.navigationBar.tintColor = UIColor.white
        navigationController?.navigationBar.backItem?.title = ""
    }
    override func viewDidAppear(_ animated: Bool) {
        self.zoneIdTf.becomeFirstResponder()
    }
    @IBAction func adLoadBtnAction(sender:UIButton)
    {
        if zoneIdTf.text == ""
        {
            let alert = UIAlertController(title: "Error", message: "Enter your zone id", preferredStyle: .alert)
            alert.addAction(UIAlertAction(title: "Ok", style: .default))
            self.present(alert, animated: true)
        }
        else if zoneIdTf.text != ""
        {
           /* if UserDefaults.standard.string(forKey: "selectedItem") == "Basic Ads"  ||
            UserDefaults.standard.string(forKey: "selectedItem") == "Geofence - Text Ads"
            {
                let nextVC = UIStoryboard(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "BannerAd_Vc") as! BannerAd_Vc
                nextVC.zoneId = zoneIdTf.text!
                self.navigationController?.pushViewController(nextVC, animated: false)
            }
            else if
                UserDefaults.standard.string(forKey: "selectedItem") == "Interstitial Image Ads" ||
                UserDefaults.standard.string(forKey: "selectedItem") == "Geofence - Interstitial Image Ads"
            {
                let vc2 = Interstitial_Image_Ad()
                vc2.zoneId_Interstitial_Image = zoneIdTf.text!
                navigationController?.pushViewController(vc2, animated: false)
            }
            else if
                UserDefaults.standard.string(forKey: "selectedItem") == "Rewarded Video Ads"
            {
                let vc2 = Rewarded_Video_Ad()
                vc2.rewarded_zoneId = zoneIdTf.text!
                navigationController?.pushViewController(vc2, animated: false)
            }
            else if
                UserDefaults.standard.string(forKey: "selectedItem") == "Interstitial Video Ads" ||
                UserDefaults.standard.string(forKey: "selectedItem") == "Interstitial Image Ads"
            {
                let vc2 = Interstitial_Video_Ad()
                vc2.interstitial_zoneId = zoneIdTf.text!
                navigationController?.pushViewController(vc2, animated: false)
            }
            else if UserDefaults.standard.string(forKey: "selectedItem") == "Native Ads"
            {
                let nextVC = UIStoryboard(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "Native_AdVc") as! Native_AdVc
                //let nextVC = UIStoryboard(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "Native_Ad") as! Native_Ad
                nextVC.native_zoneId = zoneIdTf.text!
                self.navigationController?.pushViewController(nextVC, animated: false)
            }
            else if UserDefaults.standard.string(forKey: "selectedItem") == "Video Slider Ads"
            {
                let nextVC = UIStoryboard(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "VideoSliderViewController") as! VideoSliderViewController
                nextVC.videoSliderZoneId = zoneIdTf.text!
                self.navigationController?.pushViewController(nextVC, animated: false)
            }
            else if UserDefaults.standard.string(forKey: "selectedItem") == "South Radios Ads"
             {
                let nextVC = UIStoryboard(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "SouthRadiosAdViewController") as! SouthRadiosAdViewController
                nextVC.southRadiosZoneId = zoneIdTf.text!
                self.navigationController?.pushViewController(nextVC, animated: false)
             }
            */
//            adResponse.sdk_IntegrationMethods_RewardedVideo(zones: zoneIdTf.text!)
            adResponse.getUserDefaultValue(zones: self.zoneIdTf.text ?? "",str: "SDK")
            let nextVC = UIStoryboard(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "ViewController") as! ViewController
            nextVC.zoneId = zoneIdTf.text!
            self.navigationController?.pushViewController(nextVC, animated: false)
        }
    }
}
//MARK: - UITextField Delegate
extension UserInputVc: UITextFieldDelegate
{
    func textFieldDidEndEditing(_ textField: UITextField)
    {
        textField.resignFirstResponder()
    }
    func textFieldShouldReturn(_ textField: UITextField) -> Bool
    {
        textField.resignFirstResponder()
        if textField == zoneIdTf
        {
            textField.resignFirstResponder()
        }
        return true
    }
}
