//
//  InarticleAdVc.swift
//  Project_Demo
//
//  Created by Djax on 24/03/23.
//

import UIKit
import SDK_Lib
import AVKit
import AVFoundation
import GoogleInteractiveMediaAds
import WebKit

class InarticleAdVc: UIViewController {
    
    @IBOutlet weak var svView: UIScrollView!
    
    @IBOutlet weak var subView: UIView!
    @IBOutlet weak var subViewHtConstraint: NSLayoutConstraint!
    
    var adResponse = AdResponse()

    var zoneId_InarticleVideoAd : String = ""
    var zoneId : String = ""
    var fromPage : String = ""

    var videoUrl: URL?
    var player: AVPlayer?
    
    var playerViewController: AVPlayerViewController!
    var contentPlayhead: IMAAVPlayerContentPlayhead?
    var adsLoader: IMAAdsLoader!
    var adsManager: IMAAdsManager!
    
    let ContentURLString = "https://storage.googleapis.com/gvabox/media/samples/stock.mp4"
    //pre,post, and mid roll ad
    let AdTagURLString = "https://revphpe.djaxbidder.com/advancedsdk/www/admin/plugins/mobileAdsDelivery/vast3xml.php?zoneid=94&campaignid=8&bannerid=53&adtype='in-article'"
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.subView.isHidden = false
        self.subViewHtConstraint.constant = 200
        print(self.subView.frame)

        setUpContentPlayer()
        setUpAdsLoader()
        adResponse.adUpdateDelegate = self
//        adResponse.sdk_IntegrationMethods_InarticleVideo(zones: self.zoneId, fromStr: self.fromPage, view: self.subView)
    }
    override func viewDidAppear(_ animated: Bool) {
        requestAds()
    }
    func setUpContentPlayer() {
        // Load AVPlayer with path to your content.
        let contentURL = URL(string: "nil")!
        let player = AVPlayer(url: contentURL)
        playerViewController = AVPlayerViewController()
        playerViewController.player = player
        playerViewController.showsPlaybackControls = false

        // Set up your content playhead and contentComplete callback.
        contentPlayhead = IMAAVPlayerContentPlayhead(avPlayer: player)
        NotificationCenter.default.addObserver(
            self,
            selector: #selector(InarticleAdVc.contentDidFinishPlaying(_:)),
            name: NSNotification.Name.AVPlayerItemDidPlayToEndTime,
            object: player.currentItem);
        showContentPlayer()
    }
    func showContentPlayer() {
        self.addChild(playerViewController)
        playerViewController.view.frame = self.subView.bounds
        self.subView.insertSubview(playerViewController.view, at: 0)
        playerViewController.didMove(toParent:self)
    }
    func hideContentPlayer() {
        // The whole controller needs to be detached so that it doesn't capture  events from the remote.
        playerViewController.willMove(toParent:nil)
        playerViewController.view.removeFromSuperview()
        playerViewController.removeFromParent()
    }
    func setUpAdsLoader() {
        adsLoader = IMAAdsLoader(settings: nil)
        adsLoader.delegate = self
    }
    func requestAds() {
        // Create ad display container for ad rendering.
        let adDisplayContainer = IMAAdDisplayContainer(adContainer: self.subView, viewController: self)
        // Create an ad request with our ad tag, display container, and optional user context.
        let request = IMAAdsRequest(
            adTagUrl: AdTagURLString,
            adDisplayContainer: adDisplayContainer,
            contentPlayhead: contentPlayhead,
            userContext: nil)
        adsLoader.requestAds(with: request)
    }
    @objc func contentDidFinishPlaying(_ notification: Notification)
    {
        adsLoader.contentComplete()
    }
}
extension InarticleAdVc : AdDelegate {
    func passAPIvalues(point: Array<Dictionary<String, AnyObject>>) {
        
    }
    func updateView(viewLoad: UIView) {
        DispatchQueue.main.async {
            print(viewLoad.frame)
            self.subView.addSubview(viewLoad)
        }
    }
    func updateView1(viewLoad: AVPlayer) {
//        self.subView.isHidden = false
//        self.subViewHtConstraint.constant = 200
        DispatchQueue.main.async {
            viewLoad.play()
        }
    }
    
    func updateView(viewLoad_new: WKWebView) {
        
    }
    
    func updateDirectLinkAd(str: String) {
        
    }
    
    
}
extension InarticleAdVc : IMAAdsLoaderDelegate,IMAAdsManagerDelegate {
    func adsLoader(_ loader: IMAAdsLoader, failedWith adErrorData: IMAAdLoadingErrorData) {
        print("Error loading ads: " + adErrorData.adError.message!)
        showContentPlayer()
        playerViewController.player?.play()
    }
    func adsLoader(_ loader: IMAAdsLoader, adsLoadedWith adsLoadedData: IMAAdsLoadedData) {
        // Grab the instance of the IMAAdsManager and set yourself as the delegate.
        adsManager = adsLoadedData.adsManager
        adsManager.delegate = self
        adsManager.initialize(with: nil)
    }
    func adsManager(_ adsManager: IMAAdsManager, didReceive event: IMAAdEvent) {
        // Play each ad once it has been loaded
        if event.type == IMAAdEventType.LOADED {
            adsManager.start()
        }
        else if event.type == IMAAdEventType.COMPLETE {
        }
        else if event.type == IMAAdEventType.SKIPPED {
        }
    }
    func adsManager(_ adsManager: IMAAdsManager, didReceive error: IMAAdError) {
        // Fall back to playing content
        print("AdsManager error: " + error.message!)
        showContentPlayer()
        playerViewController.player?.play()
    }
    func adsManagerDidRequestContentPause(_ adsManager: IMAAdsManager) {
        // Pause the content for the SDK to play ads.
        playerViewController.player?.pause()
        hideContentPlayer()
    }
    func adsManagerDidRequestContentResume(_ adsManager: IMAAdsManager) {
        // Resume the content since the SDK is done playing ads (at least for now).
        showContentPlayer()
        playerViewController.player?.play()
    }
}
