//
//  BannerAd_Vc.swift
//  DemoApp
//
//  Created by Djax on 26/08/22.
//

import UIKit
import SDK_Lib
import WebKit

class BannerAd_Vc: UIViewController {

    @IBOutlet weak var svView: UIScrollView!
    @IBOutlet weak var bannerView1: WKWebView!
    @IBOutlet weak var bannerView2: WKWebView!
    @IBOutlet weak var txtLbl: UILabel!
    @IBOutlet weak var txtLbl1: UILabel!

    @IBOutlet weak var overallWebView: WKWebView!
    
    @IBOutlet weak var banner1WebHeightConstraint: NSLayoutConstraint?
    
    @IBOutlet weak var clickBtn: UIButton!
    @IBOutlet weak var clickBtnHeightConstraint: NSLayoutConstraint?

    var zoneId: String? = ""
    var strUrl:String? = ""
    var fromPage:String? = ""

    var adResponse = AdResponse()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.clickBtn.isHidden = true
        self.clickBtnHeightConstraint?.constant = 0
        //method 1
        //static design webview and pass
//        bannerView1?.addSubview(adResponse.sdk_IntegrationMethods_Banner(zones: zoneId ?? "",frame: bannerView1!.frame, fromStr: self.fromPage ?? ""))
//
//        //array append
//        arrayWeb.add(bannerView1!)
//        arrayWeb.add(bannerView2!)
        
        //method 2
        //create the height constraint for webview
        adResponse.adUpdateDelegate = self
        adResponse.sdk_IntegrationMethods_Banner_new(zones: zoneId ?? "",frame: bannerView1!.frame, fromStr: self.fromPage ?? "")
    }
}
extension BannerAd_Vc : AdDelegate {
    func updateDirectLinkAd(str: String) {
        self.clickBtn.isHidden = false
        self.clickBtnHeightConstraint?.constant = 35
        self.strUrl = str
        self.clickBtn.addTarget(self, action: #selector(redirectView), for: .touchUpInside)
    }
    @objc func redirectView() {
        if let url = URL(string: self.strUrl ?? "") {
              if #available(iOS 10, *){
                  UIApplication.shared.open(url)
              }else{
                  UIApplication.shared.openURL(url)
              }

          }
    }
    func passAPIvalues(point: Array<Dictionary<String, AnyObject>>) {}
    func updateView(viewLoad: UIView) {
        bannerView1?.addSubview(viewLoad)
    }
    func updateView(viewLoad_new: WKWebView) {
        banner1WebHeightConstraint?.constant = viewLoad_new.frame.size.height
        bannerView1?.addSubview(viewLoad_new)
    }
}
