<?php

namespace MongoDB\Tests\Command;

use MongoDB\Command\ListDatabases;
use MongoDB\Exception\InvalidArgumentException;
use MongoDB\Tests\TestCase;

class ListDatabasesTest extends TestCase
{
    /**
     * @dataProvider provideInvalidConstructorOptions
     */
    public function testConstructorOptionTypeChecks(array $options)
    {
        $this->expectException(InvalidArgumentException::class);
        new ListDatabases($options);
    }

    public function provideInvalidConstructorOptions()
    {
        $options = [];

        foreach ($this->getInvalidBooleanValues() as $value) {
            $options[][] = ['authorizedDatabases' => $value];
        }

        foreach ($this->getInvalidDocumentValues() as $value) {
            $options[][] = ['filter' => $value];
        }

        foreach ($this->getInvalidIntegerValues() as $value) {
            $options[][] = ['maxTimeMS' => $value];
        }

        foreach ($this->getInvalidBooleanValues() as $value) {
            $options[][] = ['nameOnly' => $value];
        }

        foreach ($this->getInvalidSessionValues() as $value) {
            $options[][] = ['session' => $value];
        }

        return $options;
    }
}
