<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set("error_log", "cron-error.log");

header('Access-Control-Allow-Origin: *');
require_once '/var/www/html/u/vendor/autoload.php';
require_once('config.php');
$GLOBALS['db'] = new DB();

try{
$GLOBALS['mdb'] = new MongoDB\Client("mongodb://".MONGOUSER.":".MONGOPASS."@".MONGOHOST.":".MONGOPORT."/?authSource=".MONGONAME);

   //~ $response = $GLOBALS['mdb']->getCollectionNames();
   //~ foreach ($response as $collection) {
   //~ echo "<pre>";
     //~ }

}catch (MongoConnectionException $e) {
header("HTTP/1.0 204");exit;
}
	
	
$start = gmdate("Y-m-d H:i:00", strtotime('-20 minutes', strtotime(date('Y-m-d H:i:s'))));

$end = gmdate("Y-m-d H:i:59", strtotime('-5 minutes', strtotime(date('Y-m-d H:i:s'))));

$date = gmdate('d_m_Y'); 

$start_time = gmdate("H:i:00", strtotime('-20 minutes', strtotime(date('H:i:s'))));

$end_time = gmdate("H:i:59", strtotime('-5 minutes', strtotime(date('H:i:s'))));

$st_time = explode(':', $start_time);
$time_hour = $st_time[0];

$ed_time = explode(':', $end_time);
$time_min = $ed_time[1];

if($time_min == '0' || $time_min == '00'){
    $time_min = 60;
    //$time_hour -= 1;
}



$ads_req_collection = "ads_request_".$date."_".$time_hour."_".$time_min;

$ads_win_collection = "ads_win_".$date."_".$time_hour."_".$time_min;

$ads_imp_collection = "ads_imp_".$date."_".$time_hour."_".$time_min;

$ads_clk_collection = "ads_clk_".$date."_".$time_hour."_".$time_min;

migrate($start, $end,$ads_req_collection, $ads_win_collection, $ads_imp_collection, $ads_clk_collection);


function migrate($start, $end, $ads_req_collection, $ads_win_collection, $ads_imp_collection, $ads_clk_collection)
{
	 
    $c = $GLOBALS['mdb']->$ads_req_collection;
	   $command = ([
        [
            '$match'=>[
                '$and'=>[
                    ["interval_start"=>[
                        '$gte'=>$start
                        ]
                    ],
                    ["interval_start"=>[
                        '$lte'=>$end
                        ]
                    ]
                ]
            ]
        ],
   ['$group' => ['_id' => ['exchange_id' => '$exchange_id','geo' => '$geos','device_os' => '$device_os','device_lan' => '$device_lan','device_ua' => '$device_ua','site_domain' => '$site_domain'], 'exchange_id' => ['$last' => '$exchange_id'], 'request_count' => ['$sum' => 1], 'response_count' => ['$sum' => '$response'], 'adid' => ['$last' => '$adid'], 'zoneid' => ['$last' => '$zoneid'], 'country' => ['$last' => '$geos'], 'os' => ['$last' => '$device_os'], 'lang' => ['$last' => '$device_lan'], 'ua' => ['$last' => '$device_ua'], 'domain' => ['$last' => '$site_domain'], 'device' => ['$last' => '$devicetype']], ], ]);
   $ops2 = [
                    'allowDiskUse' => true,
                ];
    $result = $c->aggregate($command,$ops2);
	
    if (!empty($result))
    {
        foreach ($result['result'] as $val => $val_key)
        {
        	$stat_ins = "Insert into djax_dsp_request_stats_mg (interval_start, request_count, response_count, adexchange,devicetype, win_count, clicks, impressions, total_revenue, dj_dsp_share,country,os,domain,lang,ua) values('" . $start . "','" . $val_key['request_count'] . "','" . $val_key['response_count'] . "','" . $val_key['exchange_id'] . "','" . $val_key['device'] . "','0','0','0','0','0','" . $val_key['country'] . "','" . $val_key['os'] . "','" . $val_key['domain'] . "','" . $val_key['lang'] . "','" . $val_key['ua'] . "')";
            $ins_stat_records = $GLOBALS['db']->query($stat_ins);
			
                                        
        } 
		  win_notice($start, $end, $ads_win_collection);
		  impressions($start, $end, $ads_imp_collection);
		  clicks($start, $end, $ads_clk_collection);
		 
          $c->drop();
      
    }
    
}

function win_notice($start, $end, $ads_win_collection)
{
	  
   
    $c = $GLOBALS['mdb']->$ads_win_collection;

     $command = ([
        [
            '$match'=>[
                 '$and'=>[
                    ["interval_start"=>[
                        '$gte'=>$start
                        ]
                    ],
                    ["interval_start"=>[
                        '$lte'=>$end
                        ]
                    ]
                ]
            ]
        ],
    ['$group' => ['_id' => ['exchange_id' => '$exchange_id','geo' => '$geos','device_os' => '$device_os','device_lan' => '$device_lan','device_ua' => '$device_ua','site_domain' => '$site_domain'], 'exchange_id' => ['$last' => '$exchange_id'],'win_count' => ['$sum' => 1], 'adid' => ['$last' => '$creative_id'], 'zoneid' => ['$last' => '$zone_id'], 'country' => ['$last' => '$geos'], 'os' => ['$last' => '$device_os'], 'lang' => ['$last' => '$device_lan'], 'ua' => ['$last' => '$device_ua'], 'domain' => ['$last' => '$site_domain'], 'device' => ['$last' => '$devicetype']], ], ]);
     $ops2 = [
                    'allowDiskUse' => true,
                ];
    $result = $c->aggregate($command,$ops2);
      

    if (!empty($result))
    {
        foreach ($result['result'] as $val => $val_key)
        {
          $stat_update ="UPDATE djax_dsp_request_stats_mg SET ad_id='" . $val_key['adid'] . "',zone_id='" . $val_key['zoneid'] . "',win_count='" . $val_key['win_count'] . "' WHERE  adexchange='" . $val_key['exchange_id'] . "'  AND country= '" . $val_key['country'] . "'  AND os='" .rawurlencode($val_key['os']) . "' AND domain='" . $val_key['domain'] . "' AND lang = '" . $val_key['lang'] . "' AND ua='" . $val_key['ua'] . "' AND interval_start='".$start."'  ";
         $ins_stat_records = $GLOBALS['db']->query($stat_update);  
        
        } 
        
         $c->drop();

    }
   
}
function impressions($start, $end, $ads_imp_collection)
{
	
  
    $c = $GLOBALS['mdb']->$ads_imp_collection;

     $command = ([
        [
            '$match'=>[
                 '$and'=>[
                    ["interval_start"=>[
                        '$gte'=>$start
                        ]
                    ],
                    ["interval_start"=>[
                        '$lte'=>$end
                        ]
                    ]
                ]
            ]
        ],
    ['$group' => ['_id' => ['exchange_id' => '$exchange_id','geo' => '$geos','device_os' => '$device_os','device_lan' => '$device_lan','device_ua' => '$device_ua','site_domain' => '$site_domain'], 'exchange_id' => ['$last' => '$exchange_id'],'imp' => ['$sum' => 1], 'win_bid' =>['$sum' => '$dj_win_bid'], 'dsp_share' =>['$sum' => '$dj_dsp_share'], 'adid' => ['$last' => '$creative_id'], 'zoneid' => ['$last' => '$zone_id'], 'country' => ['$last' => '$geos'], 'os' => ['$last' => '$device_os'], 'lang' => ['$last' => '$device_lan'], 'ua' => ['$last' => '$device_ua'], 'domain' => ['$last' => '$site_domain'], 'device' => ['$last' => '$devicetype']], ], ]);
     $ops2 = [
                    'allowDiskUse' => true,
                ];
    $result = $c->aggregate($command,$ops2);
 
   if (!empty($result))
    {
        foreach ($result['result'] as $val => $val_key)
        {
          $stat_update ="UPDATE djax_dsp_request_stats_mg SET impressions='" . $val_key['imp'] . "', total_revenue='".$val_key['win_bid']."', dj_dsp_share='".$val_key['dsp_share']."' WHERE ad_id='" . $val_key['adid'] . "' AND zone_id='" . $val_key['zoneid'] . "' AND adexchange='" . $val_key['exchange_id'] . "'  AND country= '" . $val_key['country'] . "'  AND os='" . rawurlencode($val_key['os']) . "' AND domain='" . $val_key['domain'] . "' AND lang = '" . $val_key['lang'] . "' AND ua='" . $val_key['ua'] . "' AND interval_start='".$start."'  ";
         $ins_stat_records = $GLOBALS['db']->query($stat_update); 
                          
        }
        $c->drop();
}
function clicks($start, $end, $ads_clk_collection)
{
    $c = $GLOBALS['mdb']->$ads_clk_collection;
     $command = ([
        [
            '$match'=>[
                 '$and'=>[
                    ["interval_start"=>[
                        '$gte'=>$start
                        ]
                    ],
                    ["interval_start"=>[
                        '$lte'=>$end
                        ]
                    ]
                ]
            ]
        ],
    ['$group' => ['_id' => ['exchange_id' => '$exchange_id','geo' => '$geos','device_os' => '$device_os','device_lan' => '$device_lan','device_ua' => '$device_ua','site_domain' => '$site_domain'], 'exchange_id' => ['$last' => '$exchange_id'], 'clk' => ['$sum' => 1], 'adid' => ['$last' => '$creative_id'], 'zoneid' => ['$last' => '$zone_id'], 'country' => ['$last' => '$geos'], 'os' => ['$last' => '$device_os'], 'lang' => ['$last' => '$device_lan'], 'ua' => ['$last' => '$device_ua'], 'domain' => ['$last' => '$site_domain'], 'device' => ['$last' => '$devicetype']], ], ]);
     $ops2 = [
                    'allowDiskUse' => true,
                ];
    $result = $c->aggregate($command,$ops2);
   
    if (!empty($result))
    {
        foreach ($result['result'] as $val => $val_key)
        {
          $stat_update ="UPDATE djax_dsp_request_stats_mg SET clicks='" . $val_key['clk'] . "' WHERE  ad_id='" . $val_key['adid'] . "' AND zone_id='" . $val_key['zoneid'] . "' AND adexchange='" . $val_key['exchange_id'] . "'  AND country= '" . $val_key['country'] . "'  AND os='" . rawurlencode($val_key['os']) . "' AND domain='" . $val_key['domain'] . "' AND lang = '" . $val_key['lang'] . "' AND ua='" . $val_key['ua'] . "' AND interval_start='".$start."'  ";
         $ins_stat_records = $GLOBALS['db']->query($stat_update);        
                
 
        }
         $c->drop(); 
      
    }
    
   
}



