<?php
header('Access-Control-Allow-Origin: *');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set("error_log", "cron-error.log");
require_once('config.php');
$GLOBALS['db'] = new DB();
try{
$m = new MongoClient('mongodb://' . MONGOHOST, array('username' => MONGOUSER, 'password' => MONGOPASS, 'db'=> MONGONAME ), array("socketTimeoutMS" => "180000"));
$GLOBALS['mdb'] = $m->{MONGONAME};
}catch (MongoConnectionException $e) {
header("HTTP/1.0 204");exit;
}
	
//$start = date("Y-m-d H:i:00", strtotime('-15 minutes', strtotime(date('Y-m-d H:i:s'))));
$start = "2020-11-23 11:23:06";
$end = date("Y-m-d H:i:59", strtotime('-1 minutes', strtotime(date('Y-m-d H:i:s'))));
migrate($start, $end);

function migrate($start, $end)
{

    $hourly_date_time = date('Y-m-d H:00:00');
    $c = $GLOBALS['mdb']->ads_request;
	   $command = ([
        [
            '$match'=>[
                '$and'=>[
                    ["interval_start"=>[
                        '$gte'=>$start
                        ]
                    ],
                    ["interval_start"=>[
                        '$lte'=>$end
                        ]
                    ]
                ]
            ]
        ],
    ['$group' => ['_id' => ['exchange_id' => '$exchange_id','geo' => '$geos','device_os' => '$device_os','device_lan' => '$device_lan','device_ua' => '$device_ua','site_domain' => '$site_domain'], 'exchange_id' => ['$last' => '$exchange_id'], 'request_count' => ['$sum' => 1], 'response_count' => ['$sum' => '$response'], 'adid' => ['$last' => '$adid'], 'zoneid' => ['$last' => '$zoneid'], 'country' => ['$last' => '$geos'], 'os' => ['$last' => '$device_os'], 'lang' => ['$last' => '$device_lan'], 'ua' => ['$last' => '$device_ua'], 'domain' => ['$last' => '$site_domain'], 'device' => ['$last' => '$devicetype']], ], ]);
    $result = $c->aggregate($command);
  
    if (!empty($result))
    {
        foreach ($result['result'] as $val => $val_key)
        {
			
				// Geographical stats for advertisers
				$stat_ins = "Insert into djax_geographical_stats_mg (date_time, requests, response, adexchange, win_notice, clicks, impressions,country,os,domain,lang,ua,ad_id,zone_id) values('" . $start . "','" . $val_key['request_count'] . "','" . $val_key['response_count'] . "','" . $val_key['exchange_id'] . "','0','0','0','" . $val_key['country'] . "','" . $val_key['os'] . "','" . $val_key['domain'] . "','" . $val_key['lang'] . "','" . $val_key['ua'] . "','" . $val_key['adid'] . "','" . $val_key['zoneid'] . "')";
				
                $ins_stat_records = $GLOBALS['db']->query($stat_ins);
                // SSP advanced reports for admin & ssp user panels
                $geo_stats_data = "INSERT INTO `djax_dsp_requests_geo_stats_mg`(
					`interval_start`, 
					`request_count`, 
					`response_count`, 
					`win_count`, 
					`delivery_media_type`,
					`country`,
					 `os`,
					 `domain`,
					 `lang`, 
					 `ua`, 
					 `impressions`, 
					 `clicks`, 
					 `dj_dsp_share`,
					 `adexchange`) 
					VALUES (
					'".$start."',
					'".$val_key['request_count']."',
					'".$val_key['response_count']."',
					'0',
					'".$val_key['device']."',
					'".$val_key['country']."',
					'".$val_key['os']."',
					'".$val_key['domain']."',
					'".$val_key['lang']."',
					'".$val_key['ua']."',
					'0',
					'0',
					'0',
					'".$val_key['exchange_id']."')";
					$ins_geo_analytics = $GLOBALS['db']->query($geo_stats_data);
				}
		} 
         win_notice($start, $end);
      impressions($start, $end);
      clicks($start, $end);
	$c->remove([ "interval_start"=>['$lte'=>$end]]);
      
}
function win_notice($start, $end)
{
  $hourly_date_time = date('Y-m-d H:00:00');
   
    $c = $GLOBALS['mdb']->ads_win;

     $command = ([
        [
            '$match'=>[
                 '$and'=>[
                    ["interval_start"=>[
                        '$gte'=>$start
                        ]
                    ],
                    ["interval_start"=>[
                        '$lte'=>$end
                        ]
                    ]
                ]
            ]
        ],
    ['$group' => ['_id' => ['exchange_id' => '$exchange_id','creative_id'=>'$creative_id','zone_id'=>'$zone_id','geo' => '$geos','device_os' => '$device_os','device_lan' => '$device_lan','device_ua' => '$device_ua','site_domain' => '$site_domain'], 'exchange_id' => ['$last' => '$exchange_id'],'win_count' => ['$sum' => 1], 'adid' => ['$last' => '$creative_id'], 'zoneid' => ['$last' => '$zone_id'], 'country' => ['$last' => '$geos'], 'os' => ['$last' => '$device_os'], 'lang' => ['$last' => '$device_lan'], 'ua' => ['$last' => '$device_ua'], 'domain' => ['$last' => '$site_domain'], 'device' => ['$last' => '$devicetype']], ], ]);
    $result = $c->aggregate($command);
      

    if (!empty($result))
    {
        foreach ($result['result'] as $val => $val_key)
        {
			
          $stat_update ="UPDATE djax_dsp_requests_geo_stats_mg SET ad_id='" . $val_key['adid'] . "',zone_id='" . $val_key['zoneid'] . "',win_count='" . $val_key['win_count'] . "' WHERE adexchange='" . $val_key['exchange_id'] . "'  AND country= '" . $val_key['country'] . "'  AND os='" .rawurlencode($val_key['os']) . "' AND domain='" . $val_key['domain'] . "' AND lang = '" . $val_key['lang'] . "' AND ua='" . $val_key['ua'] . "' AND interval_start='".$start."'  ";
        $ins_stat_records = $GLOBALS['db']->query($stat_update);  
          
         
        } 
     }
         
  
}

function impressions($start, $end)
{
  $hourly_date_time = date('Y-m-d H:00:00');
  
    $c = $GLOBALS['mdb']->ads_imp;

     $command = ([
        [
            '$match'=>[
                 '$and'=>[
                    ["interval_start"=>[
                        '$gte'=>$start
                        ]
                    ],
                    ["interval_start"=>[
                        '$lte'=>$end
                        ]
                    ]
                ]
            ]
        ],
     ['$group' => ['_id' => ['exchange_id' => '$exchange_id','creative_id'=>'$creative_id','zone_id'=>'$zone_id','geo' => '$geos','device_os' => '$device_os','device_lan' => '$device_lan','device_ua' => '$device_ua','site_domain' => '$site_domain'], 'exchange_id' => ['$last' => '$exchange_id'],'imp' => ['$sum' => 1], 'dsp_share' =>['$sum' => '$dj_dsp_share'], 'adid' => ['$last' => '$creative_id'], 'zoneid' => ['$last' => '$zone_id'], 'country' => ['$last' => '$geos'], 'os' => ['$last' => '$device_os'], 'lang' => ['$last' => '$device_lan'], 'ua' => ['$last' => '$device_ua'], 'domain' => ['$last' => '$site_domain'], 'device' => ['$last' => '$devicetype']], ], ]);
    $result = $c->aggregate($command);
   
   if (!empty($result))
    {
        foreach ($result['result'] as $val => $val_key)
        {
			$geo_stats_data = "UPDATE `djax_dsp_requests_geo_stats_mg` SET `impressions` ='" . $val_key['imp'] . "', dj_dsp_share='".$val_key['dsp_share']."' WHERE adexchange='" . $val_key['exchange_id'] . "'  AND country= '" . $val_key['country'] . "'  AND os='" . rawurlencode($val_key['os']) . "' AND domain='" . $val_key['domain'] . "' AND lang = '" . $val_key['lang'] . "' AND ua='" . $val_key['ua'] . "' AND interval_start='".$start."'  ";
			$ins_geo_analytics = $GLOBALS['db']->query($geo_stats_data);          
        } 
      }
}

function clicks($start, $end)
{
  $hourly_date_time = date('Y-m-d H:00:00');
 
    $c = $GLOBALS['mdb']->ads_clk;
     $command = ([
        [
            '$match'=>[
                 '$and'=>[
                    ["interval_start"=>[
                        '$gte'=>$start
                        ]
                    ],
                    ["interval_start"=>[
                        '$lte'=>$end
                        ]
                    ]
                ]
            ]
        ],
   ['$group' => ['_id' => ['exchange_id' => '$exchange_id','creative_id'=>'$creative_id','zone_id'=>'$zone_id','geo' => '$geos','device_os' => '$device_os','device_lan' => '$device_lan','device_ua' => '$device_ua','site_domain' => '$site_domain'], 'exchange_id' => ['$last' => '$exchange_id'], 'clk' => ['$sum' => 1],'adid' => ['$last' => '$creative_id'], 'zoneid' => ['$last' => '$zone_id'], 'country' => ['$last' => '$geos'], 'os' => ['$last' => '$device_os'], 'lang' => ['$last' => '$device_lan'], 'ua' => ['$last' => '$device_ua'], 'domain' => ['$last' => '$site_domain'], 'device' => ['$last' => '$devicetype']], ], ]);
    $result = $c->aggregate($command);
  
    if (!empty($result))
    {
        foreach ($result['result'] as $val => $val_key)
        {
                 
            // SSP advanced reports for admin & ssp user panels
		   $geo_stats_data = "UPDATE `djax_dsp_requests_geo_stats_mg` SET `clicks` ='" . $val_key['clk'] . "' WHERE adexchange='" . $val_key['exchange_id'] . "'  AND country= '" . $val_key['country'] . "'  AND os='" . rawurlencode($val_key['os']) . "' AND domain='" . $val_key['domain'] . "' AND lang = '" . $val_key['lang'] . "' AND ua='" . $val_key['ua'] . "' AND interval_start='".$start."'  ";
			$ins_geo_analytics = $GLOBALS['db']->query($geo_stats_data);        
 
        } 
         // $c->remove([ "interval_start"=>['$lte'=>$end]]);
      
    }
    
  
}

?>
 
