/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.GenericResponseBuilder;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractOpenApiResource
extends SpecFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOpenApiResource.class);
    final OpenAPIBuilder openAPIBuilder;
    private final AbstractRequestBuilder requestBuilder;
    private final GenericResponseBuilder responseBuilder;
    private final OperationBuilder operationParser;
    private final Optional<List<OpenApiCustomiser>> openApiCustomisers;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    protected final SpringDocConfigProperties springDocConfigProperties;
    private static final List<Class<?>> ADDITIONAL_REST_CONTROLLERS = new ArrayList();
    private static final List<Class<?>> HIDDEN_REST_CONTROLLERS = new ArrayList();
    private static final List<Class> DEPRECATED_TYPES = new ArrayList<Class>();
    private boolean computeDone;
    private final String groupName;

    protected AbstractOpenApiResource(String groupName, OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, GenericResponseBuilder responseBuilder, OperationBuilder operationParser, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties) {
        this.groupName = Objects.requireNonNull(groupName, "groupName");
        this.openAPIBuilder = openAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.openApiCustomisers = openApiCustomisers;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    protected synchronized OpenAPI getOpenApi() {
        OpenAPI openApi;
        if (!this.computeDone || this.springDocConfigProperties.getCache().isDisabled()) {
            Instant start = Instant.now();
            this.openAPIBuilder.build();
            Map<String, Object> restControllersMap = this.openAPIBuilder.getRestControllersMap();
            Map<String, Object> requestMappingMap = this.openAPIBuilder.getRequestMappingMap();
            Map<String, Object> controllerMap = this.openAPIBuilder.getControllersMap();
            Map<String, Object> restControllers = Stream.of(restControllersMap, requestMappingMap, controllerMap).flatMap(mapEl -> mapEl.entrySet().stream()).filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).filter(controller -> !this.isHiddenRestControllers(controller.getValue().getClass())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
            Map<String, Object> findControllerAdvice = this.openAPIBuilder.getControllerAdviceMap();
            this.responseBuilder.buildGenericResponse(this.openAPIBuilder.getComponents(), findControllerAdvice);
            this.getPaths(restControllers);
            openApi = this.openAPIBuilder.getCalculatedOpenAPI();
            this.openApiCustomisers.ifPresent(apiCustomisers -> apiCustomisers.forEach(openApiCustomiser -> openApiCustomiser.customise(openApi)));
            this.computeDone = true;
            this.removeBrokenReferenceDefinitions(openApi);
            this.openAPIBuilder.setCachedOpenAPI(openApi);
            this.openAPIBuilder.resetCalculatedOpenAPI();
            LOGGER.info("Init duration for springdoc-openapi is: {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
        } else {
            if (!this.openAPIBuilder.isServersPresent()) {
                this.openAPIBuilder.updateServers(this.openAPIBuilder.getCachedOpenAPI());
            }
            openApi = this.openAPIBuilder.getCachedOpenAPI();
        }
        return openApi;
    }

    protected abstract void getPaths(Map<String, Object> var1);

    protected void calculatePath(HandlerMethod handlerMethod, String operationPath, Set<RequestMethod> requestMethods) {
        OpenAPI openAPI = this.openAPIBuilder.getCalculatedOpenAPI();
        Components components = this.openAPIBuilder.getComponents();
        Paths paths = this.openAPIBuilder.getPaths();
        Map operationMap = null;
        if (paths.containsKey((Object)operationPath)) {
            PathItem pathItem = (PathItem)paths.get((Object)operationPath);
            operationMap = pathItem.readOperationsMap();
        }
        for (RequestMethod requestMethod : requestMethods) {
            Operation operation;
            Operation existingOperation = this.getExistingOperation(operationMap, requestMethod);
            Method method = handlerMethod.getMethod();
            if (this.operationParser.isHidden(method)) continue;
            RequestMapping reqMappingClass = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)handlerMethod.getBeanType(), RequestMapping.class);
            MethodAttributes methodAttributes = new MethodAttributes(this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType());
            methodAttributes.setMethodOverloaded(existingOperation != null);
            if (reqMappingClass != null) {
                methodAttributes.setClassConsumes(reqMappingClass.consumes());
                methodAttributes.setClassProduces(reqMappingClass.produces());
            }
            methodAttributes.calculateConsumesProduces(method);
            Operation operation2 = operation = existingOperation != null ? existingOperation : new Operation();
            if (this.isDeprecatedType(method)) {
                operation.setDeprecated(Boolean.valueOf(true));
            }
            io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, io.swagger.v3.oas.annotations.Operation.class);
            this.calculateJsonView(apiOperation, methodAttributes, method);
            if (apiOperation != null) {
                openAPI = this.operationParser.parse(components, apiOperation, operation, openAPI, methodAttributes);
            }
            operation = this.openAPIBuilder.buildTags(handlerMethod, operation, openAPI);
            RequestBody requestBodyDoc = (RequestBody)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestBody.class);
            this.requestBuilder.getRequestBodyBuilder().buildRequestBodyFromDoc(requestBodyDoc, methodAttributes.getClassConsumes(), methodAttributes.getMethodConsumes(), components, methodAttributes.getJsonViewAnnotationForRequestBody()).ifPresent(arg_0 -> ((Operation)operation).setRequestBody(arg_0));
            operation = this.requestBuilder.build(components, handlerMethod, requestMethod, operation, methodAttributes, openAPI);
            ApiResponses apiResponses = this.responseBuilder.build(components, handlerMethod, operation, methodAttributes);
            operation.setResponses(apiResponses);
            Set apiCallbacks = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)method, Callback.class);
            if (!CollectionUtils.isEmpty((Collection)apiCallbacks)) {
                this.operationParser.buildCallbacks(apiCallbacks, components, openAPI, methodAttributes).ifPresent(arg_0 -> ((Operation)operation).setCallbacks(arg_0));
            }
            PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
            paths.addPathItem(operationPath, pathItemObject);
        }
    }

    private void calculateJsonView(io.swagger.v3.oas.annotations.Operation apiOperation, MethodAttributes methodAttributes, Method method) {
        JsonView jsonViewAnnotationForRequestBody;
        JsonView jsonViewAnnotation;
        if (apiOperation != null && apiOperation.ignoreJsonView()) {
            jsonViewAnnotation = null;
            jsonViewAnnotationForRequestBody = null;
        } else {
            jsonViewAnnotation = (JsonView)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, JsonView.class);
            jsonViewAnnotationForRequestBody = (JsonView)Arrays.stream(ReflectionUtils.getParameterAnnotations((Method)method)).filter(arr -> Arrays.stream(arr).anyMatch(annotation -> annotation.annotationType().equals(RequestBody.class) || annotation.annotationType().equals(org.springframework.web.bind.annotation.RequestBody.class))).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(JsonView.class)).reduce((a, b) -> null).orElse((Annotation)jsonViewAnnotation);
        }
        methodAttributes.setJsonViewAnnotation(jsonViewAnnotation);
        methodAttributes.setJsonViewAnnotationForRequestBody(jsonViewAnnotationForRequestBody);
    }

    private Operation getExistingOperation(Map<PathItem.HttpMethod, Operation> operationMap, RequestMethod requestMethod) {
        Operation existingOperation = null;
        if (!CollectionUtils.isEmpty(operationMap)) {
            switch (requestMethod) {
                case GET: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.GET);
                    break;
                }
                case POST: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.POST);
                    break;
                }
                case PUT: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.PUT);
                    break;
                }
                case DELETE: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.DELETE);
                    break;
                }
                case PATCH: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.PATCH);
                    break;
                }
                case HEAD: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.HEAD);
                    break;
                }
                case OPTIONS: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.OPTIONS);
                    break;
                }
            }
        }
        return existingOperation;
    }

    private PathItem buildPathItem(RequestMethod requestMethod, Operation operation, String operationPath, Paths paths) {
        PathItem pathItemObject = paths.containsKey((Object)operationPath) ? (PathItem)paths.get((Object)operationPath) : new PathItem();
        switch (requestMethod) {
            case POST: {
                pathItemObject.post(operation);
                break;
            }
            case GET: {
                pathItemObject.get(operation);
                break;
            }
            case DELETE: {
                pathItemObject.delete(operation);
                break;
            }
            case PUT: {
                pathItemObject.put(operation);
                break;
            }
            case PATCH: {
                pathItemObject.patch(operation);
                break;
            }
            case TRACE: {
                pathItemObject.trace(operation);
                break;
            }
            case HEAD: {
                pathItemObject.head(operation);
                break;
            }
            case OPTIONS: {
                pathItemObject.options(operation);
                break;
            }
        }
        return pathItemObject;
    }

    protected boolean isPackageToScan(String aPackage) {
        Optional<SpringDocConfigProperties.GroupConfig> optionalGroupConfig;
        List<String> packagesToScan = this.springDocConfigProperties.getPackagesToScan();
        List<String> packagesToExclude = this.springDocConfigProperties.getPackagesToExclude();
        if (CollectionUtils.isEmpty(packagesToScan) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            packagesToScan = optionalGroupConfig.get().getPackagesToScan();
        }
        if (CollectionUtils.isEmpty(packagesToExclude) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            packagesToExclude = optionalGroupConfig.get().getPackagesToExclude();
        }
        boolean include = CollectionUtils.isEmpty(packagesToScan) || packagesToScan.stream().anyMatch(pack -> aPackage.equals(pack) || aPackage.startsWith(pack + "."));
        boolean exclude = !CollectionUtils.isEmpty(packagesToExclude) && packagesToExclude.stream().anyMatch(pack -> aPackage.equals(pack) || aPackage.startsWith(pack + "."));
        return include && !exclude;
    }

    protected boolean isPathToMatch(String operationPath) {
        Optional<SpringDocConfigProperties.GroupConfig> optionalGroupConfig;
        List<String> pathsToMatch = this.springDocConfigProperties.getPathsToMatch();
        List<String> pathsToExclude = this.springDocConfigProperties.getPathsToExclude();
        if (CollectionUtils.isEmpty(pathsToMatch) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            pathsToMatch = optionalGroupConfig.get().getPathsToMatch();
        }
        if (CollectionUtils.isEmpty(pathsToExclude) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            pathsToExclude = optionalGroupConfig.get().getPathsToExclude();
        }
        boolean include = CollectionUtils.isEmpty(pathsToMatch) || pathsToMatch.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, operationPath));
        boolean exclude = !CollectionUtils.isEmpty(pathsToExclude) && pathsToExclude.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, operationPath));
        return include && !exclude;
    }

    protected String decode(String requestURI) {
        try {
            return URLDecoder.decode(requestURI, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return requestURI;
        }
    }

    protected boolean isAdditionalRestController(Class<?> rawClass) {
        return ADDITIONAL_REST_CONTROLLERS.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    public static void addRestControllers(Class<?> ... classes) {
        ADDITIONAL_REST_CONTROLLERS.addAll(Arrays.asList(classes));
    }

    public static void addHiddenRestControllers(Class<?> ... classes) {
        HIDDEN_REST_CONTROLLERS.addAll(Arrays.asList(classes));
    }

    protected boolean isHiddenRestControllers(Class<?> rawClass) {
        return HIDDEN_REST_CONTROLLERS.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    protected Set getDefaultAllowedHttpMethods() {
        RequestMethod[] allowedRequestMethods = new RequestMethod[]{RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.OPTIONS, RequestMethod.HEAD};
        return new HashSet<RequestMethod>(Arrays.asList(allowedRequestMethods));
    }

    public static void addDeprecatedType(Class<?> cls) {
        DEPRECATED_TYPES.add(cls);
    }

    private boolean isDeprecatedType(Method method) {
        return DEPRECATED_TYPES.stream().anyMatch(clazz -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, (Class)clazz) != null);
    }

    static {
        DEPRECATED_TYPES.add(Deprecated.class);
    }
}

