/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.availability;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

public class ApplicationAvailabilityBean
implements ApplicationAvailability,
ApplicationListener<AvailabilityChangeEvent<?>> {
    private static final Log logger = LogFactory.getLog(ApplicationAvailabilityBean.class);
    private final Map<Class<? extends AvailabilityState>, AvailabilityChangeEvent<?>> events = new HashMap();

    @Override
    public <S extends AvailabilityState> S getState(Class<S> stateType, S defaultState) {
        Assert.notNull(stateType, (String)"StateType must not be null");
        Assert.notNull(defaultState, (String)"DefaultState must not be null");
        S state = this.getState(stateType);
        return state != null ? state : defaultState;
    }

    @Override
    public <S extends AvailabilityState> S getState(Class<S> stateType) {
        AvailabilityChangeEvent<S> event = this.getLastChangeEvent(stateType);
        return event != null ? (S)event.getState() : null;
    }

    @Override
    public <S extends AvailabilityState> AvailabilityChangeEvent<S> getLastChangeEvent(Class<S> stateType) {
        return this.events.get(stateType);
    }

    public void onApplicationEvent(AvailabilityChangeEvent<?> event) {
        this.logStateChange(event);
        Class<? extends AvailabilityState> stateType = this.getStateType((AvailabilityState)event.getState());
        this.events.put(stateType, event);
    }

    private void logStateChange(AvailabilityChangeEvent<?> event) {
        if (logger.isInfoEnabled()) {
            StringBuilder message = this.createStateChangeMessage(event);
            logger.info((Object)message);
        }
    }

    private StringBuilder createStateChangeMessage(AvailabilityChangeEvent<?> event) {
        Class<? extends AvailabilityState> stateType = this.getStateType((AvailabilityState)event.getState());
        StringBuilder message = new StringBuilder("Application availability state " + stateType.getSimpleName() + " changed");
        AvailabilityChangeEvent<? extends AvailabilityState> lastChangeEvent = this.getLastChangeEvent(stateType);
        if (lastChangeEvent != null) {
            message.append(" from " + lastChangeEvent.getState());
        }
        message.append(" to " + event.getState());
        Object source = event.getSource();
        if (source != null) {
            if (source instanceof Throwable) {
                message.append(": " + source);
            } else if (!(source instanceof ApplicationEventPublisher)) {
                message.append(": " + source.getClass().getName());
            }
        }
        return message;
    }

    private Class<? extends AvailabilityState> getStateType(AvailabilityState state) {
        if (state instanceof Enum) {
            return ((Enum)((Object)state)).getDeclaringClass();
        }
        return state.getClass();
    }
}

