<?php 
require_once '../../../../init.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
require_once LIB_PATH . '/Plugin/PluginManager.php';
require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN,OA_ACCOUNT_MANAGER);
$aErrormessage = array();
$oOptions = new OA_Admin_Option('settings');
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel("VAST Error Report");
phpAds_PageHeader('error-index', $oHeaderModel);

$_period = !empty($_POST['period_preset']) ? $_POST['period_preset'] : '';
if($_POST['period_preset']!=''){
	if($_POST['period_preset']=='today'){
		$startdate=date("Y-m-d 00:00:00");//$date=date("Y-m-d H:00:00");
		$endate=date("Y-m-d H:00:00");	
	} else if($_POST['period_preset']=='yesterday'){
		$startdate=date('Y-m-d 00:00:00', strtotime('Yesterday'));
		$endate=date('Y-m-d 23:59:59', strtotime('Yesterday'));
	} else if($_POST['period_preset']=='last_7_days'){
		$startdate=date('Y-m-d 00:00:00', strtotime('Today - 7 Day'));
		$endate=date('Y-m-d 23:59:59', strtotime('Today - 1 Day'));
	} else if($_POST['period_preset']=='this_month'){
		$startdate=date('Y-m-d 00:00:00', mktime(0, 0, 0, date('m'), 1, date('Y')));
		$endate=date('Y-m-d 23:59:59');
	} else if($_POST['period_preset']=='last_month'){
		$startdate=date('Y-m-d 00:00:00', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
		$endate=date('Y-m-d 23:59:59', mktime(0, 0, 0, date('m'), 0, date('Y')));
	} else if($_POST['period_preset']=='all_stats')	{
		$startdate=date("0000-00-00 00:00:00");
		$endate=date("Y-m-d H:00:00");
	} else if($_POST['period_preset']=='specific') {		
		$startdate=$_POST['period_start'];
		$endate=$_POST['period_end'];
	}
} else {
	$startdate=date("Y-m-d 00:00:00");//$date=date("Y-m-d H:00:00");
	$endate=date("Y-m-d 23:59:59");
}/*Convert start date and end date into timezone format*/
if($period_preset=='all_stats' || $_POST['period_preset']=='all_stats'){
	$start_date="0000-00-00 00:00:00";
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
} else if($startdate=='' && $endate=='') { 
	$start_day=new Date(date('Y-m-d H:i:00'));
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
} else {
	$end_day=new Date($endate);
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');

	$start_day=new Date($startdate);
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
}
	/* Time Zone Ends */

	$summarytable=OA_Dal_Delivery_query("SELECT zone_id,error_id,sum(count) as count,date(interval_start) as date FROM djax_error_log where date(interval_start) between '$startdate' and '$endate' GROUP BY DATE(interval_start),zone_id,error_id order by interval_start desc");
	$totalstats=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT sum(count) as errcount FROM djax_error_log where date(interval_start) between '$startdate' and '$endate'"));
?>
<form method='post'>
    <select name='period_preset' id='period_preset' onchange='periodFormChange(1)' tabindex='1'>
		<option value='today' selected='selected'>Today</option>
		<option value='yesterday' <?php if($_period == "yesterday") : ?> selected="selected" <?php endif; ?> >Yesterday</option>
		<option value='last_7_days' <?php if($_period == "last_7_days") : ?> selected="selected" <?php endif; ?> >Last 7 days</option>
		<option value='this_month' <?php if($_period == "this_month") : ?> selected="selected" <?php endif; ?> >This month</option>
		<option value='last_month' <?php if($_period == "last_month") : ?> selected="selected" <?php endif; ?> >Last month</option>
		<option value='all_stats' <?php if($_period == "all_stats") : ?> selected="selected" <?php endif; ?> >All statistics</option>
		<option value='specific' <?php if($_period == "specific") : ?> selected="selected" <?php endif; ?> >Specific dates</option>
    </select>
    <label for='period_start' style='margin-left: 1em'></label>
    <input class="date" name="period_start" id="period_start" type="text" value="<?php  if(!empty($start_date)){ echo $start_date;}else{ echo date('Y-m-d');}?>" tabindex="2"/>
    <input type='image' src='../../assets/images/icon-calendar-d.gif' id='period_start_button' align='absmiddle' border='0' tabindex='3' />
    <label for='period_end' style='margin-left: 1em'> </label>
    <input class="date" name="period_end" id="period_end" type="text" value="<?php if(!empty($endate)){ echo $endate;}else{ echo date('Y-m-d');} ?>" tabindex="4" /> 
	<input type='image' src='../../assets/images/icon-calendar-d.gif' id='period_end_button' align='absmiddle' border='0' tabindex='3' />
	<a href='' onclick='return periodFormSubmit()'>
    <img src='../../assets/images/ltr/go_blue.gif' border='0' tabindex='6' /></a>
</form>
<style type="text/css">
	table.gridtable {
		font-family: verdana,arial,sans-serif;
		font-size:11px;
		color:#333333;
		border-width: 1px;
		width: 100%;
		border-color: #999999;
		border-collapse: collapse;
	}
	table.gridtable th {
		
		border-width: 1px;
		padding: 8px;
		border-style: solid;
		border-color: #999999;
	}
	table.gridtable td {
		
		border-width: 1px;
		padding: 8px;
		border-style: solid;
		border-color: #999999;
	}
</style>
<?php
if(OA_Dal_Delivery_numRows($summarytable)>0){
?>
<link rel="stylesheet" type="text/css" href="../../assets/min.php?g=oxp-css-ltr&v=2.8.10">
<table width="100%" class="table">
     <tr>
		<th scope="col" class="aleft" style="color: #0767A8;">Date</th>
		<th scope="col" class="aleft" style="color: #0767A8;">Zone ID</th>
        <th scope="col" class="aleft" style="color: #0767A8;">Error Code</th>    
        <th scope="col" class="aleft" style="color: #0767A8;">Error Count</th>            
	</tr> 
<?php
	$recordedexchange=array();
	while($summarydata=OA_Dal_Delivery_fetchAssoc($summarytable)){
?>
	<tr>
		<td><?=  $summarydata['date'];?></td>		
		<td><?=  $summarydata['zone_id'];?></td>		
		<td>
			<?php  
				$eid = $summarydata['error_id'];
				$err_query=OA_Dal_Delivery_query("SELECT description FROM djax_error_code where code = {$eid}");
				$row=OA_Dal_Delivery_fetchAssoc($err_query);
				echo $row['description'];
			?>
		</td>		
		<td><?=  $summarydata['count'];?></td>
	</tr>		

<?php
	}
	if(!empty($totalstats['errcount'])){
?>
	<tr>
		<td class="aleft dark"><b>Total</b></td>
		<td class="aleft dark"><b></b></td>
		<td class="aleft dark"><b></b></td>
		<?php if($totalstats['errcount']==0){ ?><td class="aleft dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aleft dark" ><b><?php echo $totalstats['errcount']; ?></b></td>
		<?php }?>
	</tr>		
<?php
	}
}
else{
	echo '<div style="margin-top: 2em;" class="errormessage"><img border="0" align="absmiddle" width="16" height="16" src="../../assets/images/info.gif" class="errormessage">There are currently no statistics available for the period '.$startdate.' to '.$endate.'</div>';
}
?>
<script type='text/javascript'>
	Calendar.setup({
		inputField : 'period_start',
		ifFormat   : '%Y-%m-%d',
		button     : 'period_start_button',
		align      : 'Bl',
		weekNumbers: false,
		firstDay   : 1,
		electric   : false
	});
	Calendar.setup({
		inputField : 'period_end',
		ifFormat   : '%Y-%m-%d',
		button     : 'period_end_button',
		align      : 'Bl',
		weekNumbers: false,
		firstDay   : 1,
		electric   : false
	});
	function periodFormChange(bAutoSubmit){
 	    var o = document.getElementById('period_preset');
        var periodSelectName = o.options[o.selectedIndex].value;
        var specific = periodSelectName == 'specific';
    	var advertiser = periodSelectName == 'advertiser';
 	    var periodTabIndex = 2;
	    document.getElementById('period_start').readOnly = !specific;
        document.getElementById('period_start_button').disabled = !specific;
        document.getElementById('period_end').readOnly = !specific;
        document.getElementById('period_end_button').disabled = !specific;
		document.getElementById('period_start').style.backgroundColor = '#FFFFFF';
		document.getElementById('period_end').style.backgroundColor = '#FFFFFF';
		document.getElementById('period_start').tabIndex = periodTabIndex;
		document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
		document.getElementById('period_end').tabIndex = periodTabIndex + 2;
		document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
	    document.getElementById('period_start_button').src = '../../assets/images/icon-calendar.gif';
        document.getElementById('period_end_button').src = '../../assets/images/icon-calendar.gif' ;
        document.getElementById('period_start_button').readOnly = !specific;
        document.getElementById('period_end_button').readOnly = !specific;          
        document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
        document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';         
	}
	periodFormChange(0);
    function periodFormSubmit() {
		var form = document.getElementById('period_preset').form;
		if (checkDates(form)) {
		  form.submit();
		}
		return false;
    }
    function checkDates(form){
		var startField = form.period_start;
		var endField = form.period_end;

		if (!startField.disabled && startField.value != '') {
			var start = Date.parseDate(startField.value, '%Y-%m-%d');
		}		
		if (!startField.disabled && endField.value != '') {
			var end = Date.parseDate(endField.value, '%Y-%m-%d');
		}
		return true;
    }
</script>
<?php
	phpAds_PageFooter();
?>
