package sspstructure

import "github.com/mxmCherry/openrtb/adcom1"

/****************RTB Request start**************/
type SSP_Req struct {
	Id          string           `json:"id"`
	At          int64            `json:"at"`
	DSP         []DSP_Obj        `json:"dsp"`
	Tmax        int64            `json:"tmax"`
	Cur         []string         `json:"cur"`
	Imp         []IMP_Obj        `json:"imp"`
	Device      Device_Obj       `json:"device"`
	Site        SiteObj          `json:"site"`
	Test        int8             `json:"test"`
	Restriction Restrictions_Obj `json:"restriction"`
	Reg         Regex            `json:"reg"`
	User        User_Obj         `json:"user"`
	Source      *SourceExt       `json:"source"`
}

type SiteObj struct {
	Id        string   `json:"id,omitempty"`
	Name      string   `json:"name,omitempty"`
	Domain    string   `json:"domain,omitempty"`
	Publisher Site_pub `json:"pub"`
}

type Site_pub struct {
	Id     string `json:"id"`
	Name   string `json:"name"`
	Domain string `json:"domain"`
}

type DSP_Obj struct {
	Id       int      `json:"id"`
	Ver      string   `json:"ver"`
	End_Url  string   `json:"end_url"`
	At       int64    `json:"at"`
	Cur      []string `json:"cur"`
	Source   string   `json:"source"`
	Buyer_id string   `json:"buyer_id"`
}

type IMP_Obj struct {
	Id           string      `json:"id"`
	Banner       *Banner_Obj `json:"banner,omitempty"`
	Video        *Video_Obj  `json:"video,omitempty"`
	Pmp          PMP_obj     `json:"pmp"`
	BidFloor     float64     `json:"bidfloor"`
	TagId        string      `json:"tagid"`
	Interstitial int8        `json:"instl"`
}

type Banner_Obj struct {
	Width  *int64   `json:"w"`
	Height *int64   `json:"h"`
	Mimes  []string `json:"mimes"`
}
type Video_Obj struct {
	Width          int64                         `json:"w"`
	Height         int64                         `json:"h"`
	Mimes          []string                      `json:"mimes"`
	MaxDuration    int64                         `json:"maxduration"`
	MaxBitrate     int64                         `json:"maxbitrate"`
	APi            []adcom1.APIFramework         `json:"api"`
	Placement      adcom1.VideoPlacementSubtype  `json:"placement"`
	Protocol       []adcom1.MediaCreativeSubtype `json:"protocols"`
	PlaybackMethod []adcom1.PlaybackMethod       `json:"playbackmethod"`
}
type PMP_obj struct {
	Private_Auction int     `json:"private_auction"`
	Deal            []Deals `json:"deals"`
}
type Deals struct {
	DealId string   `json:"dealid"`
	Wseat  []string `json:"wseat"`
}

type Device_Obj struct {
	DNT        *int8             `json:"dnt"`
	UA         string            `json:"ua"`
	IP         string            `json:"ip"`
	Make       string            `json:"make"`
	Model      string            `json:"model"`
	DeviceType adcom1.DeviceType `json:"devicetype"`
	OS         string            `json:"os"`
	OSV        string            `json:"osv"`
	Geo        Geo_Obj           `json:"geo"`
}

type Restrictions_Obj struct {
	Badv []string `json:"badv"`
	Bcat []string `json:"bcat"`
	Bapp []string `json:"bapp"`
}

type Regex struct {
	COPPA int8 `json:"coppa"`
}

type Geo_Obj struct {
	Latitude  float64             `json:"lat"`
	Longitude float64             `json:"lon"`
	Type      adcom1.LocationType `json:"type"`
	Country   string              `json:"country"`
}

type User_Obj struct {
	Buyeruid string `json:"buyeruid"`
}

/*****************RTB Request End*******************/

/**********Supply chain struct****************/
type SourceExt struct {
	Ext *SupplychainPrebid `json:"ext"`
}
type SupplychainPrebid struct {
	Schain *Schain `json:"schain,omitempty"`
}
type Schain struct {
	Validation string         `json:"validation,omitempty"`
	Config     *Configuration `json:"config,omitempty"`
}

type Configuration struct {
	Version  string   `json:"ver,omitempty"`
	Complete int      `json:"complete,omitempty"`
	Node     []*Nodes `json:"nodes,omitempty"`
}

type Nodes struct {
	ASI string `json:"asi,omitempty"`
	SID string `json:"sid,omitempty"`
	HP  int    `json:"hp,omitempty"`
}

/**********Supply chain struct****************/
