package ssphandler

import (
	"encoding/json"
	"net/http"
	"ssp/ad"
	"ssp/sspstructure"
)

func Home(w http.ResponseWriter, r *http.Request) {
	html := `<html>
		<head>
			<title>Admaru SSP Ad Delivery Server</title>
		</head>
		<body>
			<h1>Admaru SSP Server Started</h1>
		</body>
	</html>`
	w.Write([]byte(html))
}

func ProcessReq(w http.ResponseWriter, r *http.Request) {

	ReqArray := &sspstructure.SSP_Req{}
	ResArray := make(map[string]interface{})

	w.Header().Add("Content-Type", "application/json")

	err := json.NewDecoder(r.Body).Decode(&ReqArray)
	if err != nil {
		ResArray["message"] = "Request Error"
		w.WriteHeader(http.StatusBadRequest)
		json.NewEncoder(w).Encode(ReqArray)
		return
	}

	ResArray, err = GetAd(ReqArray)

	if err != nil {
		ResArray["message"] = err.Error()
		w.WriteHeader(http.StatusBadRequest)
		json.NewEncoder(w).Encode(ResArray)
		return
	} else {
		w.WriteHeader(http.StatusOK)
		json.NewEncoder(w).Encode(ResArray)
		return
	}

}

func GetAd(ReqArray *sspstructure.SSP_Req) (map[string]interface{}, error) {
	Channel := make(chan map[string]interface{})
	ResponseArray := make(map[string]interface{})

	go ad.SSPAdProcess(Channel, ReqArray)
	ResponseArray = <-Channel

	return ResponseArray, nil
}
