package rtbrequest25

import (
	"ssp/sspstructure"

	openrtb2 "github.com/mxmCherry/openrtb/openrtb2"
)

func RtbObjectCreator(channel chan *openrtb2.BidRequest, ssp_req *sspstructure.SSP_Req) {

	Bidrequest := &openrtb2.BidRequest{}
	Bidrequest.ID = ssp_req.Id
	Bidrequest.AT = ssp_req.At
	Bidrequest.Test = ssp_req.Test
	Bidrequest.Cur = append(Bidrequest.Cur, ssp_req.Cur...)
	Bidrequest.Imp = make([]openrtb2.Imp, len(ssp_req.Imp))
	for k, v := range ssp_req.Imp {
		Bidrequest.Imp[k].ID = v.Id
		Bidrequest.Imp[k].TagID = v.TagId
		Bidrequest.Imp[k].BidFloor = v.BidFloor
		Bidrequest.Imp[k].Instl = v.Interstitial
		if v.Banner != nil {
			/******Banner Obj start********/
			var ban openrtb2.Banner
			ban.MIMEs = v.Banner.Mimes
			ban.W = v.Banner.Width
			ban.H = v.Banner.Height
			Bidrequest.Imp[k].Banner = &ban
			/******Banner Obj end********/
		}

		if v.Video != nil {
			/******Video Obj start*********/
			var vid openrtb2.Video
			vid.W = v.Video.Width
			vid.H = v.Video.Height
			vid.MinBitRate = v.Video.MaxBitrate
			vid.MaxDuration = v.Video.MaxDuration
			vid.API = v.Video.APi
			vid.Placement = v.Video.Placement
			vid.Protocols = append(vid.Protocols, v.Video.Protocol...)
			vid.PlaybackMethod = v.Video.PlaybackMethod
			vid.MIMEs = v.Video.Mimes
			Bidrequest.Imp[k].Video = &vid
			/******Video Obj end*********/
		}

		/******PMP Obj start********/
		var pmp openrtb2.PMP
		pmp.PrivateAuction = int8(v.Pmp.Private_Auction)
		if len(v.Pmp.Deal) > 0 && v.Pmp.Private_Auction != 0 {
			pmp.Deals = make([]openrtb2.Deal, len(v.Pmp.Deal))
			for k1, v1 := range v.Pmp.Deal {
				pmp.Deals[k1].ID = v1.DealId
				pmp.Deals[k1].WSeat = v1.Wseat
			}
			Bidrequest.Imp[k].PMP = &pmp
		}

		/******PMP Obj end********/
	}
	if ssp_req.Site.Id != "" {
		var siteobj openrtb2.Site
		var Publisher openrtb2.Publisher
		siteobj.ID = ssp_req.Site.Id
		siteobj.Name = ssp_req.Site.Name
		if ssp_req.Site.Publisher.Id != "" {
			Publisher.ID = ssp_req.Site.Publisher.Id
			Publisher.Name = ssp_req.Site.Publisher.Name
			Publisher.Domain = ssp_req.Site.Publisher.Domain
			siteobj.Publisher = &Publisher
		}
		Bidrequest.Site = &siteobj
	}

	/******Device Obj start********/
	var device openrtb2.Device
	var geo openrtb2.Geo
	device.DNT = ssp_req.Device.DNT
	device.UA = ssp_req.Device.UA
	device.IP = ssp_req.Device.IP
	device.Make = ssp_req.Device.Make
	device.Model = ssp_req.Device.Model
	device.DeviceType = ssp_req.Device.DeviceType
	device.OS = ssp_req.Device.OS
	device.OSV = ssp_req.Device.OSV
	geo.Type = ssp_req.Device.Geo.Type
	geo.Country = ssp_req.Device.Geo.Country
	device.Geo = &geo
	Bidrequest.Device = &device
	/******Device Obj end********/

	/******User Obj start********/
	var user openrtb2.User
	user.BuyerUID = ssp_req.User.Buyeruid
	Bidrequest.User = &user
	/******User Obj end********/

	/******Reg Obj start********/
	var reg openrtb2.Regs
	reg.COPPA = ssp_req.Reg.COPPA
	Bidrequest.Regs = &reg
	/******Reg Obj end********/

	/******Restriction Obj start********/

	if len(ssp_req.Restriction.Badv) != 0 {
		Bidrequest.BAdv = ssp_req.Restriction.Badv
	}
	if len(ssp_req.Restriction.Bapp) != 0 {
		Bidrequest.BApp = ssp_req.Restriction.Bapp
	}
	if len(ssp_req.Restriction.Bcat) != 0 {
		Bidrequest.BCat = ssp_req.Restriction.Bcat
	}

	/******Restriction Obj end********/
	channel <- Bidrequest

}
