package curl

import (
	"fmt"
	"io/ioutil"
	"net/http"
	"strings"
	"time"
)

func SendReq(curlchan chan<- []byte, jsonReq []byte, pingUrl string, version string, tmax int64) {

	var (
		req *http.Request
		err error
	)

	method := "POST"

	payload := strings.NewReader(string(jsonReq))

	req, err = http.NewRequest(method, pingUrl, payload)
	req.Header.Add("Content-Type", "application/json")

	if err != nil {
		fmt.Println("Error =0", err.Error())
	}

	client := &http.Client{Timeout: time.Duration(tmax) * time.Millisecond}
	req.Header.Add("x-openrtb-version", version)
	res, err := client.Do(req)

	if err != nil {
		curlchan <- []byte{}

		fmt.Println("REQ", req)
		fmt.Println("Error =1", err.Error())
		return
	}

	defer res.Body.Close()
	body, err := ioutil.ReadAll(res.Body)

	if err != nil {
		curlchan <- []byte{}
		fmt.Println("Error =2", err.Error())
		return
	}

	curlchan <- body
}
