package ad

import (
	"analytics/clickClient"
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"
	"ssp/constants"
	"ssp/curl"
	"ssp/logger"
	"ssp/rtbrequest25"
	"ssp/sspstructure"
	"strings"

	openrtb2 "github.com/mxmCherry/openrtb/openrtb2"
)

type bidderResponse struct {
	Bidderid       int
	At             int64   `json:"at"`
	SeconBidBuffer float64 `json:"seconBidBuffer"`
	Response       interface{}
}

func SSPAdProcess(channel chan map[string]interface{}, ReqArray *sspstructure.SSP_Req) {
	var (
		request25 *openrtb2.BidRequest
		jsonReq   []byte
		err       error
	)
	output := make(map[string]interface{})
	arrRes := bidderResponse{}
	reqChannel25 := make(chan *openrtb2.BidRequest)
	go rtbrequest25.RtbObjectCreator(reqChannel25, ReqArray)
	request25 = <-reqChannel25

	for _, v := range ReqArray.DSP {
		if v.Ver == "2.5" {
			request25.TMax = ReqArray.Tmax
			request25.AT = v.At
			jsonReq, err = json.Marshal(request25)
			if err != nil {
				fmt.Printf("Error :", err.Error())
			}
		}

		logger.Log.Printf("Request :%+v\n", string(jsonReq))

		// if request25.ID != "" && string(jsonReq) != "" {
		//request Json and request id stored in clickhouse

		// go Rtb_req_log_N(request25.ID, jsonReq)
		// }

		curlchan := make(chan []byte)

		Endpoint := strings.ReplaceAll(v.End_Url, "\n", "")
		go curl.SendReq(curlchan, jsonReq, Endpoint, v.Ver, ReqArray.Tmax)
		response := <-curlchan
		if len(response) > 0 {
			res25 := &openrtb2.BidResponse{}

			logger.Log.Printf("Response :%+v\n", string(response))

			// if request25.ID != "" && string(response) != "" {
			//response Json and request id stored in clickhouse
			// go Rtb_res_log_N(request25.ID, response)
			// }

			err = json.Unmarshal(response, res25)
			if err != nil {
				fmt.Println(err)
				fmt.Println("Error :", err.Error())
			}
			if res25 != nil {

				arrRes.Bidderid = v.Id
				arrRes.At = v.At
				arrRes.Response = res25

			}

		}

	}
	output["ads"] = arrRes
	channel <- output

}

func Rtb_req_log(req_id string, data []byte) {
	req, err := http.Post(constants.WebpathProtocol+constants.WebpathDelivery+"/Rtb_Req?req_id="+req_id, "application/json", bytes.NewBuffer(data))
	if err != nil {
		fmt.Println(err)
	}
	defer req.Body.Close()
}

func Rtb_req_log_N(req_id string, data []byte) {

	// fmt.Println("Request log")

	clickClient.RtbReq(req_id, string(data))
}

func Rtb_res_log(req_id string, data []byte) {
	req, err := http.Post(constants.WebpathProtocol+constants.WebpathDelivery+"/Rtb_Res?req_id="+req_id, "application/json", bytes.NewBuffer(data))
	if err != nil {
		fmt.Println(err)
	}
	defer req.Body.Close()
}

func Rtb_res_log_N(req_id string, data []byte) {

	clickClient.RtbRes(req_id, string(data))
}
