package main

import (
	"alpha/addelivery"
	"encoding/json"
	"fmt"
	"syscall/js"
)

func jsonWrapper() js.Func {
	jsonFunc := js.FuncOf(func(this js.Value, args []js.Value) any {
		if len(args) != 1 {
			return "Invalid no of arguments passed"
		}
		inputJSON := args[0].String()
		fmt.Printf("input %s\n", inputJSON)
		pretty, err := prettyJson(inputJSON)
		if err != nil {
			fmt.Printf("unable to convert to json %s\n", err)
			return err.Error()
		}
		return pretty
	})
	return jsonFunc
}

func prettyJson(input string) (string, error) {
	var raw any
	if err := json.Unmarshal([]byte(input), &raw); err != nil {
		return "", err
	}
	pretty, err := json.MarshalIndent(raw, "", "  ")
	if err != nil {
		return "", err
	}
	return string(pretty), nil
}

func getad(this js.Value, args []js.Value) interface{} {

	// counter := js.Global().Get("document").Call("getElementById", "counter")
	// counterValue, err := strconv.ParseInt(counter.Get("textContent").String(), 10, 64)
	// if err != nil {
	// 	return map[string]any{"error": err.Error()}
	// }
	// counterValue += int64(args[0].Int())

	// /*******************************/
	// // response, err := http.Get("https://ssp.admaru.com/AdAsync?tagid=1ba37de5-2c98-498a-95e3-39e5c3786808&tagidRand=Prebid_33613&loc=https://app.admaru.com&rand=bd7e4b0e50&Bid_CPM=7&Bid_Req=13c25feb-5df0-44ff-9cc0-2ae3d46ace86&Bid_providerid=e0d2bc8a-12fb-11ed-85f0-06de70a85b6d&Bid_Tag=1ba37de5-2c98-498a-95e3-39e5c3786808&Bid_adunitid=9e5faf9c-e125-4729-bc62-c0089306add6&Bid_AdSource=5e6980eb-b033-4bc3-918a-6d77bae5d3d8&requestId=13c25feb-5df0-44ff-9cc0-2ae3d46ace86&Is_MultiAd=yes&res_cur=USD")

	// // if err != nil {
	// // 	fmt.Print("error")
	// // }

	// // responseData, err := ioutil.ReadAll(response.Body)
	// // if err != nil {
	// // 	fmt.Print("error")
	// // }
	// // fmt.Println(string(responseData))

	// counter.Set("textContent", "asd")

	/**********************asd***************/

	response := addelivery.Testad(args)
	/*******************************/
	// response, err := http.Get("https://ssp.admaru.com/AdAsync?tagid=1ba37de5-2c98-498a-95e3-39e5c3786808&tagidRand=Prebid_33613&loc=https://app.admaru.com&rand=bd7e4b0e50&Bid_CPM=7&Bid_Req=13c25feb-5df0-44ff-9cc0-2ae3d46ace86&Bid_providerid=e0d2bc8a-12fb-11ed-85f0-06de70a85b6d&Bid_Tag=1ba37de5-2c98-498a-95e3-39e5c3786808&Bid_adunitid=9e5faf9c-e125-4729-bc62-c0089306add6&Bid_AdSource=5e6980eb-b033-4bc3-918a-6d77bae5d3d8&requestId=13c25feb-5df0-44ff-9cc0-2ae3d46ace86&Is_MultiAd=yes&res_cur=USD")

	// if err != nil {
	// 	fmt.Print("error")
	// }

	// responseData, err := ioutil.ReadAll(response.Body)
	// if err != nil {
	// 	fmt.Print("error")
	// }
	// fmt.Println(string(responseData))

	// return fmt.Sprint(response)
	return map[string]any{"message": fmt.Sprint(response)}
}

func main() {
	fmt.Println("Go Web Assembly")
	js.Global().Set("formatJSON", jsonWrapper())
	js.Global().Set("goAd", js.FuncOf(getad))
	<-make(chan bool)
}
