package validation

import (
	"log"
	"regexp"

	uuid "github.com/google/uuid"
)

func IsValidUUID(uuid string) bool {
	r := regexp.MustCompile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
	return r.MatchString(uuid)
}

func StringToUUID(id string) uuid.UUID {
	u3, err := uuid.Parse(id)
	if err != nil {
		log.Printf("failed to parse UUID %q: %v", u3, err)
	}
	return u3
}
