package tracking

import (
	"analytics/clickConnect"
	"context"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Track_Win struct {
	Date_time       proto.ColDateTime
	Request_id      proto.ColUUID
	Publisher_id    proto.ColUUID
	Adunit_id       proto.ColUUID
	Provider_id     proto.ColUUID
	Adsource_id     proto.ColUUID
	Tag_temp_id     proto.ColUUID
	Tag_id          proto.ColUUID
	Provider_src_id proto.ColUUID
	Win_count       proto.ColInt8
}

func Track_win(Client *ch.Client, win *Track_Win) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: win.Date_time},
		{Name: "request_id", Data: &win.Request_id},
		{Name: "publisher_id", Data: &win.Publisher_id},
		{Name: "adunit_id", Data: &win.Adunit_id},
		{Name: "provider_id", Data: &win.Provider_id},
		{Name: "adsource_id", Data: &win.Adsource_id},
		{Name: "tag_temp_id", Data: &win.Tag_temp_id},
		{Name: "tag_id", Data: &win.Tag_id},
		{Name: "provider_src_id", Data: &win.Provider_src_id},
		{Name: "win_count", Data: &win.Win_count},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("am_win_stats"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	return nil
}
